/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.lmc.support.helper;

import com.digiwin.dap.middleware.lmc.domain.AlertVo;
import com.digiwin.dap.middleware.lmc.domain.EnvProperties;
import com.digiwin.dap.middleware.lmc.support.alert.AlertMaker;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AlertHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(AlertHelper.class);
    private final List<AlertMaker> alertMakers;
    private final EnvProperties envProperties;

    @Autowired
    public AlertHelper(List<AlertMaker> alertMakers, EnvProperties envProperties) {
        this.alertMakers = alertMakers;
        this.envProperties = envProperties;
    }

    public Void doAlert(String msg, Throwable e, String payload) {
        AlertVo alertVo = new AlertVo(msg, e != null ? e.getMessage() : null, payload, this.envProperties.getDeployArea());
        for (AlertMaker alertMaker : this.alertMakers) {
            alertMaker.alert(alertVo);
        }
        return null;
    }
}

