/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.lmc.support.helper;

import com.digiwin.dap.middleware.lmc.constant.enums.LogTypeEnum;
import com.digiwin.dap.middleware.lmc.service.messaging.impl.KafkaMessagePublisher;
import com.digiwin.dap.middleware.lmc.support.elasticsearch.model.Document;
import com.digiwin.dap.middleware.lmc.support.elasticsearch.service.IElasticsearchService;
import com.digiwin.dap.middleware.lmc.support.helper.AlertHelper;
import com.digiwin.dap.middleware.util.JsonUtils;
import java.util.Objects;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Recover;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Component;

@Component
public class RetryHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(RetryHelper.class);
    @Autowired
    AlertHelper alertHelper;
    @Autowired
    private IElasticsearchService elasticsearchService;

    @Retryable(maxAttempts=1, backoff=@Backoff(delay=100L, multiplier=1.5), listeners={"DefaultRetryListener"})
    public void doPushRetry(Consumer<KafkaMessagePublisher.PublishBo> consumer, KafkaMessagePublisher.PublishBo publishBo) {
        consumer.accept(publishBo);
    }

    @Recover
    public void doPushRecover(Throwable throwable, Consumer<KafkaMessagePublisher.PublishBo> consumer, KafkaMessagePublisher.PublishBo publishBo) {
        if (throwable == null) {
            return;
        }
        LOGGER.warn("\u3010doPushRecover-\u63a8\u9001mq\u91cd\u8bd5\u3011\uff0c\u5f00\u59cb...", throwable);
        if (null == publishBo.getEsSuffixIndex() || publishBo.getPayloadBytes() == null) {
            LOGGER.error("\u3010doPushRecover-\u63a8\u9001mq\u91cd\u8bd5\u3011\uff0c\u505c\u6b62\u6b64\u91cd\u8bd5\u3002\u503c\u4e3a\u7a7a\uff0cesSuffixIndex={}, payloadBytes={}", (Object)publishBo.getEsSuffixIndex(), (Object)publishBo.getPayloadBytes());
            return;
        }
        LogTypeEnum logTypeEnum = LogTypeEnum.getLogTypeByContainsSuffix((String)publishBo.getEsSuffixIndex());
        if (logTypeEnum == null) {
            LOGGER.error("\u3010doPushRecover-\u63a8\u9001mq\u91cd\u8bd5\u3011\uff0c\u505c\u6b62\u6b64\u91cd\u8bd5\u3002\u672a\u77e5\u7684esSuffixIndex={}", (Object)publishBo.getEsSuffixIndex());
            return;
        }
        try {
            Object source = JsonUtils.createObjectMapper().readValue(publishBo.getPayloadBytes(), logTypeEnum.getaClass());
            if (Objects.nonNull(source)) {
                this.elasticsearchService.index((Document)source);
            }
        }
        catch (Exception e) {
            this.alertHelper.doAlert("\u63a8\u9001mq\u91cd\u8bd5-\u76f4\u8fdees\u544a\u8b66", (Throwable)e, new String(publishBo.getPayloadBytes()));
        }
    }
}

