/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.lmc.support.remote.impl;

import com.digiwin.dap.middleware.constant.GlobalConstants;
import com.digiwin.dap.middleware.lmc.domain.EnvProperties;
import com.digiwin.dap.middleware.lmc.domain.remote.NoticeMessageVO;
import com.digiwin.dap.middleware.lmc.support.remote.EmcService;
import com.digiwin.dap.middleware.util.UserUtils;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.web.client.RestTemplate;

@Service
public class EmcServiceImpl
implements EmcService {
    public static final Logger LOGGER = LoggerFactory.getLogger(EmcServiceImpl.class);
    @Autowired
    private EnvProperties envProperties;
    @Qualifier(value="customRestTemplate")
    @Autowired
    private RestTemplate customRestTemplate;

    public Object sendMessageEmail(String eventId, Object data) {
        if (ObjectUtils.isEmpty((Object)this.envProperties.getEmcUri())) {
            LOGGER.error("remote emc uri is empty, return null");
            return null;
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("Accept", "application/json;charset=UTF-8");
        headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
        NoticeMessageVO messageVO = new NoticeMessageVO();
        messageVO.setEventId(eventId);
        HashMap<String, Object> messageMap = new HashMap<String, Object>();
        messageMap.put("data", data);
        messageVO.setMessage(messageMap);
        HttpEntity httpEntity = new HttpEntity((Object)messageVO, (MultiValueMap)headers);
        String uri = this.envProperties.getEmcUri() + "/api/emc/v1/message/email";
        LOGGER.info("email uri={}", (Object)uri);
        ResponseEntity responseEntity = this.customRestTemplate.postForEntity(uri, (Object)httpEntity, Object.class, new Object[0]);
        return responseEntity.getBody();
    }
}

