/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.lmc.support.remote.impl;

import com.beust.jcommander.internal.Lists;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.lmc.domain.EnvProperties;
import com.digiwin.dap.middleware.lmc.domain.remote.esp.EspEaiLogsResponse;
import com.digiwin.dap.middleware.lmc.domain.remote.esp.EspProdListResponse;
import com.digiwin.dap.middleware.lmc.domain.remote.esp.EspSolutionRequest;
import com.digiwin.dap.middleware.lmc.domain.remote.esp.EspSolutionResponse;
import com.digiwin.dap.middleware.lmc.domain.remote.esp.EspStateCodeResponse;
import com.digiwin.dap.middleware.lmc.support.remote.IEspService;
import com.digiwin.dap.middleware.util.JsonUtils;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class IEspServiceImpl
implements IEspService {
    private static final Logger LOGGER = LoggerFactory.getLogger(IEspServiceImpl.class);
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private RestTemplate restTemplate;

    public EspProdListResponse getProdList() {
        EspProdListResponse espProdListResponse = new EspProdListResponse();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        String url = this.envProperties.getEspUri() + this.envProperties.getEspApiGetProdList();
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            if (!HttpStatus.OK.equals((Object)responseEntity.getStatusCode())) {
                return espProdListResponse;
            }
            return (EspProdListResponse)responseEntity.getBody();
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage(), (Throwable)e);
        }
    }

    public List<EspStateCodeResponse> getStateCodes() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        String url = this.envProperties.getEspUri() + this.envProperties.getEspApiGetStateCodes();
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            if (!HttpStatus.OK.equals((Object)responseEntity.getStatusCode())) {
                return Lists.newArrayList();
            }
            return (List)responseEntity.getBody();
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage(), (Throwable)e);
        }
    }

    public List<EspSolutionResponse> getSolution(EspSolutionRequest request) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        String params = JsonUtils.objToJson((Object)request);
        HttpEntity httpEntity = new HttpEntity((Object)params, (MultiValueMap)headers);
        String url = this.envProperties.getEspUri() + this.envProperties.getEspApiGetSolution();
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            if (!HttpStatus.OK.equals((Object)responseEntity.getStatusCode())) {
                return Lists.newArrayList();
            }
            return (List)responseEntity.getBody();
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage(), (Throwable)e);
        }
    }

    public EspEaiLogsResponse getEaiLogs(String reqId, String tenantId) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("req_id", reqId);
        paramMap.put("tenant_id", tenantId);
        String params = JsonUtils.objToJson(paramMap);
        HttpEntity httpEntity = new HttpEntity((Object)params, (MultiValueMap)headers);
        String url = this.envProperties.getEspUri() + this.envProperties.getEspApiGetEaiLogs();
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            if (!HttpStatus.OK.equals((Object)responseEntity.getStatusCode())) {
                return null;
            }
            return (EspEaiLogsResponse)responseEntity.getBody();
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage(), (Throwable)e);
        }
    }
}

