/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.lmc.support.remote.impl;

import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.auth.LoginInfo;
import com.digiwin.dap.middleware.constant.GlobalConstants;
import com.digiwin.dap.middleware.domain.CommonErrorCode;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.exception.ThirdCallException;
import com.digiwin.dap.middleware.lmc.domain.CommonVO;
import com.digiwin.dap.middleware.lmc.domain.EnvProperties;
import com.digiwin.dap.middleware.lmc.domain.oplog.ChangeQuery;
import com.digiwin.dap.middleware.lmc.domain.page.PageData;
import com.digiwin.dap.middleware.lmc.domain.remote.LoginHistoryVO;
import com.digiwin.dap.middleware.lmc.support.remote.IamService;
import com.digiwin.dap.middleware.support.DapHttpService;
import com.digiwin.dap.middleware.util.UserUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Service
public class IamServiceImpl
implements IamService {
    private static final Logger logger = LoggerFactory.getLogger(IamServiceImpl.class);
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private RestTemplate restTemplate;
    @Qualifier(value="dapRetryRestTemplate")
    @Autowired
    private RestTemplate retryRestTemplate;
    @Autowired
    private DapHttpService dapHttpService;

    public PageData<LoginHistoryVO> getLoginHistories(ChangeQuery changeQuery, String userToken) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("Accept", "application/json;charset=UTF-8");
        headers.add("digi-middleware-auth-user", userToken);
        headers.add("Connection", "close");
        HttpEntity request = new HttpEntity((Object)changeQuery, (MultiValueMap)headers);
        logger.info("\u8bf7\u6c42iam\u6570\u636e pageIndex = {}, pageSize = {}, count = {}", new Object[]{changeQuery.getPageIndex(), changeQuery.getPageSize(), changeQuery.getPageIndex() * changeQuery.getPageSize()});
        String url = this.envProperties.getIamUri() + String.format("/api/iam/v2/loginhistory?pageNum=%s&pageSize=%s&orderBy=h.sid DESC", changeQuery.getPageIndex(), changeQuery.getPageSize());
        ResponseEntity responseEntity = this.retryRestTemplate.exchange(url, HttpMethod.POST, request, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
        return (PageData)responseEntity.getBody();
    }

    public Map<String, Object> getRowPermission(String userToken, String iamUri) {
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, userToken);
            HashMap<String, String> requestContent = new HashMap<String, String>(3);
            requestContent.put("sysId", "mmc");
            requestContent.put("moduleId", "logger-manager-center");
            requestContent.put("actionId", "logger-settings-app");
            HttpEntity request = new HttpEntity(requestContent, (MultiValueMap)headers);
            String url = Optional.ofNullable(iamUri).filter(StringUtils::hasLength).orElse(this.envProperties.getIamUri()) + "/api/iam/v2/permission/data/row";
            ResponseEntity responseEntity = this.retryRestTemplate.exchange(url, HttpMethod.POST, request, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            return (Map)responseEntity.getBody();
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6570\u636e\u6743\u9650\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            return Collections.emptyMap();
        }
    }

    public List<CommonVO> getCurrentTenantDevApp(String userToken, String iamUri) {
        HashMap<String, Integer> uriVariablesMap = new HashMap<String, Integer>();
        uriVariablesMap.put("pageNum", 1);
        uriVariablesMap.put("pageSize", 999999);
        HttpHeaders headers = new HttpHeaders();
        headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, userToken);
        HttpEntity request = new HttpEntity((MultiValueMap)headers);
        try {
            String url = Optional.ofNullable(iamUri).filter(StringUtils::hasLength).orElse(this.envProperties.getIamUri()) + "/api/iam/v2/dev/app/currentTenant" + "?pageNum={pageNum}&pageSize={pageSize}";
            ResponseEntity responseEntity = this.retryRestTemplate.exchange(url, HttpMethod.GET, request, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, uriVariablesMap);
            return Optional.ofNullable(responseEntity.getBody()).map(StdData::getData).map(PageData::getList).orElse(Collections.emptyList());
        }
        catch (Exception e) {
            logger.error("\u3010iam\u8c03\u7528\u3011\u83b7\u53d6\u5f00\u53d1\u5546\u5e94\u7528\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public List<CommonVO> getTenantIdsBySids(Collection<Long> tenantSids) {
        String url = this.envProperties.getIamUri() + "/api/iam/v2/tenant/getname/list";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
        HttpEntity request = new HttpEntity(tenantSids, (MultiValueMap)headers);
        try {
            ResponseEntity responseEntity = this.retryRestTemplate.exchange(url, HttpMethod.POST, request, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            return Optional.ofNullable(responseEntity.getBody()).orElseGet(Collections::emptyList);
        }
        catch (Exception e) {
            throw new BusinessException(CommonErrorCode.BUSINESS.getErrorMessage(), (Throwable)e);
        }
    }

    public String getUserToken(String tenantId, String iamUri) {
        return this.dapHttpService.getUserToken(tenantId, iamUri);
    }

    public AuthoredUser getUserInfo(String userToken, String iamUri) {
        String uri = iamUri + "/api/iam/v2/identity/token/analyze";
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, userToken);
            HttpEntity request = new HttpEntity((MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(uri, HttpMethod.POST, request, LoginInfo.class, new Object[0]);
            return Optional.ofNullable(response.getBody()).map(x -> {
                x.setToken(userToken);
                return x.getAuthoredUser();
            }).orElse(new AuthoredUser());
        }
        catch (Exception e) {
            throw new ThirdCallException((ErrorHandler)CommonErrorCode.USER_TOKEN_INVALID, uri, e);
        }
    }
}

