/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.lmc.support.remote.thirdparty.impl;

import cn.hutool.cache.CacheUtil;
import cn.hutool.cache.impl.TimedCache;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.lmc.domain.EnvProperties;
import com.digiwin.dap.middleware.lmc.domain.remote.pinpoint.ApplicationVO;
import com.digiwin.dap.middleware.lmc.support.remote.thirdparty.RemotePinpiontService;
import com.digiwin.dap.middleware.lmc.util.JsonUtils;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class RemotePinpiontServiceImpl
implements RemotePinpiontService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemotePinpiontServiceImpl.class);
    @Autowired
    private EnvProperties envProperties;
    @Qualifier(value="dapRetryRestTemplate")
    @Autowired
    private RestTemplate retryRestTemplate;
    private static final TimedCache<String, String> TIMED_CACHE = CacheUtil.newTimedCache((long)10800000L);

    public List<ApplicationVO> getPinpointApplications(String url) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity request = new HttpEntity((MultiValueMap)headers);
        try {
            ResponseEntity responseEntity = this.retryRestTemplate.exchange(url + "/applications.pinpoint", HttpMethod.GET, request, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            return (List)responseEntity.getBody();
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6pinpoint applications\u4fe1\u606f\u5931\u8d25\uff0curl\uff1a{}", (Object)url, (Object)e);
            return Collections.emptyList();
        }
    }

    public String getPinpointUrl(String traceId) {
        String[] arr = traceId.split("\\^");
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("agentId", arr[0]);
        param.put("traceId", traceId);
        param.put("collectorAcceptTime", "0");
        param.put("spanId", "-1");
        try {
            return this.envProperties.getPinpointUri() + "/transactionDetail?transactionInfo=" + URLEncoder.encode(JsonUtils.writeValueAsString(param), "UTF-8");
        }
        catch (Exception e) {
            LOGGER.error("pinpointUrl\u5904\u7406\u5f02\u5e38", (Throwable)e);
            throw new BusinessException((Throwable)e);
        }
    }

    public void clearTimedCache() {
        TIMED_CACHE.clear();
    }
}

