/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.lmc.support.schedule.impl;

import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.lmc.constant.DateConstant;
import com.digiwin.dap.middleware.lmc.constant.enums.LogTypeEnum;
import com.digiwin.dap.middleware.lmc.constant.enums.MailTypeEnum;
import com.digiwin.dap.middleware.lmc.constant.enums.SaveDaysEnum;
import com.digiwin.dap.middleware.lmc.domain.EnvProperties;
import com.digiwin.dap.middleware.lmc.domain.TimeRange;
import com.digiwin.dap.middleware.lmc.domain.elasticsearch.ElasticsearchIndexStats;
import com.digiwin.dap.middleware.lmc.domain.elasticsearch.ExecuteDTO;
import com.digiwin.dap.middleware.lmc.entity.logsetting.AppSetting;
import com.digiwin.dap.middleware.lmc.entity.stats.StatsCountDetail;
import com.digiwin.dap.middleware.lmc.repository.AppSettingRepository;
import com.digiwin.dap.middleware.lmc.repository.DevLogRepository;
import com.digiwin.dap.middleware.lmc.repository.EventLogRepository;
import com.digiwin.dap.middleware.lmc.repository.OpLogRepository;
import com.digiwin.dap.middleware.lmc.repository.StatsCountDetailRepository;
import com.digiwin.dap.middleware.lmc.repository.StatsDiskDetailRepository;
import com.digiwin.dap.middleware.lmc.service.business.AppSettingService;
import com.digiwin.dap.middleware.lmc.support.cache.MongoDistributedLockV2;
import com.digiwin.dap.middleware.lmc.support.elasticsearch.service.IElasticsearchService;
import com.digiwin.dap.middleware.lmc.support.remote.EmcService;
import com.digiwin.dap.middleware.lmc.support.schedule.ScheduleTaskService;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ScheduleTaskServiceImpl
implements ScheduleTaskService {
    private static final Logger logger = LoggerFactory.getLogger(ScheduleTaskServiceImpl.class);
    public static final long SHORT_SLEEP_MILLIS = 1500L;
    public static final long SLEEP_MILLIS = 3000L;
    public static final long EXPIRE_MILLIS = 120L;
    private static final int NUMBER_OF_SEGMENTS = 12;
    @Autowired
    protected OpLogRepository opLogRepository;
    @Autowired
    protected EventLogRepository eventLogRepository;
    @Autowired
    protected DevLogRepository devLogRepository;
    @Autowired
    protected MongoTemplate mongoTemplate;
    @Autowired
    protected AppSettingService appSettingService;
    @Autowired
    protected EnvProperties envProperties;
    @Qualifier(value="customRestTemplate")
    @Autowired
    protected RestTemplate customRestTemplate;
    @Autowired
    protected RestTemplate restTemplate;
    @Autowired
    private AppSettingRepository appSettingRepository;
    @Autowired
    private StatsDiskDetailRepository statsDiskDetailRepository;
    @Autowired
    private StatsCountDetailRepository statsCountDetailRepository;
    @Autowired
    private EmcService emcService;
    @Autowired
    private MongoDistributedLockV2 mongoDistributedLockV2;
    @Autowired
    private IElasticsearchService elasticsearchService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    @Scheduled(cron="0 10 1 * * ?")
    public void deleteLogs() {
        try {
            boolean lock = this.mongoDistributedLockV2.getLock("lmc-schedule-task-01", 120L);
            if (lock) {
                int numberOfSegments = Optional.ofNullable(this.envProperties.getLogMongoDBDeleteCount()).orElse(12);
                LocalDateTime now = LocalDateTime.now();
                logger.info("-->>\u6267\u884c[\u5220\u9664MongoDB\u8fc7\u671f\u65e5\u5fd7]\u5b9a\u65f6\u4efb\u52a1\u65f6\u95f4: {}", (Object)now);
                List apps = this.appSettingRepository.findAll();
                ArrayList appIdList = new ArrayList();
                apps.forEach(app -> {
                    long deleteOpLogCount = 0L;
                    long deleteEventLogCount = 0L;
                    long deleteDevLogCount = 0L;
                    try {
                        logger.info("{}\u5220\u9664 \u65e5\u5fd7\u5f00\u59cb...", (Object)app.getAppId());
                        int changeLogSaveDays = Optional.ofNullable(app.getChangeLogSaveDays()).orElse(SaveDaysEnum.OPLOG_SAVE_DAYS_30.getDays());
                        if (SaveDaysEnum.LOG_SAVE_DAYS_FOREVER.getDays() != changeLogSaveDays) {
                            LocalDateTime end = now.minusDays(changeLogSaveDays);
                            List rangeList = ScheduleTaskServiceImpl.segmentTimeByNumberOfSegments((LocalDateTime)end.minusDays(1L), (LocalDateTime)end, (int)numberOfSegments);
                            for (Object timeRange : rangeList) {
                                Query query = Query.query((CriteriaDefinition)Criteria.where((String)"createDate").gt((Object)timeRange.getStart()).lt((Object)timeRange.getEnd()));
                                long deletedCount = this.opLogRepository.deleteByQuery2(query, app.getAppId() + "_oplog");
                                logger.info("{}\u5220\u9664 index: {}\uff0c\u64cd\u4f5c\u65e5\u5fd7\u6761\u6570\uff1a{}\uff0cstart\uff1a{}\uff0cend\uff1a{}", new Object[]{app.getAppId(), rangeList.indexOf(timeRange), deletedCount, timeRange.getStart(), timeRange.getEnd()});
                                deleteOpLogCount += deletedCount;
                                if (deletedCount == 0L) continue;
                                Thread.sleep(1500L);
                            }
                        }
                        int eventLogSaveDays = Optional.ofNullable(app.getEventLogSaveDays()).orElse(SaveDaysEnum.EVENTLOG_SAVE_DAYS_30.getDays());
                        if (SaveDaysEnum.LOG_SAVE_DAYS_FOREVER.getDays() != eventLogSaveDays) {
                            LocalDateTime end = now.minusDays(eventLogSaveDays);
                            List rangeList = ScheduleTaskServiceImpl.segmentTimeByNumberOfSegments((LocalDateTime)end.minusDays(1L), (LocalDateTime)end, (int)numberOfSegments);
                            for (TimeRange timeRange : rangeList) {
                                Query query = Query.query((CriteriaDefinition)Criteria.where((String)"createDate").gt((Object)timeRange.getStart()).lt((Object)timeRange.getEnd()));
                                long deletedCount = this.eventLogRepository.deleteByQuery2(query, app.getAppId() + "_eventlog");
                                logger.info("{}\u5220\u9664 index: {}\uff0c\u4e8b\u4ef6\u65e5\u5fd7\u6761\u6570\uff1a{}\uff0cstart\uff1a{}\uff0cend\uff1a{}", new Object[]{app.getAppId(), rangeList.indexOf(timeRange), deletedCount, timeRange.getStart(), timeRange.getEnd()});
                                deleteEventLogCount += deletedCount;
                                if (deletedCount == 0L) continue;
                                Thread.sleep(1500L);
                            }
                        }
                        int devLogSaveDays = Optional.ofNullable(app.getDevLogSaveDays()).orElse(SaveDaysEnum.DEVLOG_SAVE_DAYS_7.getDays());
                        if (SaveDaysEnum.LOG_SAVE_DAYS_FOREVER.getDays() != devLogSaveDays) {
                            LocalDateTime end = now.minusDays(devLogSaveDays);
                            List rangeList = ScheduleTaskServiceImpl.segmentTimeByNumberOfSegments((LocalDateTime)end.minusDays(1L), (LocalDateTime)end, (int)numberOfSegments);
                            for (TimeRange timeRange : rangeList) {
                                Query query = Query.query((CriteriaDefinition)Criteria.where((String)"time").gt((Object)DateConstant.DATE_TIME_FORMATTER.format(timeRange.getStart())).lt((Object)DateConstant.DATE_TIME_FORMATTER.format(timeRange.getEnd())));
                                long deletedCount = this.devLogRepository.deleteByQuery2(query, app.getAppId() + "_devlog");
                                logger.info("{}\u5220\u9664 index: {}\uff0c\u7cfb\u7edf\u65e5\u5fd7\u6761\u6570\uff1a{}\uff0cstart\uff1a{}\uff0cend\uff1a{}", new Object[]{app.getAppId(), rangeList.indexOf(timeRange), deletedCount, timeRange.getStart(), timeRange.getEnd()});
                                deleteDevLogCount += deletedCount;
                                if (deletedCount == 0L) continue;
                                Thread.sleep(1500L);
                            }
                        }
                        logger.info("{}\u5220\u9664\u603b\u91cf -> \u64cd\u4f5c\u65e5\u5fd7\u6761\u6570\uff1a{}\uff0c\u4e8b\u4ef6\u65e5\u5fd7\u6761\u6570\uff1a{}\uff0c\u7cfb\u7edf\u65e5\u5fd7\u6761\u6570\uff1a{}", new Object[]{app.getAppId(), deleteOpLogCount, deleteEventLogCount, deleteDevLogCount});
                        if (deleteOpLogCount + deleteEventLogCount + deleteDevLogCount != 0L) {
                            Thread.sleep(1500L);
                        }
                    }
                    catch (Exception e) {
                        appIdList.add(app.getAppId());
                        logger.error("{}\u5220\u9664\u65e5\u5fd7\u5931\u8d25...", (Object)app.getAppId(), (Object)e);
                    }
                });
                logger.info("<<--\u5b8c\u6210[\u5220\u9664\u8fc7\u671f\u65e5\u5fd7]\u5b9a\u65f6\u4efb\u52a1\u65f6\u95f4: {}", (Object)LocalDateTime.now());
                this.sendEmail(appIdList);
                Thread.sleep(1500L);
            }
        }
        catch (Exception e) {
            logger.error("\u6267\u884c[\u5220\u9664MongoDB\u65e5\u5fd7]\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Throwable)e);
        }
        finally {
            this.mongoDistributedLockV2.releaseLock("lmc-schedule-task-01");
        }
    }

    @Async
    @Scheduled(cron="0 30 1 * * ?")
    public void deleteEsByDays() {
        if (!this.envProperties.getLogESEnabled()) {
            return;
        }
        try {
            boolean lock = this.mongoDistributedLockV2.getLock("lmc-schedule-task-04", 120L);
            if (!lock) {
                return;
            }
            logger.info("-->>\u6267\u884c[\u5220\u9664\u8fc7\u671fES\u65e5\u5fd7]\u5b9a\u65f6\u4efb\u52a1\u65f6\u95f4: {}", (Object)LocalDateTime.now());
            List apps = this.appSettingRepository.findAll();
            apps.forEach(app -> {
                try {
                    logger.info("{}\u5220\u9664ES\u65e5\u5fd7\u5f00\u59cb...", (Object)app.getAppId());
                    int esEventLogSaveDays = Optional.ofNullable(app.getEsEventLogSaveDays()).orElse(SaveDaysEnum.ES_EVENTLOG_SAVE_DAYS.getDays());
                    int esDevLogSaveDays = Optional.ofNullable(app.getEsDevLogSaveDays()).orElse(SaveDaysEnum.ES_DEVLOG_SAVE_DAYS.getDays());
                    if (SaveDaysEnum.LOG_SAVE_DAYS_FOREVER.getDays() != esEventLogSaveDays) {
                        this.devLogRepository.deleteEsAsyncByDays(app.getAppId(), Integer.valueOf(esEventLogSaveDays), LogTypeEnum.EVENT_LOG);
                    }
                    Thread.sleep(3000L);
                    if (SaveDaysEnum.LOG_SAVE_DAYS_FOREVER.getDays() != esDevLogSaveDays) {
                        this.devLogRepository.deleteEsAsyncByDays(app.getAppId(), Integer.valueOf(esDevLogSaveDays), LogTypeEnum.DEV_LOG);
                    }
                    Thread.sleep(3000L);
                }
                catch (Exception e) {
                    logger.error("{}\u5220\u9664ES\u65e5\u5fd7\u5931\u8d25...", (Object)app.getAppId(), (Object)e);
                }
            });
            logger.info("<<--\u5b8c\u6210[\u5220\u9664\u8fc7\u671fES\u65e5\u5fd7]\u5b9a\u65f6\u4efb\u52a1\u65f6\u95f4: {}", (Object)LocalDateTime.now());
        }
        catch (Exception e) {
            logger.error("\u6267\u884c[\u5220\u9664\u8fc7\u671fES\u65e5\u5fd7]\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Throwable)e);
        }
        finally {
            this.mongoDistributedLockV2.releaseLock("lmc-schedule-task-04");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    @Scheduled(cron="0 40 0 * * ?")
    public void forceMergeEsIndex() {
        if (!this.envProperties.getLogESEnabled()) {
            return;
        }
        try {
            boolean lock = this.mongoDistributedLockV2.getLock("lmc-schedule-task-07", 120L);
            if (!lock) {
                return;
            }
            logger.info("-->>\u6267\u884c[\u91ca\u653eES\u7d22\u5f15\u5b58\u50a8\u7f13\u5b58\u788e\u7247]\u5b9a\u65f6\u4efb\u52a1\u65f6\u95f4: {}", (Object)LocalDateTime.now());
            ExecuteDTO dto = new ExecuteDTO();
            dto.setMethod("GET");
            dto.setEndpoint("/_cat/indices/lmc*?format=json&h=index,docs.count,docs.deleted,store.size");
            String json = this.elasticsearchService.executeDsl(dto.getDslMap(), dto.getMethod(), dto.getEndpoint());
            List list = (List)JsonUtils.jsonToObj((String)json, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            logger.info("\u67e5\u8be2\u51falmc\u7d22\u5f15\u6570\u91cf: {}", (Object)list.size());
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ElasticsearchIndexStats indexStats = (ElasticsearchIndexStats)iterator.next();
                long count = Long.parseLong(indexStats.getDocsCount());
                if (count == 0L) {
                    iterator.remove();
                    continue;
                }
                long deleted = Long.parseLong(indexStats.getDocsDeleted());
                if (deleted >= count) continue;
                iterator.remove();
            }
            if (!list.isEmpty()) {
                logger.info("\u672c\u6b21\u8fdb\u884c\u6bb5\u5408\u5e76\u7684\u7d22\u5f15\u6570\u91cf\uff1a{}, \u503c\u4e3a\uff1a{}", (Object)list.size(), list.stream().map(ElasticsearchIndexStats::getIndex).collect(Collectors.toList()));
                for (ElasticsearchIndexStats indexStats : list) {
                    long start = System.currentTimeMillis();
                    logger.info("\u7d22\u5f15\u6bb5\u5408\u5e76\u5f00\u59cb: {}, \u7d22\u5f15\u5927\u5c0f\uff1a{}", (Object)indexStats.getIndex(), (Object)indexStats.getStoreSize());
                    ExecuteDTO executeDTO = new ExecuteDTO();
                    executeDTO.setMethod("POST");
                    executeDTO.setEndpoint("/" + indexStats.getIndex() + "/_forcemerge?only_expunge_deletes=true");
                    try {
                        this.elasticsearchService.executeDsl(executeDTO.getDslMap(), executeDTO.getMethod(), executeDTO.getEndpoint());
                    }
                    catch (Exception e) {
                        logger.error("\u7d22\u5f15\u6bb5\u5408\u5e76\u5931\u8d25: {}, \u9519\u8bef\u4fe1\u606f: {}", (Object)indexStats.getIndex(), (Object)e.getMessage());
                        continue;
                    }
                    logger.info("\u7d22\u5f15\u6bb5\u5408\u5e76\u5b8c\u6210: {}, \u8017\u65f6\uff1a{}s", (Object)indexStats.getIndex(), (Object)((System.currentTimeMillis() - start) / 1000L));
                    Thread.sleep(1500L);
                }
            }
            logger.info("<<--\u5b8c\u6210[\u91ca\u653eES\u7d22\u5f15\u5b58\u50a8\u7f13\u5b58\u788e\u7247]\u5b9a\u65f6\u4efb\u52a1\u65f6\u95f4: {}", (Object)LocalDateTime.now());
        }
        catch (Exception e) {
            logger.error("\u6267\u884c[\u91ca\u653eES\u7d22\u5f15\u5b58\u50a8\u7f13\u5b58\u788e\u7247]\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Throwable)e);
        }
        finally {
            this.mongoDistributedLockV2.releaseLock("lmc-schedule-task-07");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    @Scheduled(cron="0 20 6 * * ?")
    public void getLogsCount() {
        block10: {
            try {
                boolean lock = this.mongoDistributedLockV2.getLock("lmc-schedule-task-03", 120L);
                if (!lock || !Boolean.TRUE.equals(this.envProperties.getLogCountEnabled())) break block10;
                logger.info("-->>\u6267\u884c[\u67e5\u8be2\u65e5\u5fd7\u603b\u91cf]\u5b9a\u65f6\u4efb\u52a1\u65f6\u95f4: {}", (Object)LocalDateTime.now());
                LinkedHashMap<String, Object> envMap = new LinkedHashMap<String, Object>();
                envMap.put("\u5f00\u53d1\u533a", "http://172.16.2.141:22623");
                envMap.put("\u963f\u91ccPaas", "https://lmc-paas.digiwincloud.com.cn");
                envMap.put("\u963f\u91cc\u6d4b\u8bd5", "https://lmc-test.digiwincloud.com.cn");
                envMap.put("\u5fae\u8f6f\u6d4b\u8bd5", "https://lmc-test.digiwincloud.com");
                envMap.put("\u534e\u4e3a\u6d4b\u8bd5", "https://lmc-hw-test.digiwincloud.com.cn");
                envMap.put("\u963f\u91cc\u6b63\u5f0f", "https://lmc.digiwincloud.com.cn");
                envMap.put("\u5fae\u8f6f\u6b63\u5f0f", "https://lmc.digiwincloud.com");
                envMap.put("\u534e\u4e3a\u6b63\u5f0f", "https://lmc-hw.digiwincloud.com.cn");
                LinkedHashMap newEnvMap = new LinkedHashMap();
                for (Map.Entry entry : envMap.entrySet()) {
                    Map map;
                    String key = (String)entry.getKey();
                    Object value = entry.getValue();
                    if ("prod".equals(this.envProperties.getActive()) && "\u5f00\u53d1\u533a".equals(key)) {
                        envMap.put(key, Collections.singletonMap("", Collections.emptyMap()));
                        continue;
                    }
                    long startTime = System.currentTimeMillis();
                    logger.info("{} \u5f00\u59cb\u65f6\u95f4 {}", (Object)key, (Object)LocalDateTime.now());
                    String url = value + "/api/lmc/v1/logsetting/log/total";
                    try {
                        ResponseEntity responseEntity = this.customRestTemplate.exchange(url, HttpMethod.GET, null, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
                        logger.info("{} \u7ed3\u675f\u65f6\u95f4 {}, \u8017\u65f6 = {}ms", new Object[]{key, LocalDateTime.now(), System.currentTimeMillis() - startTime});
                        StdData body = (StdData)responseEntity.getBody();
                        map = Optional.ofNullable(body).map(StdData::getData).orElse(Collections.emptyMap());
                    }
                    catch (Exception e) {
                        logger.info("{} \u5931\u8d25\u65f6\u95f4 {}, \u8017\u65f6 = {}ms", new Object[]{key, LocalDateTime.now(), System.currentTimeMillis() - startTime});
                        logger.error("\u8bbf\u95ee\u3010{}\u3011\uff1a{} \u5931\u8d25", new Object[]{key, value, e});
                        map = Collections.singletonMap("", Collections.emptyMap());
                    }
                    if (map.containsKey("mongoDB")) {
                        newEnvMap.put(key, map.get("mongoDB"));
                        if (!map.containsKey("elasticsearch")) continue;
                        newEnvMap.put(key + "-ES", map.get("elasticsearch"));
                        newEnvMap.put(key + "-indexStorageSpace", map.get("indexStorageSpace"));
                        continue;
                    }
                    newEnvMap.put(key, map);
                }
                Object object = this.emcService.sendMessageEmail(MailTypeEnum.LMC_LOG_COUNT_EMAIL.name(), newEnvMap);
                logger.info("<<--\u5b8c\u6210[\u67e5\u8be2\u65e5\u5fd7\u603b\u91cf]\u5b9a\u65f6\u4efb\u52a1\u65f6\u95f4: {}, \u90ae\u4ef6{}", (Object)LocalDateTime.now(), object);
                Thread.sleep(3000L);
            }
            catch (Exception e) {
                logger.error("\u6267\u884c[\u67e5\u8be2\u65e5\u5fd7\u603b\u91cf]\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Throwable)e);
            }
            finally {
                this.mongoDistributedLockV2.releaseLock("lmc-schedule-task-03");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    @Scheduled(cron="0 20 7 * * ?")
    public void countLogs() {
        try {
            boolean lock = this.mongoDistributedLockV2.getLock("lmc-schedule-task-06", 120L);
            if (lock) {
                logger.info("\u7edf\u8ba1\u5f53\u524d\u65e5\u5fd7\u603b\u91cf \u5f00\u59cb --->>>");
                List apps = this.appSettingRepository.findAll();
                if (apps.isEmpty()) {
                    return;
                }
                ArrayList<StatsCountDetail> statsCountDetailList = new ArrayList<StatsCountDetail>();
                Query emptyQuery = new Query();
                LocalDateTime now = LocalDateTime.now();
                for (AppSetting app : apps) {
                    long devLogCount = this.devLogRepository.count(emptyQuery, app.getAppId() + "_devlog");
                    long eventLogCount = this.eventLogRepository.count(emptyQuery, app.getAppId() + "_eventlog");
                    long opLogCount = this.opLogRepository.count(emptyQuery, app.getAppId() + "_oplog");
                    statsCountDetailList.add(new StatsCountDetail(app.getAppId(), Long.valueOf(devLogCount), Long.valueOf(eventLogCount), Long.valueOf(opLogCount), now));
                }
                this.statsCountDetailRepository.insert(statsCountDetailList);
                logger.info("\u7edf\u8ba1\u5f53\u524d\u65e5\u5fd7\u603b\u91cf \u7ed3\u675f size={} <<<---", (Object)statsCountDetailList.size());
                Thread.sleep(3000L);
            }
        }
        catch (Exception e) {
            logger.error("\u6267\u884c[\u7edf\u8ba1\u5f53\u524d\u65e5\u5fd7\u603b\u91cf]\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Throwable)e);
        }
        finally {
            this.mongoDistributedLockV2.releaseLock("lmc-schedule-task-06");
        }
    }

    @Async
    @Scheduled(cron="0 20 23 * * ?")
    public void createIndex() {
        try {
            boolean lock = this.mongoDistributedLockV2.getLock("lmc-schedule-task-02", 120L);
            if (lock) {
                logger.info("-->>\u6267\u884c[\u521b\u5efa\u7d22\u5f15]\u5b9a\u65f6\u4efb\u52a1\u65f6\u95f4: {}", (Object)LocalDateTime.now());
                this.appSettingService.createIndex();
                logger.info("<<--\u5b8c\u6210[\u521b\u5efa\u7d22\u5f15]\u5b9a\u65f6\u4efb\u52a1\u65f6\u95f4: {}", (Object)LocalDateTime.now());
                Thread.sleep(3000L);
            }
        }
        catch (Exception e) {
            logger.error("\u6267\u884c[\u521b\u5efa\u7d22\u5f15]\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Throwable)e);
        }
        finally {
            this.mongoDistributedLockV2.releaseLock("lmc-schedule-task-02");
        }
    }

    @Async
    @Scheduled(cron="0 0 0/1 * * ?")
    public void statsDiskDetail() {
        boolean lock = false;
        try {
            lock = this.mongoDistributedLockV2.getLock("lmc-schedule-task-05", 120L);
            if (!lock) {
                return;
            }
            if (this.envProperties.getLogMongoDBEnabled().booleanValue()) {
                this.statsDiskDetailRepository.statsDiskDetail();
            } else {
                this.statsDiskDetailRepository.statsDiskDetailFromElasticsearch();
            }
            Thread.sleep(3000L);
        }
        catch (Exception e) {
            logger.error("\u6267\u884c[\u7edf\u8ba1\u7cfb\u7edf\u65e5\u5fd7\u5927\u5c0f]\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Throwable)e);
        }
        finally {
            if (lock) {
                this.mongoDistributedLockV2.releaseLock("lmc-schedule-task-05");
            }
        }
    }

    public static List<TimeRange> segmentTimeByNumberOfSegments(LocalDateTime startTime, LocalDateTime endTime, int numberOfSegments) {
        ArrayList<TimeRange> segments = new ArrayList<TimeRange>();
        long totalMinutes = ChronoUnit.MINUTES.between(startTime, endTime);
        long minutesPerSegment = totalMinutes / (long)numberOfSegments;
        LocalDateTime currentStart = startTime;
        for (int i = 0; i < numberOfSegments; ++i) {
            LocalDateTime currentEnd = currentStart.plusMinutes(minutesPerSegment);
            if (i == numberOfSegments - 1) {
                currentEnd = endTime;
            }
            segments.add(new TimeRange(currentStart, currentEnd));
            currentStart = currentEnd;
        }
        segments.add(new TimeRange(startTime.minusYears(1L), startTime));
        return segments;
    }

    private void sendEmail(List<String> appIdList) {
        if (!appIdList.isEmpty()) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("appIdList", appIdList);
            data.put("deployArea", this.envProperties.getDeployArea());
            data.put("iamUri", this.envProperties.getIamUri());
            Object body = this.emcService.sendMessageEmail(MailTypeEnum.LMC_DELETE_LOG_FAIL_EMAIL.name(), data);
            logger.warn("\u53d1\u9001\u5220\u9664\u65e5\u5fd7\u5931\u8d25\u90ae\u4ef6\u7ed3\u679c {}", body);
        }
    }
}

