/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.lmc.support.upgrade;

import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.service.UpdateDatabaseService;
import com.digiwin.dap.middleware.support.upgrade.UpgradeHandler;
import com.digiwin.dap.middleware.support.upgrade.UpgradeVO;
import com.digiwin.dap.middleware.support.upgrade.Version;
import com.digiwin.dap.middleware.support.upgrade.VersionVO;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LmcUpgradeHandler
implements UpgradeHandler {
    private static final Logger logger = LoggerFactory.getLogger(LmcUpgradeHandler.class);
    private final List<UpdateDatabaseService> updateDatabaseServices;

    public LmcUpgradeHandler(List<UpdateDatabaseService> updateDatabaseServices) {
        this.updateDatabaseServices = updateDatabaseServices;
    }

    private void createTableVersion() {
    }

    public void check(VersionVO version) {
        version.checkValid();
        if (!version.isForce()) {
            this.checkFirstUpgrade(version.getEndVersion());
        }
    }

    private void checkFirstUpgrade(String endVersion) {
        int end;
        int current;
        Version version = this.findLatestVersion();
        if (version != null && (current = VersionVO.getVersion((String)version.getMiddlewareVersion())) >= (end = VersionVO.getVersion((String)endVersion))) {
            throw new BusinessException(String.format("\u6570\u636e\u5e93\u7248\u672c[%s]\u5927\u4e8e\u7b49\u4e8e\u5f53\u524d\u5347\u7ea7\u7248\u672c[%s]\uff0c\u8bf7\u52ff\u91cd\u590d\u5347\u7ea7", version.getMiddlewareVersion(), endVersion));
        }
    }

    public List<Object> upgrade(String startVersion, String endVersion) {
        ArrayList<Object> upgrades = new ArrayList<Object>();
        this.createTableVersion();
        for (UpdateDatabaseService currentService : this.updateDatabaseServices) {
            if (!currentService.support(startVersion, endVersion)) continue;
            long startTime = System.currentTimeMillis();
            currentService.before();
            currentService.update();
            currentService.after();
            long upgradeTime = System.currentTimeMillis() - startTime;
            upgrades.add(new UpgradeVO(Long.valueOf(upgradeTime), currentService.version(), currentService.getClass().getName()));
        }
        return upgrades;
    }

    public Version findLatestVersion() {
        return null;
    }

    private void save(int oldVersion, String middlewareVersion, long executionTime) {
    }
}

