/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.lmc.support.upgrade.impl;

import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.lmc.domain.CommonVO;
import com.digiwin.dap.middleware.lmc.domain.page.Page;
import com.digiwin.dap.middleware.lmc.domain.page.PageData;
import com.digiwin.dap.middleware.lmc.entity.oplog.OpLog;
import com.digiwin.dap.middleware.lmc.repository.OpLogRepository;
import com.digiwin.dap.middleware.lmc.support.remote.IamService;
import com.digiwin.dap.middleware.lmc.support.upgrade.AbstractLmcUpdateDatabaseService;
import com.digiwin.dap.middleware.lmc.util.StringUtil;
import com.mongodb.bulk.BulkWriteResult;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.util.Pair;
import org.springframework.stereotype.Service;

@Order(value=42200)
@Service
public class UpgradeDatabaseV421ToV422Service
extends AbstractLmcUpdateDatabaseService {
    private static final Logger logger = LoggerFactory.getLogger(UpgradeDatabaseV421ToV422Service.class);
    public static final String PCC = "PCC";
    private static final int PAGE_SIZE = 1000;
    @Autowired
    private OpLogRepository opLogRepository;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private IamService iamService;

    public String version() {
        return "4.22.0.0";
    }

    public void update() {
        long totalCount;
        logger.info("42200000\u6570\u636e\u5347\u7ea7\u5f00\u59cb--->>>");
        int updateCount = 0;
        long startTime = System.currentTimeMillis();
        HashMap tenantMap = new HashMap();
        try {
            ArrayList<Criteria> andCrtList = new ArrayList<Criteria>();
            andCrtList.add(new Criteria().andOperator(new Criteria[]{Criteria.where((String)"tenantId").ne((Object)""), Criteria.where((String)"tenantId").ne(null)}));
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"appId").is((Object)PCC)).addCriteria((CriteriaDefinition)new Criteria().andOperator(andCrtList.toArray(new Criteria[0])));
            Page page = new Page(query, 1, 1000, null);
            PageData pageData = this.opLogRepository.findByPageExcludeDataPolicy(page, "PCC_oplog");
            totalCount = pageData.getTotal();
            if (pageData.getTotal() > 0L) {
                int dataSize;
                do {
                    dataSize = pageData.getList().size();
                    int update = this.update(pageData.getList(), tenantMap);
                    updateCount += update;
                    if (dataSize < 1000) continue;
                    page.setPageNum(page.getPageNum() + 1);
                    pageData = this.opLogRepository.findByPageExcludeDataPolicy(page, "PCC_oplog");
                } while (dataSize >= 1000);
            }
        }
        catch (Exception e) {
            throw new BusinessException("42200000\u6570\u636e\u5347\u7ea7\u5931\u8d25", (Throwable)e);
        }
        logger.info("<<<---42200000\u6570\u636e\u5347\u7ea7\u5b8c\u6210\uff0ctotalCount={}, updateCount={}, \u8017\u65f6: {}ms", new Object[]{totalCount, updateCount, System.currentTimeMillis() - startTime});
    }

    private int update(List<OpLog> opLogList, Map<Long, CommonVO> tenantMap) throws InterruptedException {
        if ((opLogList = opLogList.stream().filter(x -> StringUtil.isInteger((String)x.getTenantId())).collect(Collectors.toList())).isEmpty()) {
            return 0;
        }
        Set sidSet = opLogList.stream().map(x -> Long.parseLong(x.getTenantId())).filter(x -> !tenantMap.containsKey(x)).collect(Collectors.toSet());
        if (!sidSet.isEmpty()) {
            List tenantList = this.iamService.getTenantIdsBySids(sidSet);
            Map<Long, CommonVO> tempMap = tenantList.stream().collect(Collectors.toMap(CommonVO::getSid, Function.identity(), BinaryOperator.maxBy(Comparator.comparing(CommonVO::getId))));
            tenantMap.putAll(tempMap);
        }
        ArrayList updateList = new ArrayList();
        BulkOperations operations = this.mongoTemplate.bulkOps(BulkOperations.BulkMode.UNORDERED, PCC.toLowerCase() + "_oplog");
        opLogList.forEach(data -> {
            Long sid = Long.parseLong(data.getTenantId());
            if (!tenantMap.containsKey(sid)) {
                return;
            }
            data.setTenantId(((CommonVO)tenantMap.get(sid)).getId());
            data.setTenantName(((CommonVO)tenantMap.get(sid)).getName());
            Query query = new Query((CriteriaDefinition)new Criteria("_id").is((Object)data.getId()));
            Document doc = new Document();
            this.mongoTemplate.getConverter().write(data, (Object)doc);
            Update update = Update.fromDocument((Document)new Document("$set", (Object)doc), (String[])new String[0]);
            Pair updatePair = Pair.of((Object)query, (Object)update);
            updateList.add(updatePair);
        });
        if (updateList.isEmpty()) {
            return 0;
        }
        operations.upsert(updateList);
        BulkWriteResult result = operations.execute();
        Thread.sleep(300L);
        return result.getModifiedCount();
    }
}

