/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.lmc.support.upgrade.impl;

import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.lmc.constant.enums.SaveDaysEnum;
import com.digiwin.dap.middleware.lmc.entity.BaseEntity;
import com.digiwin.dap.middleware.lmc.repository.AppSettingRepository;
import com.digiwin.dap.middleware.lmc.support.upgrade.AbstractLmcUpdateDatabaseService;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Order(value=42700)
@Service
public class UpgradeDatabaseV426ToV427Service
extends AbstractLmcUpdateDatabaseService {
    private static final Logger logger = LoggerFactory.getLogger(UpgradeDatabaseV426ToV427Service.class);
    @Autowired
    private AppSettingRepository appSettingRepository;

    public String version() {
        return "4.27.0.0";
    }

    public void update() {
        logger.info("42700000\u6570\u636e\u5347\u7ea7\u5f00\u59cb--->>>");
        List apps = this.appSettingRepository.findAll();
        ArrayList updateList = new ArrayList();
        try {
            apps.forEach(app -> {
                boolean update = false;
                if (app.getEsChangeLogSaveDays() == null) {
                    app.setEsChangeLogSaveDays(Integer.valueOf(SaveDaysEnum.ES_OPLOG_SAVE_DAYS.getDays()));
                    update = true;
                }
                if (app.getEsEventLogSaveDays() == null) {
                    app.setEsEventLogSaveDays(Integer.valueOf(SaveDaysEnum.ES_EVENTLOG_SAVE_DAYS.getDays()));
                    update = true;
                }
                if (app.getEsDevLogSaveDays() == null) {
                    app.setEsDevLogSaveDays(Integer.valueOf(SaveDaysEnum.ES_DEVLOG_SAVE_DAYS.getDays()));
                    update = true;
                }
                if (update) {
                    updateList.add(app);
                    this.appSettingRepository.update((BaseEntity)app);
                }
            });
        }
        catch (Exception e) {
            throw new BusinessException("42700000\u6570\u636e\u5347\u7ea7\u5931\u8d25", (Throwable)e);
        }
        logger.info("<<<---42700000\u6570\u636e\u5347\u7ea7\u5b8c\u6210\uff0cupdateList.size = {}", (Object)updateList.size());
    }
}

