/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.lmc.support.upgrade.impl;

import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.lmc.domain.EnvProperties;
import com.digiwin.dap.middleware.lmc.domain.page.Page;
import com.digiwin.dap.middleware.lmc.domain.page.PageData;
import com.digiwin.dap.middleware.lmc.entity.logsetting.AppSetting;
import com.digiwin.dap.middleware.lmc.repository.AppSettingRepository;
import com.digiwin.dap.middleware.lmc.repository.EventLogRepository;
import com.digiwin.dap.middleware.lmc.repository.OpLogRepository;
import com.digiwin.dap.middleware.lmc.support.elasticsearch.service.IElasticsearchService;
import com.digiwin.dap.middleware.lmc.support.upgrade.AbstractLmcUpdateDatabaseService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Order(value=43100)
@Service
public class UpgradeDatabaseV430ToV431Service
extends AbstractLmcUpdateDatabaseService {
    private static final Logger logger = LoggerFactory.getLogger(UpgradeDatabaseV430ToV431Service.class);
    @Autowired
    private AppSettingRepository appSettingRepository;
    @Autowired
    private OpLogRepository opLogRepository;
    @Autowired
    private EventLogRepository eventLogRepository;
    @Autowired
    private IElasticsearchService elasticsearchService;
    @Autowired
    private EnvProperties envProperties;
    private static final int SLEEP_MILLIS = 3000;
    private static final int PAGE_SIZE = 100;

    public String version() {
        return "4.31.0.0";
    }

    public void update() {
        logger.info("43100000\u6570\u636e\u5347\u7ea7\u5f00\u59cb--->>>");
        if (!Boolean.TRUE.equals(this.envProperties.getLogESEnabled())) {
            logger.warn("\u672a\u5f00\u542fES\u5b58\u50a8\u670d\u52a1\uff0c\u7ed3\u675f\u672c\u6b21\u5347\u7ea7");
            return;
        }
        List apps = this.appSettingRepository.findAll();
        int totalCount = 0;
        long startTime = System.currentTimeMillis();
        int total = 0;
        long time = System.currentTimeMillis();
        try {
            int dataSize;
            PageData pageData;
            Page page;
            Query query;
            int appUpdateSize;
            for (AppSetting app : apps) {
                appUpdateSize = 0;
                query = new Query((CriteriaDefinition)Criteria.where((String)"appId").is((Object)app.getAppId()));
                page = new Page(query, 1, 100, null);
                pageData = this.opLogRepository.findByPageExcludeDataPolicy(page, app.getAppId() + "_oplog");
                logger.info("\u5f00\u59cb \u5347\u7ea7{}, totalCount = {} -->>>", (Object)app.getAppId(), (Object)pageData.getTotal());
                if (pageData.getTotal() > 0L) {
                    do {
                        dataSize = pageData.getList().size();
                        this.elasticsearchService.bulkIndex(pageData.getList());
                        totalCount += dataSize;
                        logger.info("\u5347\u7ea7{}, updateSize = {}", (Object)app.getAppId(), (Object)(appUpdateSize += dataSize));
                        Thread.sleep(3000L);
                        if (dataSize < 100) continue;
                        page.setPageNum(page.getPageNum() + 1);
                        pageData = this.opLogRepository.findByPageExcludeDataPolicy(page, app.getAppId() + "_oplog");
                    } while (dataSize >= 100);
                }
                logger.info("Oplog\u5b8c\u6210 \u5347\u7ea7{}, totalCount = {} <<<--", (Object)app.getAppId(), (Object)pageData.getTotal());
            }
            logger.info("Oplog\u5347\u7ea7\u5b8c\u6210\uff0ctotalCount = {}, \u8017\u65f6: {}ms", (Object)totalCount, (Object)(System.currentTimeMillis() - startTime));
            total = totalCount;
            totalCount = 0;
            startTime = System.currentTimeMillis();
            for (AppSetting app : apps) {
                appUpdateSize = 0;
                if ("crstatscenter".equalsIgnoreCase(app.getAppId()) || "IAM".equalsIgnoreCase(app.getAppId())) continue;
                query = new Query((CriteriaDefinition)Criteria.where((String)"appId").is((Object)app.getAppId()));
                page = new Page(query, 1, 100, null);
                pageData = this.eventLogRepository.findByPageExcludeDataPolicy(page, app.getAppId() + "_eventlog");
                logger.info("\u5f00\u59cb \u5347\u7ea7{}, totalCount = {} -->>>", (Object)app.getAppId(), (Object)pageData.getTotal());
                if (pageData.getTotal() > 0L) {
                    do {
                        dataSize = pageData.getList().size();
                        this.elasticsearchService.bulkIndex(pageData.getList());
                        totalCount += dataSize;
                        logger.info("\u5347\u7ea7{}, updateSize = {}", (Object)app.getAppId(), (Object)(appUpdateSize += dataSize));
                        Thread.sleep(3000L);
                        if (dataSize < 100) continue;
                        page.setPageNum(page.getPageNum() + 1);
                        pageData = this.eventLogRepository.findByPageExcludeDataPolicy(page, app.getAppId() + "_eventlog");
                    } while (dataSize >= 100);
                }
                logger.info("Eventlog\u5b8c\u6210 \u5347\u7ea7{}, totalCount = {} <<<--", (Object)app.getAppId(), (Object)pageData.getTotal());
            }
            logger.info("Eventlog\u5347\u7ea7\u5b8c\u6210\uff0ctotalCount = {}, \u8017\u65f6: {}ms", (Object)totalCount, (Object)(System.currentTimeMillis() - startTime));
        }
        catch (Exception e) {
            throw new BusinessException("43100000\u6570\u636e\u5347\u7ea7\u5931\u8d25", (Throwable)e);
        }
        logger.info("<<<---43100000\u6570\u636e\u5347\u7ea7\u5b8c\u6210\uff0c\u603b\u6570total = {}, \u603b\u8017\u65f6: {}ms", (Object)(total += totalCount), (Object)(System.currentTimeMillis() - time));
    }
}

