/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.lmc.support.upgrade.impl;

import com.digiwin.dap.middleware.lmc.constant.LmcConstant;
import com.digiwin.dap.middleware.lmc.entity.logsetting.AppSetting;
import com.digiwin.dap.middleware.lmc.repository.AppSettingRepository;
import com.digiwin.dap.middleware.lmc.support.upgrade.AbstractLmcUpdateDatabaseService;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Order(value=40800)
@Service
public class UpgradeDatabaseV47ToV48Service
extends AbstractLmcUpdateDatabaseService {
    private static final Logger logger = LoggerFactory.getLogger(UpgradeDatabaseV47ToV48Service.class);
    @Autowired
    private AppSettingRepository appSettingRepository;
    @Autowired
    private MongoTemplate mongoTemplate;

    public String version() {
        return "4.8.0.0000";
    }

    public void update() {
        logger.info("4.8\u6570\u636e\u5347\u7ea7\u5e94\u7528ifLocal\u5f00\u59cb--->>>");
        List all = this.appSettingRepository.findAll();
        if (CollectionUtils.isEmpty((Collection)all)) {
            return;
        }
        for (AppSetting app : all) {
            if (app.getIfLocal() != null) continue;
            app.setIfLocal(Boolean.valueOf(LmcConstant.MIDDLEWARE_BACKEND.contains(app.getAppId())));
            this.mongoTemplate.findAndReplace(Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)app.getId())), (Object)app);
        }
        logger.info("<<<---4.8\u6570\u636e\u5347\u7ea7\u5e94\u7528ifLocal\u5b8c\u6210");
    }
}

