/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.lmc.support.upgrade.impl;

import com.digiwin.dap.middleware.domain.CommonCode;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.lmc.constant.enums.BusinessTypeEnum;
import com.digiwin.dap.middleware.lmc.domain.oplog.ChangeQuery;
import com.digiwin.dap.middleware.lmc.domain.page.PageData;
import com.digiwin.dap.middleware.lmc.domain.remote.LoginHistoryVO;
import com.digiwin.dap.middleware.lmc.entity.event.EventLog;
import com.digiwin.dap.middleware.lmc.repository.EventLogRepository;
import com.digiwin.dap.middleware.lmc.support.remote.IamService;
import com.digiwin.dap.middleware.lmc.support.upgrade.AbstractLmcUpdateDatabaseService;
import com.digiwin.dap.middleware.util.UserUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Order(value=40900)
@Service
public class UpgradeDatabaseV48ToV49Service
extends AbstractLmcUpdateDatabaseService {
    private static final Logger logger = LoggerFactory.getLogger(UpgradeDatabaseV48ToV49Service.class);
    @Autowired
    private EventLogRepository eventLogRepository;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private IamService iamService;
    private static final int PAGE_SIZE = 1000;
    private static final String IAM = CommonCode.IAM.name();

    public String version() {
        return "4.9.0.0000";
    }

    public void update() {
        logger.info("4900000\u6570\u636e\u5347\u7ea7\u5f00\u59cb--->>>");
        long totalCount = 0L;
        int saveCount = 0;
        long startTime = System.currentTimeMillis();
        String userToken = UserUtils.getToken();
        try {
            ChangeQuery query = new ChangeQuery();
            int dataSize = 0;
            query.setPageIndex(Integer.valueOf(1));
            query.setPageSize(Integer.valueOf(1000));
            PageData pageData = this.iamService.getLoginHistories(query, userToken);
            if (pageData.getTotal() > 0L) {
                totalCount = pageData.getTotal();
                do {
                    dataSize = pageData.getList().size();
                    int save = this.save(pageData.getList());
                    saveCount += save;
                    if (dataSize < 1000) continue;
                    query.setPageIndex(Integer.valueOf(query.getPageIndex() + 1));
                    pageData = this.iamService.getLoginHistories(query, userToken);
                } while (dataSize >= 1000);
            }
        }
        catch (Exception e) {
            throw new BusinessException("4900000\u6570\u636e\u5347\u7ea7\u5931\u8d25", (Throwable)e);
        }
        long endTime = System.currentTimeMillis();
        logger.info("<<<---4900000\u6570\u636e\u5347\u7ea7\u5b8c\u6210\uff0ctotalCount={}, \u672c\u6b21\u5347\u7ea7saveCount={}, \u8017\u65f6: {}ms", new Object[]{totalCount, saveCount, endTime - startTime});
    }

    private int save(List<LoginHistoryVO> historyVOList) throws InterruptedException {
        ArrayList<EventLog> eventLogList = new ArrayList<EventLog>();
        for (LoginHistoryVO loginHistory : historyVOList) {
            EventLog eventLog = new EventLog();
            UUID uuid = UUID.nameUUIDFromBytes(String.valueOf(loginHistory.getSid()).getBytes());
            boolean existsById = this.eventLogRepository.existsById(uuid, IAM.toLowerCase() + "_eventlog");
            if (existsById) continue;
            eventLog.setId(uuid);
            eventLog.setAppId(IAM);
            eventLog.setStatus(Integer.valueOf(0));
            if ("login".equals(loginHistory.getStatus())) {
                eventLog.setEventType(BusinessTypeEnum.LOGIN.getValue());
                if (ObjectUtils.isEmpty((Object)loginHistory.getAppId())) {
                    eventLog.setEventName(String.format("\u7528\u6237[%s(%s)]\uff0c\u767b\u5165\u6210\u529f\uff01", loginHistory.getUserName(), loginHistory.getUserId()));
                } else {
                    eventLog.setEventName(String.format("\u7528\u6237[%s(%s)]\uff0c\u767b\u5165\u5e94\u7528[%s]\u6210\u529f\uff01", loginHistory.getUserName(), loginHistory.getUserId(), loginHistory.getAppId()));
                }
                eventLog.setEventName(String.format("\u7528\u6237[%s(%s)]\uff0c\u767b\u5165\u6210\u529f\uff01", loginHistory.getUserName(), loginHistory.getUserId()));
            } else {
                eventLog.setEventType(BusinessTypeEnum.LOGOUT.getValue());
                if (ObjectUtils.isEmpty((Object)loginHistory.getAppId())) {
                    eventLog.setEventName(String.format("\u7528\u6237[%s(%s)]\uff0c\u767b\u51fa\u6210\u529f\uff01", loginHistory.getUserName(), loginHistory.getUserId()));
                } else {
                    eventLog.setEventName(String.format("\u7528\u6237[%s(%s)]\uff0c\u767b\u51fa\u5e94\u7528[%s]\u6210\u529f\uff01", loginHistory.getUserName(), loginHistory.getUserId(), loginHistory.getAppId()));
                }
            }
            eventLog.setTenantId(loginHistory.getTenantId());
            eventLog.setTenantName(loginHistory.getTenantName());
            eventLog.setSysId(loginHistory.getAppId());
            eventLog.setSysName(loginHistory.getAppName());
            eventLog.setUserId(loginHistory.getUserId());
            eventLog.setUserName(loginHistory.getUserName());
            eventLog.setCreateDate(loginHistory.getHistoryTime());
            eventLogList.add(eventLog);
        }
        Collection insert = this.mongoTemplate.insert(eventLogList, IAM.toLowerCase() + "_eventlog");
        Thread.sleep(300L);
        return insert.size();
    }
}

