/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.lmc.util;

import com.digiwin.dap.middleware.lmc.domain.page.Page;
import com.digiwin.dap.middleware.util.DateUtils;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.mongodb.BasicDBList;
import com.mongodb.client.model.Filters;
import java.io.IOException;
import java.time.DateTimeException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.bson.BsonDocument;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.json.JsonWriterSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.mapping.Field;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class ObjectUtil {
    private static final Logger logger = LoggerFactory.getLogger(ObjectUtil.class);

    public static Query query(Object object) {
        return ObjectUtil.query((Object)object, (Boolean)Boolean.FALSE);
    }

    public static Query query(Object object, String ... regexField) {
        return ObjectUtil.query((Object)object, Arrays.asList(regexField));
    }

    public static Query query(Object object, List<String> regexField) {
        return null;
    }

    public static Query query(Object object, Boolean regex) {
        return ObjectUtil.query((Object)object, null, (Boolean)regex);
    }

    public static Query query(Object object, List<String> regexField, Boolean regex) {
        if (null == regexField) {
            regexField = Collections.emptyList();
        }
        Query query = new Query();
        if (object == null) {
            return query;
        }
        for (java.lang.reflect.Field field : ObjectUtil.getFields((Object)object)) {
            Criteria criteria;
            field.setAccessible(true);
            Field annotation = field.getAnnotation(Field.class);
            if (annotation != null) {
                criteria = ObjectUtil.getCriteria((String)annotation.value(), (java.lang.reflect.Field)field, (Object)object, regexField, (boolean)Boolean.TRUE.equals(regex));
                if (criteria == null) continue;
                query.addCriteria((CriteriaDefinition)criteria);
                continue;
            }
            criteria = ObjectUtil.getCriteria((java.lang.reflect.Field)field, (Object)object, regexField, (boolean)Boolean.TRUE.equals(regex));
            if (criteria != null) {
                query.addCriteria((CriteriaDefinition)criteria);
            }
            field.setAccessible(false);
        }
        return query;
    }

    public static Bson filter(Object object) {
        ArrayList<Bson> filters = new ArrayList<Bson>();
        if (object != null) {
            for (java.lang.reflect.Field field : ObjectUtil.getFields((Object)object)) {
                field.setAccessible(true);
                Bson bson = ObjectUtil.getBson((java.lang.reflect.Field)field, (Object)object);
                if (bson != null) {
                    filters.add(bson);
                }
                field.setAccessible(false);
            }
        }
        if (filters.isEmpty()) {
            return new BsonDocument();
        }
        return Filters.and(filters);
    }

    public static Bson filter(Map<String, Object> filter) {
        ArrayList<Bson> filters = new ArrayList<Bson>();
        if (CollectionUtils.isEmpty(filter)) {
            return new BsonDocument();
        }
        for (Map.Entry<String, Object> entry : filter.entrySet()) {
            if ("id".equals(entry.getKey())) {
                filters.add(Filters.eq((String)"_id", (Object)UUID.fromString(entry.getValue().toString())));
                continue;
            }
            if (entry.getValue() instanceof String) {
                filters.add(Filters.regex((String)entry.getKey(), (String)Pattern.quote(entry.getValue().toString())));
                continue;
            }
            filters.add(Filters.eq((String)entry.getKey(), (Object)entry.getValue()));
        }
        return Filters.and(filters);
    }

    public static Query query(Page page) {
        if (page == null) {
            return new Query();
        }
        Query query = page.getQuery() != null ? page.getQuery() : ObjectUtil.query((Map)page.getRegexFilters(), (Map)page.getEqFilters(), (Map)page.getGteFilters(), (Map)page.getLteFilters(), (Map)page.getInFilters());
        query.with(ObjectUtil.sort((Map)page.getOrders()));
        return query.skip((long)page.skip()).limit(page.limit());
    }

    public static Query query(Map<String, Object> regexFilters, Map<String, Object> eqFilters, Map<String, Object> gteFilters, Map<String, Object> lteFilters) {
        return ObjectUtil.query(null, regexFilters, eqFilters, gteFilters, lteFilters, null);
    }

    public static Query query(Query query, Map<String, Object> regexFilters, Map<String, Object> eqFilters, Map<String, Object> gteFilters, Map<String, Object> lteFilters) {
        return ObjectUtil.query((Query)query, regexFilters, eqFilters, gteFilters, lteFilters, null);
    }

    public static Query query(Map<String, Object> regexFilters, Map<String, Object> eqFilters, Map<String, Object> gteFilters, Map<String, Object> lteFilters, Map<String, Object> inFilters) {
        return ObjectUtil.query(null, regexFilters, eqFilters, gteFilters, lteFilters, inFilters);
    }

    public static Query query(Query query, Map<String, Object> regexFilters, Map<String, Object> eqFilters, Map<String, Object> gteFilters, Map<String, Object> lteFilters, Map<String, Object> inFilters) {
        if (query == null) {
            query = new Query();
        }
        if (CollectionUtils.isEmpty(regexFilters) && CollectionUtils.isEmpty(eqFilters) && CollectionUtils.isEmpty(gteFilters) && CollectionUtils.isEmpty(lteFilters) && CollectionUtils.isEmpty(inFilters)) {
            return query;
        }
        if (!query.getQueryObject().containsKey((Object)"$and")) {
            query.addCriteria((CriteriaDefinition)new Criteria().andOperator(new Criteria[0]));
        }
        BasicDBList basicDBList = (BasicDBList)query.getQueryObject().get((Object)"$and", BasicDBList.class);
        if (!CollectionUtils.isEmpty(regexFilters)) {
            for (Map.Entry<String, Object> entry : regexFilters.entrySet()) {
                if ("id".equals(entry.getKey())) {
                    basicDBList.add((Object)Criteria.where((String)"_id").is((Object)UUID.fromString(entry.getValue().toString())).getCriteriaObject());
                    continue;
                }
                if (!(entry.getValue() instanceof String)) continue;
                basicDBList.add((Object)Criteria.where((String)entry.getKey()).regex(Pattern.quote(entry.getValue().toString())).getCriteriaObject());
            }
        }
        if (!CollectionUtils.isEmpty(eqFilters)) {
            for (Map.Entry<String, Object> entry : eqFilters.entrySet()) {
                if ("id".equals(entry.getKey())) {
                    basicDBList.add((Object)Criteria.where((String)"_id").is((Object)UUID.fromString(entry.getValue().toString())).getCriteriaObject());
                    continue;
                }
                basicDBList.add((Object)Criteria.where((String)entry.getKey()).is(entry.getValue()).getCriteriaObject());
            }
        }
        if (!CollectionUtils.isEmpty(gteFilters)) {
            for (Map.Entry<String, Object> entry : gteFilters.entrySet()) {
                if (entry.getValue() instanceof String && ObjectUtil.dateStrValid((String)entry.getValue().toString())) {
                    basicDBList.add((Object)Criteria.where((String)entry.getKey()).gte((Object)DateUtils.getDateByStr((String)entry.getValue().toString())).getCriteriaObject());
                    continue;
                }
                basicDBList.add((Object)Criteria.where((String)entry.getKey()).gte(entry.getValue()).getCriteriaObject());
            }
        }
        if (!CollectionUtils.isEmpty(lteFilters)) {
            for (Map.Entry<String, Object> entry : lteFilters.entrySet()) {
                if (entry.getValue() instanceof String && ObjectUtil.dateStrValid((String)entry.getValue().toString())) {
                    basicDBList.add((Object)Criteria.where((String)entry.getKey()).lte((Object)DateUtils.getDateByStr((String)entry.getValue().toString())).getCriteriaObject());
                    continue;
                }
                basicDBList.add((Object)Criteria.where((String)entry.getKey()).lte(entry.getValue()).getCriteriaObject());
            }
        }
        if (!CollectionUtils.isEmpty(inFilters)) {
            for (Map.Entry<String, Object> entry : inFilters.entrySet()) {
                if ("id".equals(entry.getKey())) {
                    if (entry.getValue() instanceof List) {
                        basicDBList.add((Object)Criteria.where((String)"_id").in((Collection)((List)entry.getValue()).stream().map(x -> UUID.fromString(x.toString())).collect(Collectors.toList())).getCriteriaObject());
                        continue;
                    }
                    basicDBList.add((Object)Criteria.where((String)"_id").in(new Object[]{entry.getValue()}).getCriteriaObject());
                    continue;
                }
                if (entry.getValue() instanceof List) {
                    basicDBList.add((Object)Criteria.where((String)entry.getKey()).in((Collection)((List)entry.getValue())).getCriteriaObject());
                    continue;
                }
                basicDBList.add((Object)Criteria.where((String)entry.getKey()).in(new Object[]{entry.getValue()}).getCriteriaObject());
            }
        }
        return query;
    }

    public static Sort sort(Map<String, Object> order) {
        ArrayList<Sort.Order> sort = new ArrayList<Sort.Order>();
        if (CollectionUtils.isEmpty(order)) {
            return Sort.unsorted();
        }
        for (Map.Entry<String, Object> entry : order.entrySet()) {
            if ("id".equals(entry.getKey())) {
                if (entry.getValue().equals(1)) {
                    sort.add(Sort.Order.asc((String)"_id"));
                    continue;
                }
                sort.add(Sort.Order.desc((String)"_id"));
                continue;
            }
            if (entry.getValue().equals(1)) {
                sort.add(Sort.Order.asc((String)entry.getKey()));
                continue;
            }
            sort.add(Sort.Order.desc((String)entry.getKey()));
        }
        return Sort.by(sort);
    }

    private static List<java.lang.reflect.Field> getFields(Object object) {
        ArrayList<java.lang.reflect.Field> fields = new ArrayList<java.lang.reflect.Field>();
        for (Class<?> aClass = object.getClass(); aClass != null; aClass = aClass.getSuperclass()) {
            java.lang.reflect.Field[] declaredFields = aClass.getDeclaredFields();
            fields.addAll(Arrays.stream(declaredFields).filter(o -> !o.isSynthetic()).collect(Collectors.toList()));
        }
        return fields;
    }

    private static Criteria getCriteria(java.lang.reflect.Field field, Object object, List<String> regexField, boolean regex) {
        return ObjectUtil.getCriteria((String)field.getName(), (java.lang.reflect.Field)field, (Object)object, regexField, (boolean)regex);
    }

    private static Criteria getCriteria(String fieldName, java.lang.reflect.Field field, Object object, List<String> regexField, boolean regex) {
        try {
            Object fieldValue = field.get(object);
            if (!ObjectUtils.isEmpty((Object)fieldValue)) {
                if (String.class.getName().equals(field.getGenericType().getTypeName()) && (regex || regexField.contains(fieldName))) {
                    return Criteria.where((String)fieldName).regex(Pattern.quote(fieldValue.toString()));
                }
                return Criteria.where((String)fieldName).is(fieldValue);
            }
        }
        catch (IllegalAccessException e) {
            logger.error("\u83b7\u53d6\u5bf9\u8c61\u5b57\u6bb5\u503c\u9519\u8bef\uff1a{}", (Object)e.getMessage());
        }
        return null;
    }

    private static Bson getBson(java.lang.reflect.Field field, Object object) {
        try {
            Object fieldValue = field.get(object);
            if (!ObjectUtils.isEmpty((Object)fieldValue)) {
                if ("id".equals(field.getName())) {
                    return Filters.eq((String)"_id", (Object)fieldValue);
                }
                if (String.class.getName().equals(field.getGenericType().getTypeName())) {
                    return Filters.regex((String)field.getName(), (String)Pattern.quote(fieldValue.toString()));
                }
                return Filters.eq((String)field.getName(), (Object)fieldValue);
            }
        }
        catch (IllegalAccessException e) {
            logger.error("\u83b7\u53d6\u5bf9\u8c61\u5b57\u6bb5\u503c\u9519\u8bef\uff1a{}", (Object)e.getMessage());
        }
        return null;
    }

    public static <T> T toBean(Document document, Class<T> clzss) {
        String realJson = document.toJson(JsonWriterSettings.builder().build());
        Object obj = null;
        try {
            obj = JsonUtils.createObjectMapper().readValue(realJson, clzss);
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.error("Document To Bean\u8f6c\u5316\u5931\u8d25");
        }
        return (T)obj;
    }

    public static boolean dateStrValid(String dateStr) {
        try {
            DateUtils.getDateByStr((String)dateStr);
            return true;
        }
        catch (DateTimeException e) {
            return false;
        }
    }
}

