/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.lmc.util.compression.algorithm;

import com.digiwin.dap.middleware.lmc.util.compression.algorithm.ICompressionAlgorithm;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="gzipCompressionAlgorithm")
public class GZIPCompressionAlgorithm
implements ICompressionAlgorithm {
    private static final Logger LOGGER = LoggerFactory.getLogger(GZIPCompressionAlgorithm.class);
    public static final String GZIP_ENCODE_UTF_8 = "UTF-8";
    public static final String GZIP_ENCODE_ISO_8859_1 = "ISO-8859-1";

    public byte[] compress(String str) {
        if (str == null || str.length() == 0) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            GZIPOutputStream gzip = new GZIPOutputStream(out);
            gzip.write(str.getBytes(GZIP_ENCODE_UTF_8));
            gzip.close();
        }
        catch (Exception e) {
            LOGGER.error("gzip compress exception:{}", (Throwable)e);
        }
        return out.toByteArray();
    }

    public byte[] unCompress(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        try {
            int n;
            GZIPInputStream unGzip = new GZIPInputStream(in);
            byte[] buffer = new byte[256];
            while ((n = unGzip.read(buffer)) >= 0) {
                out.write(buffer, 0, n);
            }
        }
        catch (Exception e) {
            LOGGER.error("gzip unCompress exception:{}", (Throwable)e);
        }
        return out.toByteArray();
    }

    public static void main(String[] args) {
        GZIPCompressionAlgorithm compressionAlgorithm = new GZIPCompressionAlgorithm();
        String str = "POST http://esp.apps.digiwincloudlocal.com/CROSS/RESTful\n\ncontent-length: 135\nx-forwarded-port: 80\nlocale: zh_TW\nx-forwarded-host: esp.apps.digiwincloudlocal.com\nhost: esp.apps.digiwincloudlocal.com\ncontent-type: application/json; charset=UTF-8\ndigi-host: {\"prod\":\"BM-SOSC\",\"ver\":\"1.0\",\"ip\":\"\",\"timestamp\":\"20231009131959773\",\"lang\":\"zh_TW\",\"eoc_acct\":\"athena\",\"acct\":\"DS\"}\ninnertoken: eyJ0eXAiOiJKV1QiLCJhbGciOiJub25lIn0.eyJwcm9maWxlIjoie1wiY3J1c2FnZS1yZWNvcmRlclwiOlwiNmMzMDE0MDgtZTUzNC00YmFiLTljMmYtNjEyMjc1MTkyZGMwXCIsXCJAQGxvbmdWYWx1ZUtleUxpc3RcIjpbXCJ0ZW5hbnRTaWRcIixcInVzZXJTaWRcIl0sXCJ0ZW5hbnROYW1lXCI6XCLpgoHpkavmqZ_morDlt6Xmpa3ogqHku73mnInpmZDlhazlj7hcIixcInRlbmFudFNpZFwiOlwiNDMwOTA0NDg2MDE2NjRcIixcInRlbmFudElkXCI6XCI0MzEwMjU4N1wiLFwidXNlclNpZFwiOlwiMTk4NDYxMDQ5OVwiLFwidXNlck5hbWVcIjpcIumbhuaIkOi0puWPt1wiLFwidXNlcklkXCI6XCJpbnRlZ3JhdGlvblwifSJ9.\ndigi-eocmap: {\"eoc_company_id\":\"Manford\"}\nx-request-id: 5a9e6b600d8be3bb775e2ed8c8c04bf8\nsecurity-token: rLtwhzqJT+mzInsnyfefmsvaD5GX8ukSEluPFILf4OIDAqidgCS6cGgqzQEYBzQhgdUpvPw4MvhZILjapO7OWOk1JjY4/WCBRMfVBP+qDcxALtUL535ntI8dYJi6C2GCJatrCtcYzznQv+G55B3lIdCnhQiWiMvIZgriQDwSEmh1DdSFcir/xWojfRF3nO5pp8NjVyHOs6jSYbfSgbeLE+2UilWxPWRbH1FZJp1UiGlbWW61Ul6YPeO0Nva61VGEOuTfMdkUa3lBINmzjcHuhYvE8DphPuh3An7C5dBXfZXHUpwweSRM3lphWibeMKW4SqmgjZLsBlqGZLBoNw7/WSrRu/5tTJ2O/CnIpMZIA3jd4FUMXQYC2UnFS2/tuUQFvDuVczSbre7RmBFWGl1fL9VDSsPx34L6kq7q/TUfuVTTTWg2u6eKTQHvQTpoD0Ly\nx-forwarded-proto: http\ndigi-datakey: {\"CompanyId\":\"Manford\"}\ndigi-service: {\"prod\":\"WFGP\",\"tenant_id\":\"43102587\",\"name\":\"project.budget.contract.data.get\",\"uid\":\"WFGP_859\"}\ndigi-middleware-auth-app: eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6IkJNLVNPU0MiLCJzaWQiOjM2NTQ1ODAyMTkxMzE1Mn0.7isJHwkPARIn0tWWuTOYCbHJEzw1Hwo8_9ec4iuXW70\nx-forwarded-for: 172.16.4.26\ntoken: fb097281-ad4b-498d-b602-4af5c5fedf57\nx-real-ip: 172.16.4.26\nx-forwarded-scheme: http\ndigi-type: async\ndigi-ommap: {\"om_company_id\":\"Manford\"}\nx-scheme: http\ndigi-key: 2dd3be3191155cf7c6c81c2bc9f703fa\nrouterkey: 43102587\naccept-encoding: gzip,deflate\nuser-agent: Apache-HttpClient/4.5.5 (Java/1.8.0_212)\n\n{\"std_data\":{\"parameter\":{\"enterprise_no\":\"\",\"site_no\":\"\",\"project_info\":[{\"project_no\":\"SA-23022101\"},{\"project_no\":\"SA-23011201\"}]}}}\n";
        System.out.println(Arrays.toString(compressionAlgorithm.compress(str)));
    }
}

