<#assign mustClauses = [] />

<#if aggregationCondition?exists>

<#if aggregationCondition.startTime?has_content && aggregationCondition.startTime?trim != "" && aggregationCondition.endTime?has_content && aggregationCondition.endTime?trim != "">
  <#assign mustClauses += ['{ "range": { "platformTime": { "from": "' + aggregationCondition.startTime + '", "to": "' + aggregationCondition.endTime + '" } } }']>
</#if>

<#if aggregationCondition.tenantId?has_content && aggregationCondition.tenantId?trim != "">
  <#assign mustClauses += ['{ "term": { "tenantId": { "value": "' + aggregationCondition.tenantId + '" } } }']>
</#if>

<#if aggregationCondition.requestAp?has_content && aggregationCondition.requestAp?trim != "">
  <#assign mustClauses += ['{ "term": { "request": { "value": "' + aggregationCondition.requestAp + '" } } }']>
</#if>

<#if aggregationCondition.serviceAp?has_content && aggregationCondition.serviceAp?trim != "">
  <#assign mustClauses += ['{ "term": { "service": { "value": "' + aggregationCondition.serviceAp + '" } } }']>
</#if>

<#if aggregationCondition.serviceName?has_content && aggregationCondition.serviceName?trim != "">
  <#assign mustClauses += ['{ "term": { "serviceName": { "value": "' + aggregationCondition.serviceName + '" } } }']>
</#if>

<#if aggregationCondition.serviceDescription?has_content && aggregationCondition.serviceDescription?trim != "">
  <#assign mustClauses += ['{ "wildcard": { "serviceDescription": { "wildcard": "*' + aggregationCondition.serviceDescription + '*" } } }']>
</#if>

<#if aggregationCondition.stateCode?has_content && aggregationCondition.stateCode?trim != "">
  <#assign mustClauses += ['{ "term": { "stateCode": { "value": "' + aggregationCondition.stateCode + '" } } }']>
</#if>

<#if aggregationCondition.dataKey?has_content && aggregationCondition.dataKey?trim != "">
  <#assign mustClauses += ['{ "wildcard": { "dataKey": { "wildcard": "*' + aggregationCondition.dataKey + '*" } } }']>
</#if>

<#if aggregationCondition.state?has_content && aggregationCondition.state?trim != "">
  <#assign mustClauses += ['{ "term": { "state": { "value": "' + aggregationCondition.state + '" } } }']>
</#if>

</#if>

{
  "size": 0,
  "query": {
    "bool": {
      "must": [
      <#list mustClauses as clause>
        ${clause}<#if clause_has_next>,</#if>
      </#list>
      ]
    }
  },
  "aggs": {
    <#list aggregationDimensionsList as aggregationDimensions>
      "${aggregationDimensions.dimensions}Grouping":{
         <#if aggregationDimensions.aggregationType?has_content && aggregationCondition.aggregationType?trim != "">
         <#else>
           "terms":{
             "field": "${aggregationDimensions.dimensions}",
             "size": 1000
             }
           <#if aggregationDimensions.subDimensionsList?has_content>
             <#list aggregationDimensionsList.subDimensionsList as subDimensions>
               ,"aggs": {
               <#if subDimensions.aggregationType?has_content  && subDimensions.aggregationType?trim != "">
               <#else>
                 "terms":{
                    "field": "${subDimensions.dimensions}"
                 }
               </#if>
               }
             </#list>
           </#if>
         </#if>
      }<#if aggregationDimensions_has_next>,</#if>
    </#list>
  }
}


