/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.api;

import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.omc.constant.enums.BnplOrderStatusEnum;
import com.digiwin.dap.middleware.omc.domain.bnpl.BnplOrderConditionVO;
import com.digiwin.dap.middleware.omc.domain.bnpl.BnplOrderTerminateVO;
import com.digiwin.dap.middleware.omc.domain.bnpl.BnplOrderVO;
import com.digiwin.dap.middleware.omc.domain.bnpl.dto.DeleteBnplOrderDTO;
import com.digiwin.dap.middleware.omc.domain.bnpl.request.DeleteBnplOrderRequest;
import com.digiwin.dap.middleware.omc.entity.BnplOrder;
import com.digiwin.dap.middleware.omc.repository.OrderRepository;
import com.digiwin.dap.middleware.omc.service.bnpl.BnplOrderQueryService;
import com.digiwin.dap.middleware.omc.service.bnpl.BnplOrderService;
import com.digiwin.dap.middleware.omc.support.remote.CacService;
import com.digiwin.dap.middleware.omc.support.remote.MailService;
import com.digiwin.dap.middleware.util.AssertUtils;
import com.github.pagehelper.PageSerializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/omc/v2/bnpl"})
public class BnplOrderController {
    @Autowired
    private CacService cacService;
    @Autowired
    private MailService mailService;
    @Autowired
    private BnplOrderService bnplOrderService;
    @Autowired
    private BnplOrderQueryService bnplOrderQueryService;
    @Autowired
    private OrderRepository orderRepository;

    @GetMapping(value={"/find"})
    public StdData<?> find(Long sid) {
        BnplOrderVO bnplOrderVO = this.bnplOrderQueryService.findBySid(sid);
        return StdData.ok((Object)bnplOrderVO);
    }

    @GetMapping(value={"/search"})
    public StdData<?> search(BnplOrderConditionVO body) {
        List orders = this.bnplOrderQueryService.findByPage(body);
        return StdData.ok((Object)PageSerializable.of((List)orders));
    }

    @GetMapping(value={"/console/search"})
    public StdData<?> consoleSearch(BnplOrderConditionVO body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        body.setTenantId(authoredUser.getTenantId());
        List orders = this.bnplOrderQueryService.findByPage(body);
        return StdData.ok((Object)PageSerializable.of((List)orders));
    }

    @PostMapping(value={"/terminate"})
    public StdData<?> terminate(@RequestBody BnplOrderTerminateVO body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        BnplOrder bnplOrder = this.bnplOrderService.terminate(body);
        if (bnplOrder != null && bnplOrder.getStatus().intValue() == BnplOrderStatusEnum.TERMINATED.getCode()) {
            this.bnplOrderService.terminationAuthorization(bnplOrder, Boolean.valueOf(false));
            this.mailService.sendTerminateBnplOrder(bnplOrder);
        }
        return StdData.ok((Object)bnplOrder);
    }

    @PostMapping(value={"/terminate/apply"})
    public StdData<?> terminateApply(@RequestBody BnplOrderTerminateVO body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        AssertUtils.paramNotNull((Object)body.getSid(), (String)"sid");
        BnplOrder bnplOrder = this.bnplOrderService.terminateApply(body);
        if (bnplOrder != null && bnplOrder.getStatus().intValue() == BnplOrderStatusEnum.APPLY_TERMINATION.getCode()) {
            bnplOrder.setTerminateReason(body.getTerminateReason());
            this.mailService.sendTerminateBnplOrderPM(bnplOrder);
        }
        return StdData.ok().build();
    }

    @PostMapping(value={"/cancel/terminate/apply"})
    public StdData<?> cancelTerminateApply(@RequestBody BnplOrderTerminateVO body) {
        AssertUtils.paramNotNull((Object)body.getSid(), (String)"sid");
        this.bnplOrderService.cancelTerminateApply(body);
        return StdData.ok().build();
    }

    @PostMapping(value={"/del"})
    public StdData<?> del(@RequestBody DeleteBnplOrderRequest request, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        this.bnplOrderService.deleteBillOrder(new DeleteBnplOrderDTO(request.getBnplCode(), authoredUser.getUserId(), authoredUser.getUserName(), Long.valueOf(authoredUser.getSid())));
        return StdData.ok().build();
    }
}

