/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.api;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.omc.constant.I18nError;
import com.digiwin.dap.middleware.omc.dao.ContractCrudService;
import com.digiwin.dap.middleware.omc.domain.request.ContractVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderVO;
import com.digiwin.dap.middleware.omc.entity.Contract;
import com.digiwin.dap.middleware.omc.service.order.ContractService;
import com.digiwin.dap.middleware.omc.service.order.OrderQueryService;
import com.digiwin.dap.middleware.omc.support.remote.IamService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ContractController {
    @Autowired
    private IamService iamService;
    @Autowired
    private ContractService contractService;
    @Autowired
    private OrderQueryService orderQueryService;
    @Autowired
    private ContractCrudService contractCrudService;

    @PostMapping(value={"/api/omc/v2/contract/{sid}"})
    public StdData<?> createContract(@PathVariable(name="sid") Long sid) {
        OrderVO orderVO = this.orderQueryService.getOrderBySid(sid.longValue());
        long contractSid = this.contractService.createContract(orderVO, this.iamService.getUserToken(orderVO.getTenantId()));
        if (contractSid == 0L) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_20008, new Object[]{orderVO.getOrderCode()});
        }
        Contract contract = (Contract)this.contractCrudService.findBySid(contractSid);
        return StdData.ok((Object)new ContractVO(contract));
    }
}

