/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.api;

import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.omc.domain.request.CustomFormCartVO;
import com.digiwin.dap.middleware.omc.domain.request.CustomFormContentVO;
import com.digiwin.dap.middleware.omc.domain.request.CustomFormOrderVO;
import com.digiwin.dap.middleware.omc.mapper.CustomFormCartMapper;
import com.digiwin.dap.middleware.omc.repository.CustomFormCartRepository;
import com.digiwin.dap.middleware.omc.service.business.CustomFormCartService;
import com.github.pagehelper.PageSerializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/omc/v2/custom/form"})
public class CustomFormController {
    @Autowired
    private CustomFormCartService customFormCartService;
    @Autowired
    private CustomFormCartRepository customFormCartRepository;
    @Autowired
    private CustomFormCartMapper customFormCartMapper;

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/cart"})
    public StdData save(@RequestBody CustomFormCartVO customFormCartVO) {
        this.customFormCartService.save(customFormCartVO);
        return StdData.ok().build();
    }

    @GetMapping(value={"/exists"})
    public StdData existsCustomForm(@RequestParam String name) {
        if (this.customFormCartRepository.existsByCustomFormName(name)) {
            return StdData.ok((Object)true);
        }
        return StdData.ok((Object)false);
    }

    @GetMapping(value={"/cart/{sid}"})
    public StdData getCustomFormByCartSid(@PathVariable Long sid) {
        return StdData.ok((Object)this.customFormCartService.getCustomFromByCartSid(sid.longValue()));
    }

    @GetMapping(value={"/order/{sid}"})
    public StdData getCustomFormByOrderSid(@PathVariable Long sid) {
        return StdData.ok((Object)this.customFormCartService.getCustomFromByOrderSid(sid.longValue()));
    }

    @GetMapping(value={"/name"})
    public StdData getCustomForm() {
        return StdData.ok((Object)this.customFormCartMapper.getCustomFrom());
    }

    @GetMapping(value={"/{id}/order"})
    public StdData getPackList(@PathVariable String id, @RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="orderBy", defaultValue="o.create_date desc") String orderBy, @RequestParam(name="params", required=false) String params) {
        CustomFormOrderVO condition = CustomFormOrderVO.getSelf((String)params);
        condition.setCustomFormId(id);
        List customFormOrderList = this.customFormCartService.getCustomFormOrderList(condition, pageNum.intValue(), pageSize.intValue(), orderBy);
        return StdData.ok((Object)new PageSerializable(customFormOrderList));
    }

    @Transactional(rollbackFor={Exception.class})
    @PutMapping(value={"/cart"})
    public StdData update(@RequestBody List<CustomFormContentVO> customFormContentVOs) {
        this.customFormCartService.update(customFormContentVOs);
        return StdData.ok().build();
    }

    @GetMapping(value={"/{id}/goods"})
    public StdData getAllGoods(@PathVariable String id) {
        List goods = this.customFormCartService.getAllGoods(id);
        return StdData.ok((Object)goods);
    }
}

