/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.api;

import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.omc.constant.enums.DevSysAuthorizationStatusEnum;
import com.digiwin.dap.middleware.omc.domain.request.DevSysAuthorizationDTO;
import com.digiwin.dap.middleware.omc.entity.DevSysAuthorization;
import com.digiwin.dap.middleware.omc.repository.DevSysAuthorizationRepository;
import com.digiwin.dap.middleware.omc.service.business.DevSysAuthorizationService;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/omc/v2/dev/sys"})
public class DevSysAuthorizationController {
    @Autowired
    private DevSysAuthorizationService devSysAuthorizationService;
    @Autowired
    private DevSysAuthorizationRepository devSysAuthorizationRepository;

    @PostMapping(value={"/authorization"})
    public StdData saveAuthorization(@RequestBody DevSysAuthorizationDTO dto, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        Assert.notNull((Object)dto.getDevSysSid(), (String)"\u5e94\u7528sid\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)dto.getDevSysId(), (String)"\u5e94\u7528id\u4e0d\u80fd\u4e3a\u7a7a");
        if (null == dto.getDevTenantSid() || 0L == dto.getDevTenantSid()) {
            Assert.isTrue((authoredUser.getTenantSid() != 0L ? 1 : 0) != 0, (String)String.format("\u7528\u6237[%s]\u7684\u79df\u6237sid\u4e0d\u80fd\u4e3a\u7a7a", authoredUser.getUserId()));
            dto.setDevTenantSid(Long.valueOf(authoredUser.getTenantSid()));
        }
        return StdData.ok((Object)this.devSysAuthorizationService.save(dto).getCode());
    }

    @GetMapping(value={"/authorizations"})
    public StdData getAuthorizations(@RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="orderBy", defaultValue="d.create_date desc") String orderBy, @RequestParam(name="params", required=false) String params) {
        return StdData.ok((Object)this.devSysAuthorizationService.getDevSysAuthorizations(pageNum, pageSize, orderBy, DevSysAuthorizationDTO.getSelf((String)params)));
    }

    @PutMapping(value={"/authorization/code/{code}"})
    public StdData updateAuthorization(@PathVariable String code) {
        DevSysAuthorization authorization = Optional.ofNullable(this.devSysAuthorizationRepository.findByCode(code)).orElseThrow(() -> new BusinessException(String.format("\u4f01\u4e1a\u6388\u6743\u7801[%s]\u4e0d\u5b58\u5728", code)));
        Assert.isTrue((boolean)DevSysAuthorizationStatusEnum.CODE_USED.getValue().equals(authorization.getStatus()), (String)String.format("\u5df2\u5f00\u901a\u7684\u4f01\u4e1a\u6388\u6743\u7801[%s]\u624d\u53ef\u4ee5\u505c\u7528", code));
        return StdData.ok((Object)this.devSysAuthorizationService.stopAuthorization(authorization));
    }

    @Transactional
    @DeleteMapping(value={"/authorization/code/{code}"})
    public StdData deleteAuthorization(@PathVariable String code) {
        DevSysAuthorization authorization = Optional.ofNullable(this.devSysAuthorizationRepository.findByCode(code)).orElseThrow(() -> new BusinessException(String.format("\u4f01\u4e1a\u6388\u6743\u7801[%s]\u4e0d\u5b58\u5728", code)));
        Assert.isTrue((boolean)DevSysAuthorizationStatusEnum.CODE_NOT_USED.getValue().equals(authorization.getStatus()), (String)String.format("\u672a\u5f00\u901a\u7684\u4f01\u4e1a\u6388\u6743\u7801[%s]\u624d\u53ef\u4ee5\u5220\u9664", code));
        this.devSysAuthorizationRepository.deleteById((Object)authorization.getSid());
        return StdData.ok().build();
    }
}

