/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.api;

import com.digiwin.dap.middle.kms.constants.KeyConstant;
import com.digiwin.dap.middleware.commons.crypto.AES;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.omc.api.EnvController;
import com.digiwin.dap.middleware.omc.domain.EnvProperties;
import com.digiwin.dap.middleware.omc.mapper.CodeMapper;
import com.digiwin.dap.middleware.omc.support.schedule.ScheduleTaskService;
import com.digiwin.dap.middleware.omc.util.CodeUtil;
import com.digiwin.dap.middleware.omc.util.DateUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class EnvController {
    @Autowired
    private CodeMapper codeMapper;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private RedisTemplate<Object, Object> redisTemplate;
    @Autowired
    private ScheduleTaskService scheduleTaskService;

    @GetMapping(value={"/api/omc/v2/env"})
    public ResponseEntity<?> getRuntimeEnv() {
        this.envProperties.refresh();
        return ResponseEntity.ok((Object)this.envProperties);
    }

    @GetMapping(value={"/api/omc/v2/env/code"})
    public ResponseEntity<?> getCode() {
        LinkedHashMap<String, Cloneable> body = new LinkedHashMap<String, Cloneable>();
        LinkedHashMap<String, Long> time = new LinkedHashMap<String, Long>();
        time.put("now-to-end-day", DateUtil.toEndDay().getSeconds());
        time.put("now-to-end-month", DateUtil.toEndMonth().getSeconds());
        body.put("code-ttl-second", time);
        ArrayList<OeCode> oeCodesCn = new ArrayList<OeCode>();
        oeCodesCn.add(this.getOeCode(0, "\u8ba2\u5355\u53f7-\u5927\u9646", CodeUtil.orderCodePrefix((String)"C")));
        oeCodesCn.add(this.getOeCode(0, "\u7ecf\u9500\u5546\u8ba2\u5355\u53f7-\u5927\u9646", CodeUtil.cartCodePrefix((String)"DEALC")));
        oeCodesCn.add(this.getOeCode(1, "\u8d2d\u7269\u5355\u53f7-\u5927\u9646", CodeUtil.cartCodePrefix((String)"CARTC")));
        oeCodesCn.add(this.getOeCode(2, "\u7ec4\u5408\u5546\u54c1\u8ba2\u5355\u53f7-\u5927\u9646", CodeUtil.cartCodePrefix((String)"MIXC")));
        body.put("code-zh-CN", oeCodesCn);
        ArrayList<OeCode> oeCodesTw = new ArrayList<OeCode>();
        oeCodesTw.add(this.getOeCode(0, "\u8ba2\u5355\u53f7-\u53f0\u6e7e", CodeUtil.orderCodePrefix((String)"T")));
        oeCodesTw.add(this.getOeCode(0, "\u7ecf\u9500\u5546\u8ba2\u5355\u53f7-\u53f0\u6e7e", CodeUtil.cartCodePrefix((String)"DEALT")));
        oeCodesTw.add(this.getOeCode(1, "\u8d2d\u7269\u5355\u53f7-\u53f0\u6e7e", CodeUtil.cartCodePrefix((String)"CARTT")));
        oeCodesTw.add(this.getOeCode(2, "\u7ec4\u5408\u5546\u54c1\u8ba2\u5355\u53f7-\u53f0\u6e7e", CodeUtil.cartCodePrefix((String)"MIXT")));
        body.put("code-zh-TW", oeCodesTw);
        return ResponseEntity.ok(body);
    }

    @GetMapping(value={"/api/omc/v2/env/schedule"})
    public StdData synchronousPurchaseDate() {
        this.scheduleTaskService.manualAuthorization();
        return StdData.ok().build();
    }

    @GetMapping(value={"/api/omc/v2/env/schedule/any"})
    public ResponseEntity<?> startScheduleTask(@RequestParam String methodName) throws InvocationTargetException, IllegalAccessException {
        Method[] methods;
        for (Method method : methods = this.scheduleTaskService.getClass().getMethods()) {
            if (!methodName.endsWith(method.getName())) continue;
            method.invoke((Object)this.scheduleTaskService, new Object[0]);
        }
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    private OeCode getOeCode(int sign, String name, String key) {
        Object value = this.redisTemplate.opsForValue().get((Object)key);
        Long ttl = this.redisTemplate.getExpire((Object)key);
        long maxValue = 0L;
        if (sign == 0) {
            maxValue = this.codeMapper.findMaxOrderCode(key);
        } else if (sign == 1) {
            maxValue = this.codeMapper.findMaxCartCode(key);
        } else if (sign == 2) {
            maxValue = this.codeMapper.findMaxPackCode(key);
        }
        OeCode oeCode = new OeCode(null);
        oeCode.setName(name);
        oeCode.setKey(key);
        oeCode.setTtl(ttl);
        oeCode.setValue(value);
        oeCode.setMaxDbValue(Long.valueOf(maxValue));
        return oeCode;
    }

    @GetMapping(value={"/api/omc/v2/env/password"})
    public StdData synchronousPurchaseDate(@RequestParam String dbPassword) {
        return StdData.ok((Object)AES.encrypt((String)dbPassword, (String)KeyConstant.WECHAT_UNION_ID));
    }
}

