/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.api;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.omc.domain.EnvProperties;
import com.digiwin.dap.middleware.omc.domain.excel.HeadCellStyleStrategy;
import com.digiwin.dap.middleware.omc.domain.excel.OrderAccountExcel;
import com.digiwin.dap.middleware.omc.domain.excel.OrderDeviceExcel;
import com.digiwin.dap.middleware.omc.domain.request.CloudDeviceConditionVO;
import com.digiwin.dap.middleware.omc.domain.request.CustomFormOrderVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderConditionVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderDeviceVO;
import com.digiwin.dap.middleware.omc.domain.request.PreOrderDTO;
import com.digiwin.dap.middleware.omc.mapper.DeviceMapper;
import com.digiwin.dap.middleware.omc.service.business.CustomFormCartService;
import com.digiwin.dap.middleware.omc.service.order.OrderQueryService;
import com.digiwin.dap.middleware.omc.support.excel.ExcelService;
import com.digiwin.dap.middleware.omc.util.CustomCellWriteHandler;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/omc/v2/excel"})
public class ExcelController {
    @Autowired
    private DeviceMapper deviceMapper;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private CustomFormCartService customFormCartService;
    @Autowired
    private ExcelService excelService;
    @Autowired
    private OrderQueryService orderQueryService;

    @GetMapping(value={"/device/export"})
    public void deviceExport(@RequestParam(name="orderBy", defaultValue="d.sid desc") String orderBy, @RequestParam(name="params", required=false) String params, HttpServletResponse response) throws Exception {
        OrderDeviceVO orderDeviceVO = OrderDeviceVO.getSelf((String)params);
        List devices = this.deviceMapper.findDevicesExport(orderDeviceVO, orderBy);
        ArrayList deviceExcels = new ArrayList();
        devices.forEach(o -> deviceExcels.add(new OrderDeviceExcel(o)));
        InputStream inputStream = Locale.TRADITIONAL_CHINESE.getCountry().equalsIgnoreCase(this.envProperties.getCountry()) ? this.getClass().getResourceAsStream("/static/templates/device_export_template_TW.xlsx") : this.getClass().getResourceAsStream("/static/templates/device_export_template_CN.xlsx");
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding("UTF-8");
        String fileName = URLEncoder.encode("\u8bbe\u5907\u6388\u6743\u5546\u54c1\u5217\u8868", "UTF-8");
        response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".xlsx");
        ((ExcelWriterSheetBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), OrderDeviceExcel.class).withTemplate(inputStream).sheet(Integer.valueOf(0)).needHead(Boolean.valueOf(false))).doWrite(deviceExcels);
    }

    @GetMapping(value={"/custom/form/{id}/export"})
    public void customFormExport(@PathVariable String id, @RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="orderBy", defaultValue="o.create_date desc") String orderBy, @RequestParam(name="params", required=false) String params, HttpServletResponse response) throws Exception {
        CustomFormOrderVO condition = CustomFormOrderVO.getSelf((String)params);
        condition.setCustomFormId(id);
        List customFormOrderList = this.customFormCartService.getCustomFormOrderList(condition, pageNum.intValue(), pageSize.intValue(), orderBy);
        List headList = this.excelService.getHeadList(((CustomFormOrderVO)customFormOrderList.get(0)).getCustomFormContentVO());
        List lists = this.excelService.getWeekList(customFormOrderList);
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding("utf-8");
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
        String localTime = df.format(LocalDateTime.now());
        String fileName = URLEncoder.encode("extra_" + localTime + ".xlsx", "UTF-8");
        response.setHeader("Content-disposition", "attachment;filename=" + fileName);
        ((ExcelWriterBuilder)((ExcelWriterBuilder)((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream()).head(headList)).registerWriteHandler((WriteHandler)new CustomCellWriteHandler())).registerWriteHandler((WriteHandler)new HeadCellStyleStrategy())).sheet("Sheet1").doWrite(lists);
    }

    @GetMapping(value={"/pre/orders/export"})
    public void exportPreOrders(@RequestParam(name="orderBy", defaultValue="po.order_type, po.sid desc") String orderBy, @RequestParam(value="params", required=false) String params, HttpServletResponse response) throws Exception {
        this.excelService.exportPreOrders(orderBy, PreOrderDTO.getSelf((String)params), response);
    }

    @PostMapping(value={"/account/orders/export"})
    public void exportAccountOrders(@RequestBody(required=false) OrderConditionVO body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser, HttpServletResponse response) throws Exception {
        if (body == null) {
            body = new OrderConditionVO();
        }
        body.setAccountFields();
        body.setPageSize(Integer.valueOf(Integer.MAX_VALUE));
        List orders = this.orderQueryService.getTenantOrders(body, body.getPageNum().intValue(), body.getPageSize().intValue(), body.getOrderBy());
        ArrayList accountOrders = new ArrayList();
        orders.forEach(o -> accountOrders.add(new OrderAccountExcel(o)));
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding("UTF-8");
        String fileName = URLEncoder.encode("\u8d26\u52a1\u7ba1\u7406\u8ba2\u5355", "UTF-8");
        response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".xlsx");
        EasyExcel.write((OutputStream)response.getOutputStream(), OrderAccountExcel.class).sheet("Sheet1").doWrite(accountOrders);
    }

    @PostMapping(value={"/cloud/device/export"})
    public StdData exportCloudDevice(@RequestBody CloudDeviceConditionVO deviceCondition) throws Exception {
        deviceCondition.setOrderBy(Optional.ofNullable(deviceCondition.getOrderBy()).orElse("createDate desc"));
        return StdData.ok((Object)this.excelService.exportCloudDevice(deviceCondition));
    }

    @PostMapping(value={"/cloud/device/import/{fileId}"})
    public StdData importCloudDevice(@PathVariable String fileId) {
        return StdData.ok((Object)this.excelService.importCloudDevice(fileId));
    }
}

