/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.api;

import cn.hutool.core.util.IdUtil;
import com.digiwin.dap.middleware.auth.AppAuthContextHolder;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.cache.RedisUtils;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.omc.dao.InstallmentOrderCrudService;
import com.digiwin.dap.middleware.omc.domain.request.ApplyStopInstallmentOrderVO;
import com.digiwin.dap.middleware.omc.domain.request.InstallmentOrderAuthVO;
import com.digiwin.dap.middleware.omc.domain.request.InstallmentOrderCallbackVO;
import com.digiwin.dap.middleware.omc.domain.request.InstallmentOrderConditionVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderConditionVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderVO;
import com.digiwin.dap.middleware.omc.entity.InstallmentOrder;
import com.digiwin.dap.middleware.omc.service.installment.InstallmentOrderAuthQueryService;
import com.digiwin.dap.middleware.omc.service.installment.InstallmentOrderQueryService;
import com.digiwin.dap.middleware.omc.service.installment.InstallmentOrderService;
import com.digiwin.dap.middleware.omc.service.order.OrderQueryService;
import com.digiwin.dap.middleware.omc.support.remote.IamService;
import com.digiwin.dap.middleware.omc.support.remote.MailService;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.github.pagehelper.PageSerializable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/omc/v2/installment"})
public class InstallmentOrderController {
    @Autowired
    private InstallmentOrderQueryService installmentOrderQueryService;
    @Autowired
    private InstallmentOrderCrudService installmentOrderCrudService;
    @Autowired
    private InstallmentOrderService installmentOrderService;
    @Autowired
    private OrderQueryService orderQueryService;
    @Autowired
    private InstallmentOrderAuthQueryService installmentOrderAuthQueryService;
    @Autowired
    private MailService mailService;
    @Autowired
    private IamService iamService;
    private static final Logger logger = LoggerFactory.getLogger(InstallmentOrderController.class);

    @GetMapping(value={"/search"})
    public StdData<?> getOrdersByCondition(@RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="orderBy", defaultValue="create_date desc") String orderBy, @RequestParam(name="params", required=false) String params) {
        InstallmentOrderConditionVO condition = InstallmentOrderConditionVO.getSelf((String)params);
        List orders = this.installmentOrderQueryService.getOrdersByCondition(condition, pageNum.intValue(), pageSize.intValue(), orderBy);
        return StdData.ok((Object)new PageSerializable(orders));
    }

    @GetMapping(value={"/tenant"})
    public StdData<?> getOrdersByTenantId(@RequestParam(name="params", required=false) String params, @NotNull @RequestParam(value="pageIndex") Integer pageNum, @NotNull @RequestParam(value="size") Integer pageSize, @RequestParam(name="orderBy", defaultValue="create_date desc") String orderBy, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        InstallmentOrderConditionVO orderCondition = InstallmentOrderConditionVO.getSelf((String)params);
        orderCondition.setTenantIdEq(authoredUser.getTenantId());
        orderCondition.setHasPeriodNo(Boolean.valueOf(true));
        List installmentOrders = this.installmentOrderQueryService.getOrdersByCondition(orderCondition, pageNum.intValue(), pageSize.intValue(), orderBy);
        return StdData.ok((Object)PageSerializable.of((List)installmentOrders));
    }

    @GetMapping(value={"/tenant/user"})
    public StdData<?> getOrdersByUserId(@RequestParam(name="params", required=false) String params, @NotNull @RequestParam(value="pageIndex") Integer pageNum, @NotNull @RequestParam(value="size") Integer pageSize, @RequestParam(name="orderBy", defaultValue="create_date desc") String orderBy, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        InstallmentOrderConditionVO orderCondition = InstallmentOrderConditionVO.getSelf((String)params);
        orderCondition.setTenantIdEq(authoredUser.getTenantId());
        orderCondition.setUserId(authoredUser.getUserId());
        orderCondition.setHasPeriodNo(Boolean.valueOf(true));
        List installmentOrders = this.installmentOrderQueryService.getOrdersByCondition(orderCondition, pageNum.intValue(), pageSize.intValue(), orderBy);
        return StdData.ok((Object)PageSerializable.of((List)installmentOrders));
    }

    @GetMapping(value={"/detail"})
    public StdData<?> getDetailsByPeriodNo(@RequestParam(name="params") String params) {
        OrderConditionVO orderCondition = OrderConditionVO.getSelf((String)params);
        InstallmentOrder installmentOrder = this.installmentOrderCrudService.findByPeriodNo(orderCondition.getPeriodNo());
        if (Objects.isNull(installmentOrder)) {
            return StdData.ok().build();
        }
        List authList = this.installmentOrderAuthQueryService.getOrderAuthsByPeriodNo(orderCondition.getPeriodNo());
        List authVOS = Optional.ofNullable(authList).orElse(Collections.emptyList()).stream().map(e -> {
            InstallmentOrderAuthVO authVO = new InstallmentOrderAuthVO();
            authVO.doBackward(e);
            authVO.setPeriodAmt(installmentOrder.getPeriodAmt());
            authVO.setPayPrice(installmentOrder.getPeriodAmt());
            return authVO;
        }).collect(Collectors.toList());
        return StdData.ok(authVOS);
    }

    @PostMapping(value={"/stop"})
    public StdData<?> applyStopOrder(@RequestBody @Valid ApplyStopInstallmentOrderVO stopInstallmentOrderVO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        InstallmentOrder installmentOrder = this.installmentOrderCrudService.findByOrderCode(stopInstallmentOrderVO.getOrderCode());
        if (Objects.isNull(installmentOrder)) {
            throw new BusinessException("\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        if (!Objects.equals(authoredUser.getTenantId(), installmentOrder.getTenantId())) {
            throw new BusinessException("\u6ca1\u6709\u64cd\u4f5c\u6743\u9650");
        }
        installmentOrder.setApplyStopReason(stopInstallmentOrderVO.getStopReason());
        installmentOrder.setApplyStopUserId(authoredUser.getUserId());
        installmentOrder.setApplyStopUserName(authoredUser.getUserName());
        this.installmentOrderService.applyStopOrder(installmentOrder);
        return StdData.ok().build();
    }

    @PostMapping(value={"/callback"})
    public StdData<?> authCallback(@RequestBody InstallmentOrderCallbackVO callbackVO) {
        String key = callbackVO.getOrderNo() + callbackVO.getAlreadyTimes() + callbackVO.getAuthStatus();
        if (!RedisUtils.lock((String)key, (String)IdUtil.simpleUUID())) {
            return StdData.of((int)500, (String)"\u91cd\u590d\u6267\u884c");
        }
        logger.info("\u89e6\u53d1\u56de\u8c03\u63a5\u53e3,\u5165\u53c2\uff1a{}", (Object)JsonUtils.objToJson((Object)callbackVO));
        OrderVO baseOrder = this.orderQueryService.findOrderByOrderCode(callbackVO.getOutTradeNo());
        if (Objects.isNull(baseOrder)) {
            logger.error("\u59d4\u6258\u5355\u56de\u8c03\u8ba2\u5355\u4e0d\u5b58\u5728,\u8ba2\u5355\u7f16\u53f7:{}", (Object)callbackVO.getOutTradeNo());
            throw new BusinessException("\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        String currentOrderCode = Objects.equals(callbackVO.getAlreadyTimes(), 1) ? callbackVO.getOutTradeNo() : callbackVO.getOrderNo();
        OrderVO currentOrder = this.orderQueryService.findOrderByOrderCode(currentOrderCode);
        String userToken = this.iamService.getUserToken(baseOrder.getTenantId());
        AuthoredUser userInfo = this.iamService.getUserInfo(userToken);
        AppAuthContextHolder.getContext().setAuthoredUser(userInfo);
        if (!callbackVO.getAuthStatus().booleanValue() && !Objects.equals(callbackVO.getAlreadyTimes(), 1)) {
            this.mailService.sendEmailPeriodAuthFailed(baseOrder, callbackVO);
        }
        this.installmentOrderService.callback(callbackVO, baseOrder, currentOrder);
        return StdData.ok().build();
    }
}

