/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.api;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.omc.constant.I18nError;
import com.digiwin.dap.middleware.omc.dao.InvoiceCrudService;
import com.digiwin.dap.middleware.omc.dao.OrderCrudService;
import com.digiwin.dap.middleware.omc.domain.request.OrderInvoiceVO;
import com.digiwin.dap.middleware.omc.entity.Invoice;
import com.digiwin.dap.middleware.omc.entity.Order;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class InvoiceController {
    @Autowired
    private OrderCrudService orderCrudService;
    @Autowired
    private InvoiceCrudService invoiceCrudService;

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/api/omc/v2/invoice"})
    public ResponseEntity<?> createInvoice(@RequestBody OrderInvoiceVO body) {
        Order order = (Order)this.orderCrudService.findBySid(body.getOrderSid().longValue());
        if (null == order) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_10001, new Object[]{body.getOrderSid()});
        }
        if (order.getShopping() == 0) {
            this.invoiceCrudService.saveOrderInvoice(body.getInvoice(), order);
        } else if (order.getShopping() == 1) {
            this.invoiceCrudService.saveShoppingInvoice(order.getCartCode(), body.getInvoice());
        }
        return ResponseEntity.ok((Object)StdData.ok().build());
    }

    @GetMapping(value={"/api/omc/v2/invoice/{invoiceSid}"})
    public ResponseEntity<?> getInvoiceBySid(@PathVariable(value="invoiceSid") long invoiceSid) {
        Invoice invoice = (Invoice)this.invoiceCrudService.findBySid(invoiceSid);
        if (invoice == null) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_30001, new Object[]{invoiceSid});
        }
        return ResponseEntity.ok((Object)invoice);
    }

    @GetMapping(value={"/api/omc/v2/invoice/order/{orderSid}"})
    public ResponseEntity<?> getInvoiceByOrderSid(@PathVariable(value="orderSid") long orderSid) {
        Invoice invoice = this.invoiceCrudService.findByOrderSid(orderSid);
        return ResponseEntity.ok((Object)invoice);
    }
}

