/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.api;

import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.omc.domain.request.OrderVO;
import com.digiwin.dap.middleware.omc.domain.request.ResendMailVO;
import com.digiwin.dap.middleware.omc.service.order.OrderQueryService;
import com.digiwin.dap.middleware.omc.support.remote.AuthService;
import com.digiwin.dap.middleware.omc.support.remote.MailService;
import com.digiwin.dap.middleware.omc.support.schedule.ScheduleTaskService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class MailController {
    @Autowired
    private MailService mailService;
    @Autowired
    private OrderQueryService orderQueryService;
    @Autowired
    private AuthService authService;
    @Autowired
    private ScheduleTaskService scheduleTaskService;

    @PostMapping(value={"/api/omc/v2/mail/resend"})
    public ResponseEntity<?> mailResend(@RequestBody ResendMailVO body) {
        this.mailService.mailResend(body);
        return ResponseEntity.ok((Object)StdData.ok().build());
    }

    @PostMapping(value={"/api/omc/v2/renew/notice/{orderCode}"})
    public ResponseEntity<?> renewNotice(@PathVariable(name="orderCode") String orderCode) {
        OrderVO order = this.orderQueryService.findOrderByOrderCode(orderCode);
        this.authService.renewNotice(order);
        return ResponseEntity.ok((Object)StdData.ok().build());
    }

    @PostMapping(value={"/api/omc/v2/device/cloud/expired"})
    public StdData checkExpiredDevice() {
        this.scheduleTaskService.sendCloudDeviceExpireEmail();
        return StdData.ok().build();
    }

    @PostMapping(value={"/api/omc/v2/device/cloud/StopSyncImage"})
    public StdData stopSyncImage() {
        this.scheduleTaskService.sendStopSyncImageEmail();
        return StdData.ok().build();
    }
}

