/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.api;

import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.commons.util.StrUtils;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.omc.constant.enums.CloudDeviceStateEnum;
import com.digiwin.dap.middleware.omc.dao.OrderCloudDeviceCrudService;
import com.digiwin.dap.middleware.omc.domain.CustomAttributeVO;
import com.digiwin.dap.middleware.omc.domain.request.CloudDeviceConditionVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderCloudDeviceAutoVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderCloudDeviceDbVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderCloudDeviceVO;
import com.digiwin.dap.middleware.omc.entity.OrderCloudDevice;
import com.digiwin.dap.middleware.omc.mapper.OrderCloudDeviceMapper;
import com.digiwin.dap.middleware.omc.repository.OrderCloudDeviceRepository;
import com.digiwin.dap.middleware.omc.service.business.OrderCloudDeviceService;
import com.digiwin.dap.middleware.omc.support.remote.MailService;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import com.github.pagehelper.PageSerializable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/omc/v2/device/cloud"})
public class OrderCloudDeviceController {
    public static final Logger LOGGER = LoggerFactory.getLogger(OrderCloudDeviceController.class);
    @Autowired
    private OrderCloudDeviceService orderCloudDeviceService;
    @Autowired
    private OrderCloudDeviceMapper orderCloudDeviceMapper;
    @Autowired
    private OrderCloudDeviceCrudService orderCloudDeviceCrudService;
    @Autowired
    private MailService mailService;
    @Autowired
    private OrderCloudDeviceRepository orderCloudDeviceRepository;

    @GetMapping(value={""})
    public ResponseEntity<?> getCloudDevices(@RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="orderBy", defaultValue="createDate desc") String orderBy, @RequestParam(name="params", required=false) String params, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        PageSerializable pageSerializable;
        CloudDeviceConditionVO deviceCondition = CloudDeviceConditionVO.getSelf((String)params);
        if (ObjectUtils.isEmpty((Object)authoredUser.getTenantId())) {
            PageSerializable pageSerializable2 = new PageSerializable(new ArrayList());
            return ResponseEntity.ok((Object)pageSerializable2);
        }
        if (!"99990000".equalsIgnoreCase(authoredUser.getTenantId())) {
            pageSerializable = new PageSerializable(new ArrayList());
            if (StrUtils.isNotEmpty((String)deviceCondition.getTenantId()) ? !authoredUser.getTenantId().equalsIgnoreCase(deviceCondition.getTenantId()) : StrUtils.isNotEmpty((String)deviceCondition.getTenantContent())) {
                return ResponseEntity.ok((Object)pageSerializable);
            }
        }
        pageSerializable = this.orderCloudDeviceService.getCloudDevices(pageNum, pageSize, orderBy, deviceCondition);
        for (Object o : pageSerializable.getList()) {
            OrderCloudDeviceVO o1 = (OrderCloudDeviceVO)o;
            o1.setDbAdminPwd(null);
            o1.setArcheryPwd(null);
            o1.setDbPassword(null);
        }
        return ResponseEntity.ok((Object)pageSerializable);
    }

    @GetMapping(value={"/current/tenant"})
    public StdData<?> getCloudDevicesCurrent(@RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="orderBy", defaultValue="createDate desc") String orderBy, @RequestParam(name="params", required=false) String params, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        CloudDeviceConditionVO deviceCondition = CloudDeviceConditionVO.getSelf((String)params);
        deviceCondition.setTenantId(authoredUser.getTenantId());
        deviceCondition.setDisabled(Boolean.valueOf(false));
        PageSerializable pageSerializable = this.orderCloudDeviceService.getCloudDevices(pageNum, pageSize, orderBy, deviceCondition);
        for (Object o : pageSerializable.getList()) {
            OrderCloudDeviceVO o1 = (OrderCloudDeviceVO)o;
            o1.setDbAdminPwd(null);
            o1.setArcheryPwd(null);
            o1.setDbPassword(null);
        }
        return StdData.ok((Object)pageSerializable);
    }

    @PostMapping(value={"/backend/search"})
    public StdData<?> getCloudDevicesBackend(@RequestBody CloudDeviceConditionVO params) {
        params.boxConditions();
        return StdData.ok((Object)this.orderCloudDeviceService.getCloudDevices(params.getPageNum(), params.getPageSize(), params.getOrderBy(), params));
    }

    @GetMapping(value={"/{sid}"})
    public StdData getCloudDeviceDetail(@PathVariable(value="sid") Long sid) {
        return StdData.ok((Object)this.orderCloudDeviceService.getCloudDevice(sid));
    }

    @PostMapping(value={"/apply"})
    public StdData applyCloudDevice(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser, @RequestBody OrderCloudDeviceVO orderCloudDeviceVO) {
        if (orderCloudDeviceVO == null || 0L == orderCloudDeviceVO.getSid()) {
            throw new BusinessException("\u8bbe\u5907\u4e91\u8d44\u6e90sid\u4e3a\u7a7a");
        }
        if (!StringUtils.hasLength((String)orderCloudDeviceVO.getUserId())) {
            orderCloudDeviceVO.setUserId(authoredUser.getUserId());
            orderCloudDeviceVO.setUserName(authoredUser.getUserName());
        }
        this.orderCloudDeviceService.applyCloudDevice(orderCloudDeviceVO);
        return StdData.ok().build();
    }

    @PostMapping(value={"/apply/batch"})
    public StdData batchApplyCloudDevice(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser, @RequestBody List<OrderCloudDeviceVO> orderCloudDeviceVOs) {
        for (OrderCloudDeviceVO orderCloudDeviceVO : orderCloudDeviceVOs) {
            if (orderCloudDeviceVO == null || 0L == orderCloudDeviceVO.getSid()) {
                throw new BusinessException("\u8bbe\u5907\u4e91\u8d44\u6e90sid\u4e3a\u7a7a");
            }
            if (StringUtils.hasLength((String)orderCloudDeviceVO.getUserId())) continue;
            orderCloudDeviceVO.setUserId(authoredUser.getUserId());
            orderCloudDeviceVO.setUserName(authoredUser.getUserName());
        }
        this.orderCloudDeviceService.batchApplyCloudDevice(orderCloudDeviceVOs);
        return StdData.ok().build();
    }

    @PostMapping(value={"/complete"})
    public StdData completeCloudDeviceApplication(@RequestBody @Valid OrderCloudDeviceVO orderCloudDeviceVO) {
        if (orderCloudDeviceVO == null || 0L == orderCloudDeviceVO.getSid()) {
            throw new BusinessException("\u8bbe\u5907\u4e91\u8d44\u6e90sid\u4e3a\u7a7a");
        }
        LOGGER.info("\u5b8c\u6210\u8d44\u6e90\u5f00\u7acb\u7533\u8bf7 sid={}, sendNotice={}, expireDate={}", new Object[]{orderCloudDeviceVO.getSid(), orderCloudDeviceVO.getSendNotice(), orderCloudDeviceVO.getExpireDate()});
        this.orderCloudDeviceService.completeApplication(orderCloudDeviceVO);
        return StdData.ok().build();
    }

    @PostMapping(value={"/mod"})
    public StdData modCloudDeviceApplication(@RequestBody OrderCloudDeviceVO orderCloudDeviceVO) {
        if (orderCloudDeviceVO == null || 0L == orderCloudDeviceVO.getSid()) {
            throw new BusinessException("\u8bbe\u5907\u4e91\u8d44\u6e90sid\u4e3a\u7a7a");
        }
        this.orderCloudDeviceService.modApplication(orderCloudDeviceVO);
        return StdData.ok().build();
    }

    @PostMapping(value={"/auto"})
    public StdData autoCloudDeviceApplication(@RequestBody @Valid OrderCloudDeviceAutoVO vo) {
        this.orderCloudDeviceService.autoApplication(vo);
        return StdData.ok().build();
    }

    @PostMapping(value={"/auto/batch"})
    public StdData<?> autoCloudDeviceApplication(@RequestBody @Valid List<OrderCloudDeviceAutoVO> vos) {
        for (OrderCloudDeviceAutoVO vo : vos) {
            this.orderCloudDeviceService.autoApplication(vo);
        }
        return StdData.ok().build();
    }

    @PostMapping(value={"/db/password"})
    public StdData changeDbPassword(@RequestBody @Valid OrderCloudDeviceDbVO vo) {
        this.orderCloudDeviceService.changeDbPassword(vo);
        return StdData.ok().build();
    }

    @GetMapping(value={"/tenant/cloudtype"})
    public StdData getCloudType(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        List clouds = this.orderCloudDeviceMapper.getCloudsByTenantSid(authoredUser.getTenantSid());
        return StdData.ok((Object)clouds);
    }

    @PostMapping(value={"/del"})
    public StdData delete(@RequestBody OrderCloudDeviceVO orderCloudDeviceVO) {
        Assert.notNull((Object)orderCloudDeviceVO.getSid(), (String)"sid \u4e0d\u80fd\u4e3a\u7a7a!");
        OrderCloudDevice orderCloudDevice = (OrderCloudDevice)this.orderCloudDeviceCrudService.findBySid(orderCloudDeviceVO.getSid().longValue());
        if (null == orderCloudDevice) {
            throw new BusinessException("\u627e\u4e0d\u5230\u8be5\u8d44\u6e90");
        }
        if (!CloudDeviceStateEnum.supportDelete((int)orderCloudDevice.getState())) {
            throw new BusinessException("\u4e91\u8d44\u6e90\u72b6\u6001\u4e0d\u652f\u6301\u5220\u9664");
        }
        this.orderCloudDeviceCrudService.deleteById(orderCloudDeviceVO.getSid().longValue());
        return StdData.ok().build();
    }

    @PostMapping(value={"/release"})
    public StdData release(@RequestBody OrderCloudDeviceVO orderCloudDeviceVO) {
        Assert.notNull((Object)orderCloudDeviceVO.getSid(), (String)"sid \u4e0d\u80fd\u4e3a\u7a7a!");
        OrderCloudDevice orderCloudDevice = (OrderCloudDevice)this.orderCloudDeviceCrudService.findBySid(orderCloudDeviceVO.getSid().longValue());
        if (null == orderCloudDevice) {
            throw new BusinessException("\u627e\u4e0d\u5230\u8be5\u8d44\u6e90");
        }
        orderCloudDevice.setState(CloudDeviceStateEnum.RELEASED.getValue());
        orderCloudDevice.setReleaseBy(orderCloudDeviceVO.getReleaseBy());
        orderCloudDevice.setReleaseJustification(orderCloudDeviceVO.getReleaseJustification());
        orderCloudDevice.setReleaseReason(orderCloudDeviceVO.getReleaseReason());
        this.orderCloudDeviceCrudService.update((BaseEntity)orderCloudDevice);
        return StdData.ok().build();
    }

    @PostMapping(value={"/release/mail"})
    public StdData release(@RequestBody List<Long> deviceSids) {
        if (CollectionUtils.isEmpty(deviceSids)) {
            return StdData.ok().build();
        }
        CloudDeviceConditionVO condition = new CloudDeviceConditionVO();
        condition.setDeviceSids(deviceSids);
        List deviceClouds = this.orderCloudDeviceMapper.getDeviceClouds(condition, 1, 999, null);
        this.mailService.sendReleaseDeviceEmails(deviceClouds);
        return StdData.ok().build();
    }

    @PostMapping(value={"/tenant/area"})
    public StdData getArea(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser, @RequestBody Map<String, String> body) {
        String cloud = body.getOrDefault("cloud", "");
        ArrayList areas = new ArrayList();
        List orderCustomAttributeVOs = this.orderCloudDeviceMapper.getAreasByTenantSidAndCloud(authoredUser.getTenantSid(), cloud);
        orderCustomAttributeVOs.stream().forEach(o -> {
            List customAttributeVOS = new ArrayList();
            try {
                customAttributeVOS = (List)JsonUtils.createObjectMapper().readValue(o.getCustomAttributes(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            }
            catch (IOException e) {
                throw new BusinessException(String.format("%s\u9500\u552e\u65b9\u6848\u81ea\u5b9a\u4e49\u5c5e\u6027\u89e3\u6790\u5f02\u5e38", o.getSid()), (Throwable)e);
            }
            for (CustomAttributeVO attribute : customAttributeVOS) {
                if (!"area".equalsIgnoreCase(attribute.getId()) || areas.contains(attribute.getValue())) continue;
                areas.add(attribute.getValue());
            }
        });
        return StdData.ok(areas);
    }

    @PostMapping(value={"/remove/dev"})
    public StdData<?> removeDevCloudDevice(@RequestBody OrderCloudDeviceVO body) {
        Assert.hasText((String)body.getTenantId(), (String)"\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        CloudDeviceConditionVO condition = new CloudDeviceConditionVO();
        condition.setTenantId(body.getTenantId());
        List deviceClouds = this.orderCloudDeviceMapper.getDeviceClouds(condition, 1, 999, null);
        if (!deviceClouds.isEmpty()) {
            this.orderCloudDeviceCrudService.deleteByIdIn(deviceClouds.stream().map(OrderCloudDeviceVO::getSid).collect(Collectors.toList()));
        }
        return StdData.ok().build();
    }

    @GetMapping(value={"/complete/mail"})
    public StdData release(@RequestParam String deviceCode) {
        OrderCloudDevice byCode = this.orderCloudDeviceRepository.findByCode(deviceCode);
        if (byCode != null) {
            this.orderCloudDeviceService.sendCompleteNotification(byCode, UserUtils.getUserId());
        }
        return StdData.ok().build();
    }
}

