/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.api;

import com.alibaba.excel.EasyExcel;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.dict.domain.DictDataDTO;
import com.digiwin.dap.middleware.dict.entity.Dict;
import com.digiwin.dap.middleware.dict.entity.DictData;
import com.digiwin.dap.middleware.dict.service.DictDataService;
import com.digiwin.dap.middleware.dict.service.DictService;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.omc.constant.I18nError;
import com.digiwin.dap.middleware.omc.constant.enums.GoodsCategoryEnum;
import com.digiwin.dap.middleware.omc.constant.enums.MailTypeEnum;
import com.digiwin.dap.middleware.omc.constant.enums.ServiceStatusEnum;
import com.digiwin.dap.middleware.omc.constant.enums.order.OrderShoppingEnum;
import com.digiwin.dap.middleware.omc.constant.enums.order.OrderTypeEnum;
import com.digiwin.dap.middleware.omc.dao.OrderCrudService;
import com.digiwin.dap.middleware.omc.domain.excel.OMBillDetailExcelVO;
import com.digiwin.dap.middleware.omc.domain.excel.OMBillSummaryExcelVO;
import com.digiwin.dap.middleware.omc.domain.order.request.UpdateOrderRequest;
import com.digiwin.dap.middleware.omc.domain.remote.GoodsStrategy;
import com.digiwin.dap.middleware.omc.domain.remote.ProductTypeVO;
import com.digiwin.dap.middleware.omc.domain.request.OMBillSearchConditionVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderConditionVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderDetailVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderPriceVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderVO;
import com.digiwin.dap.middleware.omc.domain.request.ServicerOrderDetailDTO;
import com.digiwin.dap.middleware.omc.domain.request.TossstatusVO;
import com.digiwin.dap.middleware.omc.domain.response.ResponseResult;
import com.digiwin.dap.middleware.omc.entity.Order;
import com.digiwin.dap.middleware.omc.entity.ServicerOrderDetail;
import com.digiwin.dap.middleware.omc.mapper.GoodsMapper;
import com.digiwin.dap.middleware.omc.mapper.OrderDetailMapper;
import com.digiwin.dap.middleware.omc.mapper.OrderMapper;
import com.digiwin.dap.middleware.omc.repository.ServicerOrderDetailRepository;
import com.digiwin.dap.middleware.omc.service.flow.OrderFlowService;
import com.digiwin.dap.middleware.omc.service.order.ContractService;
import com.digiwin.dap.middleware.omc.service.order.OrderOtherService;
import com.digiwin.dap.middleware.omc.service.order.OrderQueryService;
import com.digiwin.dap.middleware.omc.service.order.OrderService;
import com.digiwin.dap.middleware.omc.support.remote.CacService;
import com.digiwin.dap.middleware.omc.support.remote.IamService;
import com.digiwin.dap.middleware.omc.support.remote.MailService;
import com.digiwin.dap.middleware.util.EntityUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import com.github.pagehelper.PageSerializable;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class OrderController {
    private static final Logger logger = LoggerFactory.getLogger(OrderController.class);
    @Autowired
    private IamService iamService;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private OrderService orderService;
    @Autowired
    private ContractService contractService;
    @Autowired
    private OrderOtherService orderOtherService;
    @Autowired
    private OrderDetailMapper orderDetailMapper;
    @Autowired
    private OrderQueryService orderQueryService;
    @Autowired
    private OrderFlowService orderFlowService;
    @Autowired
    private ServicerOrderDetailRepository servicerOrderDetailRepository;
    @Autowired
    private MailService mailService;
    @Autowired
    private CacService cacService;
    @Autowired
    private OrderCrudService orderCrudService;
    @Autowired
    private GoodsMapper goodsMapper;
    @Autowired
    private DictService dictService;
    @Autowired
    private DictDataService dictDataService;

    @GetMapping(value={"/api/omc/v2/orders"})
    public ResponseEntity<?> getOrdersByCondition(@RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="orderBy", defaultValue="create_date desc") String orderBy, @RequestParam(name="params", required=false) String params) {
        OrderConditionVO orderCondition = OrderConditionVO.getSelf((String)params);
        orderCondition.setInclude(Integer.valueOf(OrderShoppingEnum.PACK.getCode()));
        List orders = this.orderQueryService.getOrdersByCondition(orderCondition, pageNum.intValue(), pageSize.intValue(), orderBy);
        return ResponseEntity.ok((Object)new PageSerializable(orders));
    }

    @PostMapping(value={"/api/omc/v2/orders/backend"})
    public StdData<?> getOrdersByCondition(@RequestBody OrderConditionVO orderCondition) {
        return StdData.ok((Object)this.orderQueryService.getOrdersByConditionBackend(orderCondition));
    }

    @PostMapping(value={"/api/omc/v2/orders/servicer"})
    public StdData getOrdersByServicer(@RequestBody OrderConditionVO body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        body.setOrderBy("create_date desc");
        body.setServicerIdEq(authoredUser.getTenantId());
        List orders = this.orderQueryService.getTenantOrders(body, body.getPageNum().intValue(), body.getPageSize().intValue(), body.getOrderBy());
        return StdData.ok((Object)new PageSerializable(orders));
    }

    @PostMapping(value={"/api/omc/v2/orders/account"})
    public StdData getOrdersByAccount(@RequestBody OrderConditionVO body) {
        body.setAccountFields();
        List orders = this.orderQueryService.getTenantOrders(body, body.getPageNum().intValue(), body.getPageSize().intValue(), body.getOrderBy());
        return StdData.ok((Object)new PageSerializable(orders));
    }

    @GetMapping(value={"/api/omc/v2/orders/{sid}"})
    public ResponseEntity<?> getOrderBySid(@PathVariable(name="sid") Long sid) {
        OrderVO order = this.orderQueryService.getOrderBySid(sid.longValue());
        return ResponseEntity.ok((Object)order);
    }

    @GetMapping(value={"/api/omc/v2/orders/code/{orderCode}"})
    public ResponseEntity<?> getOrderByCode(@PathVariable(name="orderCode") String orderCode) {
        OrderVO order = this.orderQueryService.findOrderByOrderCode(orderCode);
        return ResponseEntity.ok((Object)order);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/api/omc/v2/orders/{sid}"})
    public ResponseEntity<?> updateOrderPrice(@PathVariable(name="sid") Long sid, @Valid @RequestBody OrderPriceVO orderPrice) {
        orderPrice.setOrderSid(sid);
        this.orderService.updateOrderPrice(orderPrice);
        OrderVO orderVO = this.orderQueryService.getOrderBySid(orderPrice.getOrderSid().longValue());
        this.contractService.createContractAsync(orderVO, this.iamService.getUserToken(orderVO.getTenantId()));
        return ResponseEntity.ok((Object)StdData.ok().build());
    }

    @PostMapping(value={"/api/omc/v2/orders/tossstatus"})
    public StdData<?> updateOrderTossstatus(@Valid @RequestBody TossstatusVO orderPrice) {
        this.orderService.updateOrderTossstatus(orderPrice);
        return StdData.ok().build();
    }

    @DeleteMapping(value={"/api/omc/v2/orders/{sid}"})
    public ResponseEntity<?> deleteOrder(@PathVariable(name="sid") Long sid) {
        this.orderService.cancelAndSendMail(sid.longValue());
        return ResponseEntity.ok((Object)StdData.ok().build());
    }

    @GetMapping(value={"/api/omc/v2/orders/{sid}/logs"})
    public ResponseEntity<?> getOrderLogByOrderSid(@PathVariable(name="sid") Long sid) {
        List orderLogs = this.orderDetailMapper.findByOrderSid(sid.longValue());
        return ResponseEntity.ok((Object)orderLogs);
    }

    @PostMapping(value={"/api/omc/v2/orders/strategy"})
    public ResponseEntity<?> payOrderOffline(@RequestBody(required=true) Map map) {
        Long strategySid = Long.valueOf(map.get("strategySid").toString());
        GoodsStrategy strategy = this.goodsMapper.findStrategyBySid(strategySid.longValue());
        return ResponseEntity.ok((Object)strategy);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/api/omc/v2/orders/{sid}/paydate"})
    public ResponseEntity<?> updateOrderPayDate(@PathVariable(name="sid") Long sid, @RequestBody Map<String, LocalDateTime> body) {
        this.orderService.updateOrderPayDate(sid.longValue(), body.get("payDate"));
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/api/omc/v2/orders/{sid}/authorize"})
    public ResponseEntity<?> orderAuthorization(@PathVariable(name="sid") Long sid) {
        ResponseResult initAuth = this.orderOtherService.authorize(sid.longValue());
        return ResponseEntity.ok((Object)initAuth);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/api/omc/v2/orders/{sid}/initialize"})
    public ResponseEntity<?> orderInitialize(@PathVariable(name="sid") Long sid) {
        ResponseResult initGoods = this.orderOtherService.initialize(sid.longValue());
        return ResponseEntity.ok((Object)initGoods);
    }

    @PostMapping(value={"/api/omc/v2/orders/goods/items/latest"})
    public ResponseEntity<?> getGoodsItems(@RequestBody Map<String, String> body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        String tenantId = body.getOrDefault("tenantId", authoredUser.getTenantId());
        String goodsCode = body.getOrDefault("goodsCode", "");
        return ResponseEntity.ok((Object)this.orderMapper.findGoodsItems(tenantId, goodsCode));
    }

    @GetMapping(value={"/api/omc/v2/orders/check/goods/{goodsSid}"})
    public ResponseEntity<?> checkGoods(@PathVariable(name="goodsSid") Long goodsSid) {
        boolean success = this.orderMapper.existsByGoodsSid(goodsSid.longValue());
        return ResponseEntity.ok((Object)StdData.of((boolean)success));
    }

    @GetMapping(value={"/api/omc/v2/orders/check/goodscode/{goodsCode}"})
    public ResponseEntity<?> checkGoodsOrder(@PathVariable String goodsCode) {
        return ResponseEntity.ok((Object)StdData.of((boolean)this.orderQueryService.existsByGoodsCode(goodsCode)));
    }

    @GetMapping(value={"/api/omc/v2/orders/check/goods/{goodsSid}/{strategySid}"})
    public ResponseEntity<?> checkGoodsStrategy(@PathVariable(name="goodsSid") Long goodsSid, @PathVariable(name="strategySid") Long strategySid) {
        boolean success = this.orderMapper.existsByGoodsSidAndStrategySid(goodsSid.longValue(), strategySid.longValue());
        return ResponseEntity.ok((Object)StdData.of((boolean)success));
    }

    @GetMapping(value={"/api/omc/v2/orders/check/goods/{goodsSid}/nopayment"})
    public ResponseEntity<?> checkNoPaymentByTenantSidAndGoodSid(@PathVariable long goodsSid, @RequestParam(name="strategySid", required=false) Long strategySid, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        GoodsStrategy goodsStrategy;
        long tenantSid = authoredUser.getTenantSid();
        if (Objects.nonNull(strategySid) && Objects.nonNull(goodsStrategy = this.goodsMapper.findStrategyBySid(strategySid.longValue())) && goodsStrategy.getBnpl().booleanValue()) {
            return ResponseEntity.ok((Object)false);
        }
        boolean result = this.orderMapper.existNoPaymentOrder(tenantSid, goodsSid);
        return ResponseEntity.ok((Object)result);
    }

    @GetMapping(value={"/api/omc/v2/orders/check/{goodsSid}/dealer"})
    public ResponseEntity<?> checkDealerOrder(@PathVariable(name="goodsSid") Long goodsSid, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        Long strategySid = this.orderMapper.existsDealerOrder(authoredUser.getTenantSid(), authoredUser.getUserId(), goodsSid.longValue());
        return ResponseEntity.ok((Object)StdData.ok(Collections.singletonMap("strategySid", strategySid)));
    }

    @Transactional
    @PostMapping(value={"/api/omc/v2/orders/user/isv"})
    public StdData<?> updateServicerOrderDetailByUser(@RequestBody ServicerOrderDetailDTO dto) {
        String mailType;
        OrderVO orderVO;
        OrderDetailVO orderDetailVO;
        Long orderSid = dto.getOrderSid();
        Assert.notNull((Object)orderSid, (String)"\u8ba2\u5355sid\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)dto.getConfirm(), (String)"\u7528\u6237\u64cd\u4f5c\u670d\u52a1\u72b6\u6001confirm\u4e0d\u80fd\u4e3a\u7a7a");
        if (Boolean.FALSE.equals(dto.getConfirm())) {
            Assert.hasText((String)dto.getRemark(), (String)"\u9a73\u56de\u670d\u52a1\u65f6\uff0c\u8bf4\u660e\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ((orderDetailVO = (orderVO = this.orderQueryService.getOrderBySid(orderSid.longValue())).getFirstOrderDetail()).getSid() == null) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_ORDER_DETAIL_NOT_EXIST, new Object[]{orderSid});
        }
        Long sid = orderDetailVO.getServicerOrderDetail().getSid();
        if (sid == null) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_SERVICER_ORDER_NOT_EXIST, new Object[]{orderSid});
        }
        ServicerOrderDetail detail = (ServicerOrderDetail)this.servicerOrderDetailRepository.findById((Object)sid).orElseThrow(() -> new BusinessException((ErrorHandler)I18nError.ERROR_SERVICER_ORDER_NOT_EXIST, new Object[]{orderSid}));
        if (!ServiceStatusEnum.WAITING_CONFIRMED.getValue().equals(detail.getServiceStatus())) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_SERVICER_ORDER_NOT_WAITING_CONFIRMED, new Object[]{orderSid});
        }
        if (Boolean.TRUE.equals(dto.getConfirm())) {
            if (GoodsCategoryEnum.PACKAGE.name().equalsIgnoreCase(orderDetailVO.getCategoryId()) || GoodsCategoryEnum.APP.name().equalsIgnoreCase(orderDetailVO.getCategoryId())) {
                detail.setServiceStatus(ServiceStatusEnum.COMPLETED.getValue());
            } else if (GoodsCategoryEnum.SERVICE.name().equalsIgnoreCase(orderDetailVO.getCategoryId())) {
                if (Boolean.TRUE.equals(detail.getServiceComplete())) {
                    detail.setServiceStatus(ServiceStatusEnum.COMPLETED.getValue());
                } else {
                    detail.setServiceStatus(ServiceStatusEnum.SERVICEING.getValue());
                }
            }
            mailType = MailTypeEnum.ISV_ORDER_TENANT_CONFIRMED_EMAIL.name();
        } else {
            detail.setRejectCount(Integer.valueOf(Optional.ofNullable(detail.getRejectCount()).orElse(0) + 1));
            detail.setServiceStatus(ServiceStatusEnum.REJECTED.getValue());
            mailType = MailTypeEnum.ISV_ORDER_TENANT_REJECTED_EMAIL.name();
        }
        EntityUtils.setModifyFields((BaseEntity)detail);
        this.servicerOrderDetailRepository.saveAndFlush((Object)detail);
        if (GoodsCategoryEnum.SERVICE.name().equalsIgnoreCase(orderDetailVO.getCategoryId()) && ServiceStatusEnum.COMPLETED.getValue().equals(detail.getServiceStatus())) {
            this.cacService.updateExpiredDateTime(new ProductTypeVO(orderVO.getTenantId(), orderVO.getOrderCode(), dto.getRemark()));
        }
        this.mailService.sendEmailServicerOrderHandleResult(orderSid, mailType, dto.getRemark(), Boolean.TRUE.booleanValue());
        return StdData.ok().build();
    }

    @Transactional
    @PostMapping(value={"/api/omc/v2/orders/tenant/isv"})
    public StdData updateServicerOrderDetailByServicer(@RequestBody ServicerOrderDetailDTO dto) {
        Long orderSid = dto.getOrderSid();
        Assert.notNull((Object)orderSid, (String)"\u8ba2\u5355sid\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)dto.getServiceDate(), (String)"\u670d\u52a1\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)dto.getServiceUserName(), (String)"\u670d\u52a1\u4eba\u5458\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)dto.getAttachments(), (String)"\u4e0a\u4f20\u9644\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)dto.getServiceResult(), (String)"\u670d\u52a1\u7ed3\u679c\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a");
        OrderVO orderVO = this.orderQueryService.getOrderBySid(orderSid.longValue());
        Long sid = orderVO.getFirstOrderDetail().getServicerOrderDetail().getSid();
        if (sid == null) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_SERVICER_ORDER_NOT_EXIST, new Object[]{orderSid});
        }
        ServicerOrderDetail detail = (ServicerOrderDetail)this.servicerOrderDetailRepository.findById((Object)sid).orElseThrow(() -> new BusinessException((ErrorHandler)I18nError.ERROR_SERVICER_ORDER_NOT_EXIST, new Object[]{orderSid}));
        if (!ServiceStatusEnum.isDeliver((Integer)detail.getServiceStatus())) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_SERVICER_ORDER_NOT_DELIVER, new Object[]{orderSid});
        }
        detail.setServiceDate(dto.getServiceDate());
        detail.setServiceUserName(dto.getServiceUserName());
        detail.setContractStartDate(dto.getContractStartDate());
        detail.setContractEndDate(dto.getContractEndDate());
        if (!Objects.equals(dto.getContractStartDate(), orderVO.getShipmentStartDate()) || !Objects.equals(dto.getContractEndDate(), orderVO.getShipmentEndDate())) {
            Order order = (Order)this.orderCrudService.findBySid(orderSid.longValue());
            order.setShipmentStartDate(dto.getContractStartDate());
            order.setShipmentEndDate(dto.getContractEndDate());
            this.orderCrudService.update((BaseEntity)order);
        }
        detail.setAttachments(dto.getAttachments());
        detail.setServiceResult(dto.getServiceResult());
        detail.setServiceComplete(dto.getServiceComplete());
        detail.setRemark(dto.getRemark());
        detail.setServiceStatus(ServiceStatusEnum.WAITING_CONFIRMED.getValue());
        EntityUtils.setModifyFields((BaseEntity)detail);
        this.servicerOrderDetailRepository.saveAndFlush((Object)detail);
        this.mailService.sendEmailServicerOrderCheck(orderSid);
        return StdData.ok().build();
    }

    @Transactional(rollbackFor={Exception.class})
    @DeleteMapping(value={"/api/omc/v2/{tenantSid}/orders"})
    public ResponseEntity<?> cancelOrder(@PathVariable(name="tenantSid") Long tenantSid) {
        this.orderService.cancelOrdersByTenant(tenantSid);
        return ResponseEntity.ok((Object)StdData.ok().build());
    }

    @GetMapping(value={"/api/omc/v2/bills/summary"})
    public StdData<?> getBills(OMBillSearchConditionVO conditionVO) {
        return StdData.ok((Object)this.orderService.getBills4OM(conditionVO));
    }

    @GetMapping(value={"/api/omc/v2/bills/summary/export"})
    public void exportBills(OMBillSearchConditionVO conditionVO, HttpServletResponse response) throws IOException {
        PageSerializable result = this.orderService.getBills4OM(conditionVO);
        List accountOrders = result.getList().stream().map(OMBillSummaryExcelVO::new).collect(Collectors.toList());
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding("UTF-8");
        String fileName = URLEncoder.encode("\u8d26\u5355", "UTF-8");
        response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".xlsx");
        EasyExcel.write((OutputStream)response.getOutputStream(), OMBillSummaryExcelVO.class).sheet("Sheet1").doWrite(accountOrders);
    }

    @GetMapping(value={"/api/omc/v2/bills/summary/detail/export"})
    public void exportBills(@RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="orderBy", defaultValue="create_date desc") String orderBy, @RequestParam(name="params", required=false) String params, HttpServletResponse response) throws IOException {
        OrderConditionVO orderCondition = OrderConditionVO.getSelf((String)params);
        orderCondition.setOrderType(Integer.valueOf(OrderTypeEnum.BILL.getValue()));
        orderCondition.setInclude(Integer.valueOf(OrderShoppingEnum.PACK.getCode()));
        List orders = this.orderQueryService.getOrdersByCondition(orderCondition, pageNum.intValue(), pageSize.intValue(), orderBy);
        List accountOrders = orders.stream().map(OMBillDetailExcelVO::new).collect(Collectors.toList());
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding("UTF-8");
        String fileName = URLEncoder.encode("\u8d26\u5355\u660e\u7ec6", "UTF-8");
        response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".xlsx");
        EasyExcel.write((OutputStream)response.getOutputStream(), OMBillDetailExcelVO.class).sheet("Sheet1").doWrite(accountOrders);
    }

    @GetMapping(value={"/api/omc/v2/order/bill/notice/config"})
    public StdData<?> orderBillNoticeConfig(@RequestParam(name="threshold") String threshold, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        Dict dict = this.dictService.selectDictById("billNotice");
        if (Objects.isNull(dict)) {
            Dict d = new Dict();
            d.setName("\u8d26\u5355\u901a\u77e5");
            d.setId("billNotice");
            this.dictService.insertDict(d);
        }
        DictDataDTO dictDataDTO = new DictDataDTO();
        dictDataDTO.setDictId("billNotice");
        dictDataDTO.setDictKey("billNotice");
        DictData dictData = this.dictDataService.selectDictData(dictDataDTO);
        if (Objects.isNull(dictData)) {
            DictData newDictData = new DictData();
            newDictData.setDictId("billNotice");
            newDictData.setDictKey("billNotice");
            newDictData.setDictValue(threshold);
            this.dictDataService.insertDictData(newDictData);
        } else {
            dictData.setDictValue(threshold);
            this.dictDataService.updateDictData(dictData);
        }
        return StdData.ok().build();
    }

    @GetMapping(value={"/api/omc/v2/order/pack/details"})
    public StdData<?> packOrderDetails(@RequestParam(name="cartCode") String cartCode) {
        return StdData.ok((Object)this.orderQueryService.getCartOrders(cartCode, false));
    }

    @PostMapping(value={"/api/omc/v2/orders/use/tenant/mod"})
    public StdData<?> updateOrderUseTenant(@RequestBody UpdateOrderRequest request) {
        Order order = (Order)this.orderCrudService.findBySid(request.getOrderSid().longValue());
        if (Objects.isNull(order)) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_10001, new Object[]{request.getOrderSid()});
        }
        order.setUseTenantId(request.getUseTenantId());
        order.setUseTenantName(request.getUseTenantName());
        this.orderCrudService.update((BaseEntity)order);
        return StdData.ok().build();
    }

    @PostMapping(value={"/api/omc/v2/orders/bnpl/purchase/check"})
    public StdData<?> checkOrderCanPurchase(@RequestBody OrderVO checkOrderVO) {
        GoodsStrategy strategy = this.goodsMapper.findStrategyBySid(checkOrderVO.getSid().longValue());
        if (null != strategy) {
            if (Boolean.TRUE.equals(strategy.getBnpl()) && StringUtils.hasText((String)strategy.getIntellyFormId())) {
                List relations = this.iamService.getIntellyRelation(Collections.emptyList(), Collections.singletonList(UserUtils.getTenantId()));
                if (relations.stream().anyMatch(r -> strategy.getIntellyFormId().equals(r.getFormId()) && r.getGroupId().equals(strategy.getIntellyFormGroupId()))) {
                    return StdData.ok((Object)true);
                }
            } else {
                return StdData.ok((Object)true);
            }
        }
        return StdData.ok((Object)false);
    }
}

