/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.api;

import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.omc.constant.I18nError;
import com.digiwin.dap.middleware.omc.constant.enums.GoodsCategoryEnum;
import com.digiwin.dap.middleware.omc.dao.OrderDeviceCrudService;
import com.digiwin.dap.middleware.omc.domain.CommonVO;
import com.digiwin.dap.middleware.omc.domain.PurchaseRegisterInfo;
import com.digiwin.dap.middleware.omc.domain.remote.Goods;
import com.digiwin.dap.middleware.omc.domain.remote.RegisterAuth;
import com.digiwin.dap.middleware.omc.domain.request.OrderDeviceVO;
import com.digiwin.dap.middleware.omc.domain.request.PreOrderDTO;
import com.digiwin.dap.middleware.omc.entity.Order;
import com.digiwin.dap.middleware.omc.entity.OrderDevice;
import com.digiwin.dap.middleware.omc.mapper.DeviceMapper;
import com.digiwin.dap.middleware.omc.mapper.GoodsMapper;
import com.digiwin.dap.middleware.omc.service.preorder.PreOrderService;
import com.digiwin.dap.middleware.omc.support.remote.CacService;
import com.digiwin.dap.middleware.omc.support.remote.GoodsService;
import com.digiwin.dap.middleware.omc.support.remote.IamService;
import com.digiwin.dap.middleware.util.UserUtils;
import com.github.pagehelper.PageSerializable;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"/api/omc/v2/device"})
public class OrderDeviceController {
    @Autowired
    private IamService iamService;
    @Autowired
    private CacService cacService;
    @Autowired
    private DeviceMapper deviceMapper;
    @Autowired
    private OrderDeviceCrudService orderDeviceCrudService;
    @Autowired
    private PreOrderService preOrderService;
    @Autowired
    private GoodsMapper goodsMapper;
    @Autowired
    private GoodsService goodsService;

    @GetMapping
    public StdData getOrdersByCondition(@RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="orderBy", defaultValue="d.sid desc") String orderBy, @RequestParam(name="params", required=false) String params) {
        OrderDeviceVO orderDeviceVO = OrderDeviceVO.getSelf((String)params);
        List devices = this.deviceMapper.findDevices(orderDeviceVO, pageNum.intValue(), pageSize.intValue(), orderBy);
        return StdData.ok((Object)new PageSerializable(devices));
    }

    @PostMapping(value={"/authorizations/status"})
    public StdData registerDate(@RequestBody OrderDeviceVO body) {
        RegisterAuth register;
        OrderDeviceVO device = this.deviceMapper.findDevicesByCode(body.getCode());
        if (device == null) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_10003);
        }
        if (device.getStatus() != 0) {
            return StdData.ok().build();
        }
        if (body.getRegisterDate() == null) {
            body.setRegisterDate(LocalDateTime.now());
        }
        if ((register = this.deviceMapper.findRegister(body.getCode())) == null) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_10003);
        }
        switch (register.getPaymentType()) {
            case 0: 
            case 3: {
                body.setExpireDate(LocalDateTime.of(9999, 12, 31, 23, 59, 59));
                break;
            }
            case 1: 
            case 2: {
                if (GoodsCategoryEnum.DEVICE.name().equalsIgnoreCase(register.getCategoryId()) && register.getInfinity().booleanValue()) {
                    body.setExpireDate(LocalDateTime.of(9999, 12, 31, 23, 59, 59));
                    break;
                }
            }
            case 4: {
                if (0 == device.getOrderSource()) {
                    long months = (long)register.getQuantity().intValue() * (long)register.getTenancyPeriod().intValue();
                    body.setExpireDate(body.getRegisterDate().plusMonths(months).with(LocalTime.of(23, 59, 59)));
                    break;
                }
                body.setExpireDate(register.getExpireDate());
                break;
            }
        }
        return StdData.ok((Object)this.deviceMapper.updateRegister(body.getCode(), body.getRegisterDate(), body.getExpireDate()));
    }

    @GetMapping(value={"/authorizations"})
    public StdData findDevicesByTenant(@RequestParam String tenantId) {
        List devices = this.deviceMapper.findDevicesByTenant(tenantId);
        List dealers = devices.stream().map(OrderDeviceVO::getDealerId).collect(Collectors.toList());
        List tenantSimples = this.iamService.getTenantSimples(dealers);
        Map<String, Long> tenants = tenantSimples.stream().collect(Collectors.toMap(CommonVO::getId, CommonVO::getSid));
        devices.forEach(o -> o.setDealerSid((Long)tenants.get(o.getDealerId())));
        return StdData.ok((Object)devices);
    }

    @GetMapping(value={"/authorizations/code"})
    public StdData findDevicesByCode(@RequestParam String code) {
        OrderDeviceVO device = this.deviceMapper.findDevicesByCode(code);
        if (device == null) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_10003);
        }
        List tenantSimples = this.iamService.getTenantSimples(Collections.singletonList(device.getDealerId()));
        Map<String, Long> tenants = tenantSimples.stream().collect(Collectors.toMap(CommonVO::getId, CommonVO::getSid));
        device.setDealerSid(tenants.get(device.getDealerId()));
        return StdData.ok((Object)device);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/authorizations/cancel"})
    public StdData cancelDate(@RequestBody OrderDeviceVO body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        OrderDeviceVO device = this.deviceMapper.findDevicesByCode(body.getCode());
        if (device == null) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_10003);
        }
        if (authoredUser.getTenantSid() != device.getTenantSid().longValue()) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_10013, new Object[]{device.getTenantId(), authoredUser.getTenantId()});
        }
        if (device.getStatus() > 1) {
            return StdData.ok().build();
        }
        if (body.getCancelDate() == null) {
            body.setCancelDate(LocalDateTime.now());
        }
        if (0 == device.getOrderSource()) {
            Order order = this.deviceMapper.findAuthCode(body.getCode());
            if (order == null) {
                throw new BusinessException((ErrorHandler)I18nError.ERROR_10003);
            }
            if (order.getOrderCode().contains("DEAL")) {
                List authGoods = this.deviceMapper.findAuthGoods(order.getTenantId(), order.getComment());
                this.cacService.cancelAuth(body.getCode(), authGoods, UserUtils.getToken());
                this.deviceMapper.updateAuthDataCancel(order.getComment());
            }
        }
        this.deviceMapper.updateCancel(body.getCode(), body.getCancelDate());
        return StdData.ok().build();
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/authorizations/invalid"})
    public StdData invalidDate(@RequestBody OrderDeviceVO body) {
        OrderDeviceVO device = this.deviceMapper.findDevicesByCode(body.getCode());
        if (device == null) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_10003);
        }
        if (device.getStatus() != 0) {
            return StdData.ok().build();
        }
        if (body.getCancelDate() == null) {
            body.setCancelDate(LocalDateTime.now());
        }
        if (0 == device.getOrderSource()) {
            Order order = this.deviceMapper.findAuthCode(body.getCode());
            if (order == null) {
                throw new BusinessException((ErrorHandler)I18nError.ERROR_10003);
            }
            if (order.getOrderCode().contains("DEAL")) {
                List authGoods = this.deviceMapper.findAuthGoods(order.getTenantId(), order.getComment());
                this.cacService.cancelAuth(body.getCode(), authGoods, UserUtils.getToken());
                this.deviceMapper.updateAuthDataInvalid(order.getComment());
            }
        }
        this.deviceMapper.updateInvalid(body.getCode(), body.getCancelDate());
        return StdData.ok().build();
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/authorizations/{sid}"})
    public StdData edit(@PathVariable(name="sid") Long sid, @RequestBody OrderDeviceVO body) {
        OrderDevice orderDevice;
        if (body.getExpireDate() == null) {
            body.setExpireDate(LocalDateTime.now());
        }
        if ((orderDevice = (OrderDevice)this.orderDeviceCrudService.findBySid(sid.longValue())) != null) {
            orderDevice.setExpireDate(body.getExpireDate());
            orderDevice.setRemark(body.getRemark());
            this.orderDeviceCrudService.update((BaseEntity)orderDevice);
        }
        return StdData.ok().build();
    }

    @PostMapping(value={"/register"})
    public StdData<?> registerDeviceInfo(@RequestBody List<PurchaseRegisterInfo> registerInfos) {
        registerInfos.forEach(r -> {
            Goods goodsInfo = r.generateGoods();
            this.goodsService.saveGoods(goodsInfo);
            Goods goods = this.goodsMapper.findGoodsByCode(r.getProductId());
            PreOrderDTO dto = r.generateOrderVO(goods);
            this.preOrderService.checkAndSave(dto);
        });
        return StdData.ok().build();
    }
}

