/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.api;

import com.digiwin.dap.middle.stream.domain.SysNoticeEnum;
import com.digiwin.dap.middleware.commons.util.StrUtils;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.omc.constant.I18nCode;
import com.digiwin.dap.middleware.omc.constant.I18nError;
import com.digiwin.dap.middleware.omc.dao.InvoiceCrudService;
import com.digiwin.dap.middleware.omc.dao.OrderCrudService;
import com.digiwin.dap.middleware.omc.domain.OrderInitUpdate;
import com.digiwin.dap.middleware.omc.domain.OrderUpdateTenantVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderCommentVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderPriceVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderShipmentDateVO;
import com.digiwin.dap.middleware.omc.entity.Invoice;
import com.digiwin.dap.middleware.omc.entity.Order;
import com.digiwin.dap.middleware.omc.mapper.GoodsMapper;
import com.digiwin.dap.middleware.omc.mapper.OrderUpdateMapper;
import com.digiwin.dap.middleware.omc.mapper.PreOrderDetailMapper;
import com.digiwin.dap.middleware.omc.service.business.OrderSyncService;
import com.digiwin.dap.middleware.omc.service.order.OrderService;
import com.digiwin.dap.middleware.omc.support.remote.CacService;
import com.digiwin.dap.middleware.omc.support.remote.MailService;
import java.util.HashMap;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class OrderHandleController {
    @Autowired
    private GoodsMapper goodsMapper;
    @Autowired
    private CacService cacService;
    @Autowired
    private MailService mailService;
    @Autowired
    private OrderService orderService;
    @Autowired
    private OrderCrudService orderCrudService;
    @Autowired
    private OrderUpdateMapper orderUpdateMapper;
    @Autowired
    private PreOrderDetailMapper preOrderDetailMapper;
    @Autowired
    private InvoiceCrudService invoiceCrudService;
    @Autowired
    private OrderSyncService orderSyncService;

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/api/omc/v2/orders/{sid}/status"})
    public ResponseEntity<?> updateOrderStatus(@PathVariable(name="sid") Long sid) {
        this.orderService.updateOrderStatus(sid.longValue());
        return ResponseEntity.ok((Object)StdData.ok().build());
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/api/omc/v2/orders/{sid}/check/bill/success"})
    public ResponseEntity<?> updateCheckBill(@PathVariable(name="sid") Long sid, @RequestParam(name="school", defaultValue="false") Boolean school) {
        boolean bool = this.goodsMapper.needContractDate(sid.longValue());
        if (bool) {
            return ResponseEntity.ok((Object)StdData.of((int)I18nCode.CODE_10003.getId(), (String)I18nCode.CODE_10003.getMessage()));
        }
        Invoice invoice = this.invoiceCrudService.findByOrderSid(sid.longValue());
        if (invoice == null) {
            return ResponseEntity.ok((Object)StdData.of((int)I18nCode.CODE_30001.getId(), (String)I18nCode.CODE_30001.getMessage()));
        }
        String error = this.orderSyncService.checkInvoice(invoice);
        if (error != null) {
            return ResponseEntity.ok((Object)StdData.of((int)I18nCode.CODE_30002.getId(), (String)error));
        }
        this.orderService.checkItemExist(sid);
        this.orderUpdateMapper.updateOrderCheckBill(sid.longValue(), school.booleanValue());
        return ResponseEntity.ok((Object)StdData.ok().build());
    }

    @GetMapping(value={"/api/omc/v2/orders/{sid}/school/{school}"})
    public ResponseEntity<?> school(@PathVariable(name="sid") Long sid, @PathVariable(name="school") Boolean school) {
        this.orderUpdateMapper.updateOrderSchool(sid.longValue(), school.booleanValue());
        return ResponseEntity.ok((Object)StdData.ok().build());
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/api/omc/v2/orders/{sid}/toss/status"})
    public ResponseEntity<?> updateTossStatus(@PathVariable(name="sid") Long sid, @RequestParam(name="tossStatus", defaultValue="N") String tossStatus) {
        this.orderUpdateMapper.updateOrderTossStatus(tossStatus, sid.longValue());
        return ResponseEntity.ok((Object)StdData.ok().build());
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/api/omc/v2/orders/{sid}/shipmentdate"})
    public ResponseEntity<?> updateOrderShipmentDate(@PathVariable(name="sid") Long sid, @RequestBody OrderShipmentDateVO body) {
        this.orderUpdateMapper.updateOrderShipmentDate(body.getShipmentStartDate(), body.getShipmentEndDate(), sid.longValue());
        return ResponseEntity.ok((Object)StdData.ok().build());
    }

    @PostMapping(value={"/api/omc/v2/orders/comment"})
    public ResponseEntity<?> updateComment(@Valid @RequestBody OrderCommentVO body) {
        Order order = (Order)this.orderCrudService.findBySid(body.getOrderSid().longValue());
        if (null == order) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_10001, new Object[]{body.getOrderSid()});
        }
        if (body.getComment() != null) {
            if (order.getShopping() == 0) {
                this.orderUpdateMapper.updateOrderComment(body.getComment(), order.getSid());
            } else if (order.getShopping() == 1) {
                this.orderUpdateMapper.updateCartOrderComment(body.getComment(), order.getCartCode());
            }
        }
        if (body.getRemark() != null) {
            if (order.getShopping() == 0) {
                this.orderUpdateMapper.updateOrderRemark(body.getRemark(), order.getSid());
            } else if (order.getShopping() == 1) {
                this.orderUpdateMapper.updateCartOrderRemark(body.getRemark(), order.getCartCode());
            }
        }
        return ResponseEntity.ok((Object)StdData.ok().build());
    }

    @PostMapping(value={"/api/omc/v2/orders/{sid}/salemaninfo"})
    public ResponseEntity<?> updateSaleManInfo(@PathVariable long sid, @RequestBody OrderPriceVO body) {
        Order order = (Order)this.orderCrudService.findBySid(sid);
        if (null == order) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_10001, new Object[]{sid});
        }
        if ("service".equals(order.getCategoryId()) && StrUtils.isEmpty((String)body.getDepartCode()) && StrUtils.isEmpty((String)body.getBusinessCode())) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_10006);
        }
        if (body.getBusinessCode() != null) {
            if ("service".equals(order.getCategoryId()) && StrUtils.isEmpty((String)body.getBusinessCode())) {
                throw new BusinessException((ErrorHandler)I18nError.ERROR_10005);
            }
            order.setBusinessCode(body.getBusinessCode());
        }
        if (body.getDepartCode() != null) {
            if ("service".equals(order.getCategoryId()) && StrUtils.isEmpty((String)body.getDepartCode())) {
                throw new BusinessException((ErrorHandler)I18nError.ERROR_10004);
            }
            order.setDepartCode(body.getDepartCode());
        }
        this.orderCrudService.update((BaseEntity)order);
        return ResponseEntity.ok((Object)StdData.ok().build());
    }

    @PostMapping(value={"/api/omc/v2/order/update/tenant"})
    public ResponseEntity<?> updateTenant(@RequestBody @Valid OrderUpdateTenantVO body) {
        this.orderUpdateMapper.updateTestTenant(body.getTestTenant().booleanValue(), body.getTenantId());
        return ResponseEntity.ok((Object)StdData.ok().build());
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/api/omc/v2/orders/{sid}/account/confirm"})
    public StdData updateOrderAccount(@PathVariable(name="sid") Long sid) {
        this.orderService.updateOrderAccount(sid.longValue());
        Order order = (Order)this.orderCrudService.findBySid(sid.longValue());
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("orderSid", order.getSid());
        result.put("orderCode", order.getOrderCode());
        result.put("accountConfirm", order.isAccountConfirm());
        result.put("accountConfirmDate", order.getAccountConfirmDate());
        return StdData.ok(result);
    }

    @PostMapping(value={"/api/omc/v2/orders/initialize/update"})
    public StdData<?> updateInit(@RequestBody OrderInitUpdate body) {
        int initialize;
        OrderInitUpdate.OrderInfo data = body.getData();
        int n = initialize = body.isSuccess() ? 1 : 2;
        if ((SysNoticeEnum.APP_RENEW.name().equals(body.getOpType()) || SysNoticeEnum.APP_ADD_PURCHASE.name().equals(body.getOpType())) && initialize == 2) {
            this.cacService.updateInitializeState(data.getTenantId(), data.getGoodsCode(), Integer.valueOf(3));
            if (SysNoticeEnum.APP_RENEW.name().equals(body.getOpType())) {
                initialize = 3;
            } else if (SysNoticeEnum.APP_ADD_PURCHASE.name().equals(body.getOpType())) {
                initialize = 4;
            }
        } else {
            this.cacService.updateInitializeState(data.getTenantId(), data.getGoodsCode(), Integer.valueOf(initialize));
        }
        if (data.getType() == OrderInitUpdate.OrderType.ORDER) {
            this.orderUpdateMapper.updateOrderInitialize(data.getSid().longValue(), initialize);
            if (!body.isSuccess() && body.isNeedMsg()) {
                this.mailService.sendEmailInitFail(data.getSid().longValue(), body.getMessage());
            }
        } else if (data.getType() == OrderInitUpdate.OrderType.PRE_ORDER) {
            this.preOrderDetailMapper.updateOrderInitialize(data.getSid(), initialize);
            if (!body.isSuccess() && body.isNeedMsg()) {
                this.mailService.sendEmailPreOrderInitFail(data.getSid().longValue(), body.getMessage());
            }
        }
        return StdData.ok().build();
    }
}

