/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.api;

import com.digiwin.dap.middleware.omc.constant.enums.order.OrderSourceEnum;
import com.digiwin.dap.middleware.omc.dao.OrderCouponCrudService;
import com.digiwin.dap.middleware.omc.domain.request.OrderConditionVO;
import com.digiwin.dap.middleware.omc.domain.request.PayConditionVO;
import com.digiwin.dap.middleware.omc.domain.response.OrderDetailResult;
import com.digiwin.dap.middleware.omc.entity.OrderCoupon;
import com.digiwin.dap.middleware.omc.mapper.OrderSyncMapper;
import com.github.pagehelper.PageSerializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class OrderStatsController {
    @Autowired
    private OrderSyncMapper orderSyncMapper;
    @Autowired
    private OrderCouponCrudService orderCouponCrudService;

    @PostMapping(value={"/api/omc/v2/orders/list"})
    public ResponseEntity<?> getOrderDetails(@RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="0") Integer pageSize, @RequestParam(name="orderBy", defaultValue="o.create_date desc") String orderBy, @RequestBody(required=false) OrderConditionVO condition) {
        List orders = pageSize == 0 || pageSize == Integer.MAX_VALUE ? this.orderSyncMapper.findOrderDetails(condition, orderBy) : this.orderSyncMapper.findOrderDetails(condition, pageNum.intValue(), pageSize.intValue(), orderBy);
        HashMap userCountInfoVOSMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)orders)) {
            List collect = orders.stream().map(OrderDetailResult::getSid).collect(Collectors.toList());
            List byOrderSidIn = this.orderCouponCrudService.findByOrderSidIn(collect);
            for (OrderCoupon u : byOrderSidIn) {
                List userInCounting = (List)userCountInfoVOSMap.get(u.getOrderSid());
                if (userInCounting != null) {
                    userInCounting.add(u);
                    continue;
                }
                LinkedList<OrderCoupon> linkedList = new LinkedList<OrderCoupon>();
                linkedList.add(u);
                userCountInfoVOSMap.put(u.getOrderSid(), linkedList);
            }
        }
        orders.forEach(o -> {
            o.setOrderSourceName(OrderSourceEnum.getName((String)o.getOrderSource()));
            List orderCoupons = (List)userCountInfoVOSMap.get(o.getSid());
            if (!CollectionUtils.isEmpty((Collection)orderCoupons)) {
                String collect = orderCoupons.stream().map(OrderCoupon::getCouponRuleName).collect(Collectors.joining(","));
                o.setCouponTypeName(collect);
            }
        });
        return ResponseEntity.ok((Object)new PageSerializable(orders));
    }

    @PostMapping(value={"/api/omc/v2/orders/pay"})
    public ResponseEntity<?> getOrderPay(@RequestBody PayConditionVO body) {
        return ResponseEntity.ok((Object)this.orderSyncMapper.findOrderPay(body));
    }
}

