/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.api;

import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.omc.domain.summary.dto.OrderSummaryEntrustDTO;
import com.digiwin.dap.middleware.omc.domain.summary.dto.OrderSummaryExpensesMonthDTO;
import com.digiwin.dap.middleware.omc.domain.summary.dto.OrderSummaryPendingPaymentDTO;
import com.digiwin.dap.middleware.omc.domain.summary.dto.OrderSummaryProductRenewalDTO;
import com.digiwin.dap.middleware.omc.domain.summary.vo.OrderSummaryBillMonthVO;
import com.digiwin.dap.middleware.omc.domain.summary.vo.OrderSummaryEntrustVO;
import com.digiwin.dap.middleware.omc.domain.summary.vo.OrderSummaryExpensesMonthVO;
import com.digiwin.dap.middleware.omc.domain.summary.vo.OrderSummaryPendingPaymentVO;
import com.digiwin.dap.middleware.omc.domain.summary.vo.OrderSummaryProductRenewalVO;
import com.digiwin.dap.middleware.omc.service.order.OrderSummaryService;
import com.digiwin.dap.middleware.omc.support.schedule.ScheduleTaskService;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class OrderSummaryController {
    @Autowired
    private OrderSummaryService orderSummaryService;
    @Autowired
    private ScheduleTaskService scheduleTaskService;

    @GetMapping(value={"/api/omc/v2/order/summary/expenses/month"})
    public StdData<?> orderSummaryExpensesMonth(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        return StdData.ok((Object)OrderSummaryExpensesMonthVO.convertDTOToVO((OrderSummaryExpensesMonthDTO)this.orderSummaryService.orderSummaryExpensesMonth(Long.valueOf(authoredUser.getTenantSid()))));
    }

    @GetMapping(value={"/api/omc/v2/order/summary/pending/payment"})
    public StdData<?> orderSummaryPendingPayment(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        return StdData.ok((Object)OrderSummaryPendingPaymentVO.convertDTOToVO((OrderSummaryPendingPaymentDTO)this.orderSummaryService.orderSummaryPendingPayment(Long.valueOf(authoredUser.getTenantSid()))));
    }

    @GetMapping(value={"/api/omc/v2/order/summary/product/renewal"})
    public StdData<?> orderSummaryProductRenewal(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        return StdData.ok((Object)OrderSummaryProductRenewalVO.convertDTOToVO((OrderSummaryProductRenewalDTO)this.orderSummaryService.orderSummaryProductRenewal(authoredUser.getTenantId())));
    }

    @GetMapping(value={"/api/omc/v2/order/summary/entrust"})
    public StdData<?> orderSummaryEntrust(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        return StdData.ok((Object)OrderSummaryEntrustVO.convertDTOToVO((OrderSummaryEntrustDTO)this.orderSummaryService.orderSummaryEntrust(Long.valueOf(authoredUser.getTenantSid()))));
    }

    @GetMapping(value={"/api/omc/v2/order/summary/bill/month"})
    public StdData<?> orderSummaryBillMonth(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        return StdData.ok(this.orderSummaryService.orderSummaryBillMonth(Long.valueOf(authoredUser.getTenantSid())).stream().map(OrderSummaryBillMonthVO::convertDTOToVO).collect(Collectors.toList()));
    }

    @GetMapping(value={"/api/omc/v2/order/summary/test"})
    public StdData<?> test() {
        this.scheduleTaskService.overdueBillNotification();
        return StdData.ok().build();
    }
}

