/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.api;

import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.omc.domain.EscloudTenantAuthorization;
import com.digiwin.dap.middleware.omc.service.business.OrderSyncService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class OrderSyncController {
    @Autowired
    private OrderSyncService orderSyncService;

    @GetMapping(value={"/api/sales/order/sync/get/order"})
    public ResponseEntity<?> getUnTossedOrder() {
        return ResponseEntity.ok((Object)this.orderSyncService.selectUnTossedOrder());
    }

    @PutMapping(value={"/api/sales/order/sync/success/{orderId}"})
    public ResponseEntity<?> updateOrderTossSuccessStatus(@PathVariable(value="orderId") String orderSid, @RequestParam(value="code") String dgwFacOrderCode, @RequestParam(value="dgwFacContractCode", required=false) String dgwFacContractCode, @RequestParam(value="customerCode", required=false) String customerCode, @RequestParam(value="language", required=false, defaultValue="zh-CN") String language) {
        this.orderSyncService.updateOrderTossStatus(Boolean.TRUE.booleanValue(), Long.parseLong(orderSid), dgwFacOrderCode, dgwFacContractCode);
        return ResponseEntity.ok((Object)StdData.ok().build());
    }

    @PutMapping(value={"/api/sales/order/sync/failed/{orderId}"})
    public ResponseEntity<?> updateOrderTossFailedStatus(@PathVariable(value="orderId") String orderSid, @RequestParam(value="errorMsg", required=false) String errorMsg, @RequestParam(value="language", required=false, defaultValue="zh-CN") String language) {
        this.orderSyncService.updateOrderTossStatus(Boolean.FALSE.booleanValue(), Long.parseLong(orderSid), errorMsg, null);
        return ResponseEntity.ok((Object)StdData.ok().build());
    }

    @GetMapping(value={"/api/sales/order/sync/get/no/invoice/code/order"})
    public ResponseEntity<?> getNoInvoiceCodeOrder() {
        return ResponseEntity.ok((Object)this.orderSyncService.selectNoInvoiceCodeOrder());
    }

    @PutMapping(value={"/api/sales/order/sync/invoice/code/{orderSid}"})
    public ResponseEntity<?> updateInvoiceCode(@PathVariable(value="orderSid") String orderSid, @RequestParam(value="invoiceCode") String invoiceCode) {
        this.orderSyncService.updateInvoiceCode(Long.parseLong(orderSid), invoiceCode);
        return ResponseEntity.ok((Object)StdData.ok().build());
    }

    @GetMapping(value={"/api/sales/order/sync/get/tenant/authorizations"})
    public StdData getTenantAuthorizations(@RequestParam(value="tenantId") String tenantId) {
        EscloudTenantAuthorization authorization = this.orderSyncService.getTenantAuthorization(tenantId);
        return StdData.ok((Object)authorization);
    }
}

