/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.api;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.omc.constant.I18nCode;
import com.digiwin.dap.middleware.omc.constant.I18nError;
import com.digiwin.dap.middleware.omc.constant.enums.GoodsCategoryEnum;
import com.digiwin.dap.middleware.omc.constant.enums.PaymentTypeEnum;
import com.digiwin.dap.middleware.omc.constant.enums.TossStatusEnum;
import com.digiwin.dap.middleware.omc.constant.enums.pay.TradeStatusEnum;
import com.digiwin.dap.middleware.omc.dao.OrderCrudService;
import com.digiwin.dap.middleware.omc.dao.PaymentCrudService;
import com.digiwin.dap.middleware.omc.domain.EnvProperties;
import com.digiwin.dap.middleware.omc.domain.pay.Execution;
import com.digiwin.dap.middleware.omc.domain.pay.StdDataReturn;
import com.digiwin.dap.middleware.omc.domain.pay.TradeQueryResponse;
import com.digiwin.dap.middleware.omc.domain.remote.DwPayCallback;
import com.digiwin.dap.middleware.omc.domain.remote.PayCallback;
import com.digiwin.dap.middleware.omc.domain.request.OrderCommentVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderVO;
import com.digiwin.dap.middleware.omc.domain.request.PaymentVO;
import com.digiwin.dap.middleware.omc.entity.Order;
import com.digiwin.dap.middleware.omc.entity.Payment;
import com.digiwin.dap.middleware.omc.mapper.PaymentMapper;
import com.digiwin.dap.middleware.omc.service.business.OrderSyncService;
import com.digiwin.dap.middleware.omc.service.order.OrderLogService;
import com.digiwin.dap.middleware.omc.service.order.OrderQueryService;
import com.digiwin.dap.middleware.omc.service.order.PaymentService;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

@RestController
public class PaymentController {
    private static final Logger logger = LoggerFactory.getLogger(PaymentController.class);
    private static final String PAY_TYPE = "order_pay_success";
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private PaymentMapper paymentMapper;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private PaymentService paymentService;
    @Autowired
    private OrderLogService orderLogService;
    @Autowired
    private OrderSyncService orderSyncService;
    @Autowired
    private OrderCrudService orderCrudService;
    @Autowired
    private OrderQueryService orderQueryService;
    @Autowired
    private PaymentCrudService paymentCrudService;

    @GetMapping(value={"/api/omc/v2/payment/type"})
    public ResponseEntity<?> getPaymentType() {
        return ResponseEntity.ok((Object)this.paymentMapper.findPaymentType(this.envProperties.getCountry()));
    }

    @GetMapping(value={"/api/omc/v2/payment/uri"})
    public ResponseEntity<?> getPayUri(@RequestParam(name="orderSid") Long orderSid, @RequestParam(required=false) String backUrl, @RequestParam(required=false, defaultValue="false") Boolean app) {
        StdData stdData = this.paymentService.getPayUri(orderSid.longValue(), backUrl, app);
        return ResponseEntity.ok((Object)stdData);
    }

    @GetMapping(value={"/api/omc/v2/payment/check/{orderSid}"})
    public ResponseEntity<?> payCheck(@PathVariable(name="orderSid") Long orderSid) {
        StdData stdData = this.paymentService.payCheck(orderSid.longValue());
        return ResponseEntity.ok((Object)stdData);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/api/omc/v2/payment/cancel"})
    public StdData payCancel(@Valid @RequestBody OrderCommentVO body) {
        Order order = (Order)this.orderCrudService.findBySid(body.getOrderSid().longValue());
        if (order == null) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_10001, new Object[]{body.getOrderSid()});
        }
        if (order.getShopping() != 1 && order.getCartCode() == null) {
            throw new BusinessException(String.format("\u8ba2\u5355[%s]\u4e0d\u662f\u8d2d\u7269\u5355", body.getOrderSid()));
        }
        List cartOrders = this.orderQueryService.getCartOrders(order.getCartCode(), false);
        StringBuilder msg = new StringBuilder();
        for (OrderVO o : cartOrders) {
            boolean flag1 = GoodsCategoryEnum.SERVICE.name().equalsIgnoreCase(o.getCategoryId());
            boolean flag2 = o.getOrderStatus() == 1;
            boolean flag3 = PaymentTypeEnum.Offline.getId().equalsIgnoreCase(o.getPayment().getPayMethod());
            boolean flag4 = TossStatusEnum.N.name().equals(o.getTossStatus());
            if (flag1 && flag2 && flag3 && flag4) continue;
            msg.append("\u8ba2\u5355[").append(o.getOrderCode()).append("]\uff1a");
            if (!flag1) {
                msg.append("\u670d\u52a1\u6027\u5546\u54c1[\u4e0d\u6ee1\u8db3],");
            }
            if (!flag2) {
                msg.append("\u5df2\u4ed8\u6b3e[\u4e0d\u6ee1\u8db3],");
            }
            if (!flag3) {
                msg.append("\u7ebf\u4e0b\u652f\u4ed8[\u4e0d\u6ee1\u8db3],");
            }
            if (!flag4) {
                msg.append("\u672a\u629b\u7816[\u4e0d\u6ee1\u8db3],");
            }
            msg.deleteCharAt(msg.length() - 1);
            msg.append(";");
        }
        if (msg.length() > 0) {
            throw new BusinessException(msg.toString());
        }
        this.paymentService.cancelCartPayment(order.getCartCode(), body.getRemark());
        return StdData.ok().build();
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/api/omc/v2/payment/refund"})
    public StdData<?> payRefund(@Valid @RequestBody PaymentVO body) {
        Order order = (Order)this.orderCrudService.findBySid(body.getOrderSid().longValue());
        if (order == null) {
            return StdData.ok((Object)I18nError.ERROR_10001.getErrorMessage(new Object[]{body.getOrderSid()}));
        }
        if (order.getShopping() != 0) {
            return StdData.ok((Object)String.format("\u666e\u901a\u8ba2\u5355[%s]\u624d\u652f\u6301\u9000\u6b3e", order.getOrderCode()));
        }
        if (order.getOrderStatus() != 1) {
            return StdData.ok((Object)String.format("\u5df2\u7ecf\u4ed8\u6b3e\u7684\u8ba2\u5355[%s]\u624d\u9700\u8981\u9000\u6b3e", order.getOrderCode()));
        }
        Payment payment = this.paymentCrudService.findByOrderSidAndTradeStatus(body.getOrderSid().longValue(), TradeStatusEnum.TRADE_CLOSED.name());
        if (payment != null) {
            payment.setPayDate(body.getPayDate() == null ? LocalDateTime.now() : body.getPayDate());
            payment.setAmount(body.getAmount() == null ? order.getPayPrice() : body.getAmount());
            payment.setRemark(body.getRemark() == null ? payment.getRemark() : body.getRemark());
            this.paymentCrudService.update((BaseEntity)payment);
        } else {
            body.setPayDate(body.getPayDate() == null ? LocalDateTime.now() : body.getPayDate());
            body.setAmount(body.getAmount() == null ? order.getPayPrice() : body.getAmount());
            body.setTradeStatus(TradeStatusEnum.TRADE_CLOSED.name());
            this.paymentCrudService.create((BaseEntity)body.doForward());
        }
        order.setOrderStatus(Integer.valueOf(2));
        this.orderCrudService.update((BaseEntity)order);
        return StdData.ok().build();
    }

    @PostMapping(value={"/api/omc/v2/pay/callback"})
    public ResponseEntity<?> payCallback2(@Valid @RequestBody DwPayCallback payCallback) {
        StdDataReturn stdDataReturn = new StdDataReturn();
        try {
            if (!Boolean.TRUE.equals(payCallback.getAuthStatus())) {
                throw new BusinessException("\u4ea4\u6613\u72b6\u6001\u5931\u8d25");
            }
            Order order = this.orderCrudService.findByOutTradeNo(payCallback.getOutTradeNo());
            if (order == null || order.getOrderStatus() == 1) {
                throw new BusinessException("\u8ba2\u5355\u4e0d\u5b58\u5728\u6216\u8ba2\u5355\u5df2\u652f\u4ed8");
            }
            this.orderLogService.payCallbackLog(order.getSid(), payCallback.getOutTradeNo());
            this.orderSyncService.dwPayCallback(payCallback, order.getSid());
            stdDataReturn.setParameter("Success");
            stdDataReturn.setExecution(new Execution("0", "Success"));
        }
        catch (Exception e) {
            stdDataReturn.setParameter("Fail");
            stdDataReturn.setExecution(new Execution("-1", e.getMessage()));
        }
        return ResponseEntity.ok((Object)stdDataReturn);
    }

    @PostMapping(value={"/api/pay/callback"})
    public ResponseEntity<?> payCallback(@Valid @RequestBody PayCallback payCallback) {
        StdDataReturn stdDataReturn = new StdDataReturn();
        try {
            if (!PAY_TYPE.equals(payCallback.getType())) {
                throw new BusinessException(String.format("\u8bf7\u8bbe\u7f6e\u56de\u8c03\u7c7b\u578b\u4e3a[%s]", PAY_TYPE));
            }
            TradeQueryResponse tradeQuery = payCallback.getTrade_query_response();
            if (TradeStatusEnum.TRADE_SUCCESS != tradeQuery.getTrade_status()) {
                throw new BusinessException(String.format("\u4ea4\u6613\u72b6\u6001[%s]", tradeQuery.getTrade_status().name()));
            }
            Order order = this.orderCrudService.findByOutTradeNo(tradeQuery.getOut_trade_no());
            if (order == null || order.getOrderStatus() == 1) {
                throw new BusinessException("\u8ba2\u5355\u4e0d\u5b58\u5728\u6216\u8ba2\u5355\u5df2\u652f\u4ed8");
            }
            this.orderLogService.payCallbackLog(order.getSid(), tradeQuery.getOut_trade_no());
            this.orderSyncService.payCallback(tradeQuery, order.getSid());
            stdDataReturn.setParameter("Success");
            stdDataReturn.setExecution(new Execution("0", "Success"));
        }
        catch (Exception e) {
            stdDataReturn.setParameter("Fail");
            stdDataReturn.setExecution(new Execution("-1", e.getMessage()));
        }
        return ResponseEntity.ok((Object)stdDataReturn);
    }

    @GetMapping(value={"/api/pay/health"})
    public ResponseEntity<?> checkPayHealth() {
        try {
            ResponseEntity stdData = this.restTemplate.exchange(this.envProperties.getPayUri(), HttpMethod.GET, HttpEntity.EMPTY, Map.class, new Object[0]);
            if (stdData != null && HttpStatus.OK.equals((Object)stdData.getStatusCode())) {
                return ResponseEntity.ok((Object)HttpStatus.OK);
            }
        }
        catch (Exception e) {
            logger.error("\u652f\u4ed8\u4e2d\u5fc3\u8bbf\u95ee\u5931\u8d25", (Throwable)e);
        }
        return ResponseEntity.ok((Object)StdData.of((int)I18nCode.CODE_90001.getId(), (String)I18nCode.CODE_90001.getMessage()));
    }
}

