/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.api;

import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.commons.util.StrUtils;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.omc.constant.enums.ShippingTypeEnum;
import com.digiwin.dap.middleware.omc.domain.CopySubtenantPreOrderVO;
import com.digiwin.dap.middleware.omc.domain.PreOrderTenantAppVO;
import com.digiwin.dap.middleware.omc.domain.report.PreOrderRelateCodeVO;
import com.digiwin.dap.middleware.omc.domain.report.PreOrderReportRequestVO;
import com.digiwin.dap.middleware.omc.domain.request.PreOrderDTO;
import com.digiwin.dap.middleware.omc.domain.response.PreOrderVO;
import com.digiwin.dap.middleware.omc.domain.response.ResponseResult;
import com.digiwin.dap.middleware.omc.service.business.ReportDataService;
import com.digiwin.dap.middleware.omc.service.order.OrderOtherService;
import com.digiwin.dap.middleware.omc.service.preorder.PreOrderAutoService;
import com.digiwin.dap.middleware.omc.service.preorder.PreOrderService;
import com.digiwin.dap.middleware.omc.support.remote.MailService;
import com.digiwin.dap.middleware.omc.support.remote.SysNoticeService;
import com.digiwin.dap.middleware.omc.support.schedule.PreOrderContext;
import com.digiwin.dap.middleware.omc.support.schedule.PreOrderParameters;
import com.github.pagehelper.PageInfo;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/omc/v2/pre"})
public class PreOrderController {
    private static final Logger LOGGER = LoggerFactory.getLogger(PreOrderController.class);
    @Autowired
    private PreOrderService preOrderService;
    @Autowired
    private OrderOtherService orderOtherService;
    @Autowired
    private PreOrderAutoService preOrderAutoService;
    @Autowired
    private MailService mailService;
    @Autowired
    private ReportDataService reportDataService;
    @Autowired
    private SysNoticeService sysNoticeService;

    @PostMapping(value={"/order"})
    public StdData<?> savePreOrder(@RequestBody PreOrderDTO dto) {
        PreOrderVO preOrderVO = this.preOrderService.checkAndSave(dto);
        this.preOrderAutoService.autoPreOrderProcess(LocalDateTime.now(), preOrderVO);
        return StdData.ok((Object)preOrderVO);
    }

    @PutMapping(value={"/order"})
    public StdData<?> updatePreOrder(@RequestBody PreOrderDTO dto) {
        Long preOrderSid = this.preOrderService.checkAndupdate(dto);
        this.preOrderAutoService.autoPreOrderProcess(LocalDateTime.now(), this.preOrderService.findPreOrderAndDtlBySid(preOrderSid));
        return StdData.ok((Object)preOrderSid);
    }

    @PostMapping(value={"/order/edit"})
    public StdData<?> editPreOrder(@RequestBody PreOrderDTO dto) {
        this.preOrderService.editPreOrder(dto);
        return StdData.ok().build();
    }

    @GetMapping(value={"/order/{sid}"})
    public StdData<?> getPreOrder(@PathVariable Long sid) {
        return StdData.ok((Object)this.preOrderService.findPreOrderAndDtlBySid(sid));
    }

    @DeleteMapping(value={"/order/{sid}"})
    public StdData<?> deletePreOrder(@PathVariable Long sid) {
        this.preOrderService.deletePreOrderAndDtlBySid(sid);
        return StdData.ok().build();
    }

    @GetMapping(value={"/orders"})
    public StdData getPreOrders(@RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="orderBy", defaultValue="po.sid desc") String orderBy, @RequestParam(name="params", required=false) String params) {
        return StdData.ok((Object)this.preOrderService.getPreOrders(pageNum, pageSize, orderBy, PreOrderDTO.getSelf((String)params)));
    }

    @GetMapping(value={"/orders/backend"})
    public StdData getPreOrdersBackend(@RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="orderBy", defaultValue="po.sid desc") String orderBy, @RequestParam(name="params", required=false) String params) {
        return StdData.ok((Object)this.preOrderService.getPreOrdersBackend(pageNum, pageSize, orderBy, PreOrderDTO.getSelf((String)params)));
    }

    @GetMapping(value={"/order/list"})
    public StdData getPreOrderList(@RequestParam(name="params", required=false) String params, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        return StdData.ok((Object)this.preOrderService.getPreOrderList(PreOrderDTO.getSelf((String)params)));
    }

    @PostMapping(value={"/order/exists"})
    public StdData<?> existedPreOrderList(@RequestBody PreOrderDTO dto) {
        return StdData.ok((Object)(!CollectionUtils.isEmpty((Collection)this.preOrderService.getPreOrderListExcludeDataPolicy(dto)) ? 1 : 0));
    }

    @PostMapping(value={"/order/test"})
    public StdData<Boolean> savePreOrderForTest(@RequestBody @Valid PreOrderDTO preOrderDTO) {
        return StdData.ok((Object)this.preOrderService.savePreOrderForTest(preOrderDTO));
    }

    @PostMapping(value={"/orders"})
    public StdData<Boolean> savePreOrders(@RequestBody List<PreOrderDTO> list) {
        try {
            PreOrderContext.set((PreOrderParameters)new PreOrderParameters(true));
            List preOrders = this.preOrderService.saveAllWithCheck(list);
            preOrders.forEach(preOrderVO -> this.preOrderAutoService.autoPreOrderProcess(LocalDateTime.now(), preOrderVO));
            this.mailService.sendGoodsToEnableEmailMerged(PreOrderContext.get().getMails());
            this.sysNoticeService.pushPackPreOrder(list);
        }
        finally {
            PreOrderContext.clear();
        }
        return StdData.ok((Object)Boolean.TRUE);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"orders/{sid}/initialize"})
    public ResponseEntity<?> orderInitialize(@PathVariable(name="sid") Long sid) {
        ResponseResult initGoods = this.orderOtherService.initializePre(sid.longValue());
        return ResponseEntity.ok((Object)initGoods);
    }

    @PostMapping(value={"/orders/query/auth/with/test/tenant"})
    public StdData<?> getPreAuthWithTestTenant(@RequestBody PreOrderDTO dto) {
        return StdData.ok((Object)this.preOrderService.getPreAuthWithTestTenant(dto));
    }

    @PostMapping(value={"/orders/query/secretkey/with/test/tenant"})
    public StdData<?> getTenantSecretKey(@RequestBody PreOrderDTO dto) {
        dto.setShowAuthCode(Boolean.valueOf(true));
        return StdData.ok((Object)this.preOrderService.getTenantSecretKey(dto));
    }

    @PostMapping(value={"/orders/obsolete"})
    public StdData<?> obsoletePreOrder(@RequestBody PreOrderTenantAppVO dto) {
        this.preOrderService.obsoleteBySourceCode(dto);
        return StdData.ok().build();
    }

    @PostMapping(value={"/orders/obsolete/back"})
    public StdData<?> obsoletePreOrderBack(@RequestBody PreOrderTenantAppVO dto) {
        dto.setBackend(true);
        this.preOrderService.obsoleteBySourceCode(dto);
        return StdData.ok().build();
    }

    @PostMapping(value={"/order/customer/shipping/info"})
    public StdData<?> getCustomerShippingInfo(@RequestBody PreOrderDTO dto) {
        Assert.notNull((Object)dto.getShippingType(), (String)"\u51fa\u8d27\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)ShippingTypeEnum.contains((Integer)dto.getShippingType()), (String)String.format("\u672a\u77e5\u7684\u51fa\u8d27\u7c7b\u578b[%s]", dto.getShippingType()));
        if (ShippingTypeEnum.SHIPMENT.getValue().equals(dto.getShippingType())) {
            Assert.hasText((String)dto.getSourceBillCode(), (String)"\u51fa\u8d27\u7684\u6765\u6e90\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.hasText((String)dto.getCompanyId(), (String)"\u51fa\u8d27\u7684\u516c\u53f8\u522b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return StdData.ok((Object)this.preOrderService.getMiswsCustomerInfo(dto));
    }

    @PostMapping(value={"/order/customer/info"})
    public StdData<?> getCustomerInfo(@RequestBody PreOrderDTO dto) {
        Assert.hasText((String)dto.getPotentialCustomerId(), (String)"\u6f5c\u5ba2\u4ee3\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        return StdData.ok((Object)this.preOrderService.getCustServiceData(dto));
    }

    @PostMapping(value={"/order/tenant/info"})
    public StdData<?> getTenantInfo(@RequestBody PreOrderDTO dto) {
        Assert.hasText((String)dto.getCustomerId(), (String)"\u5ba2\u670d\u4ee3\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        PreOrderVO vo = this.preOrderService.getCustomerTenantInfo(dto);
        return StdData.ok((Object)vo);
    }

    @GetMapping(value={"/synchronous/goods"})
    public StdData getSynchronousPurchaseGoods() {
        List purchaseVOList = this.preOrderService.getSynchronousPurchases();
        return StdData.ok((Object)purchaseVOList);
    }

    @PostMapping(value={"/synchronous/state/update"})
    public StdData batchUpdateState(@RequestBody List<Long> purchaseSids) {
        if (purchaseSids.size() > 0) {
            this.preOrderService.updateSynchronized(purchaseSids);
        }
        return StdData.ok().build();
    }

    @PostMapping(value={"/orders/acp/sync"})
    public StdData<?> saveAllAcpPreOrderSync(@RequestBody List<PreOrderDTO> list) {
        String errorMsg = this.preOrderService.checkAllAcpPreOrder(list);
        boolean success = StrUtils.isEmpty((String)errorMsg);
        Map<Boolean, List<PreOrderDTO>> booleanListMap = list.stream().collect(Collectors.groupingBy(x -> StrUtils.isEmpty((String)x.getErrorMsg())));
        if (booleanListMap.get(Boolean.TRUE) != null) {
            List preOrders = this.preOrderService.saveAllWithCheck(booleanListMap.get(Boolean.TRUE));
            preOrders.forEach(preOrderVO -> this.preOrderAutoService.autoPreOrderProcess(LocalDateTime.now(), preOrderVO));
        }
        this.mailService.sendEmailAutoShipmentResult(list, success);
        if (!success) {
            LOGGER.info("\u51fa\u901a\u5355\u6279\u91cf\u540c\u6b65 errorMsg = {}", (Object)errorMsg);
            return StdData.of((int)500, (String)(errorMsg + "\u8acb\u624b\u52d5\u81f3om\u51fa\u8ca8\u6388\u6b0a\u3002"));
        }
        return StdData.ok((Object)Boolean.TRUE);
    }

    @PostMapping(value={"/orders/acp/cancel"})
    public StdData<?> cancalAcpPreOrder(@RequestBody PreOrderTenantAppVO preOrderTenantAppVO) {
        Assert.hasText((String)preOrderTenantAppVO.getSourceBillCode(), (String)"\u51fa\u8d27\u5355\u53f7\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        Assert.hasText((String)preOrderTenantAppVO.getCompanyId(), (String)"\u516c\u53f8\u522b\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        ResponseResult result = this.preOrderService.cancelAcpPreOrders(preOrderTenantAppVO);
        if (result.isSuccess()) {
            return StdData.ok().build();
        }
        return StdData.of((int)500, (String)result.getMessage());
    }

    @PostMapping(value={"/report"})
    public StdData<?> extractData(@RequestBody PreOrderReportRequestVO preOrderTenantAppVO) {
        return StdData.ok((Object)new PageInfo(this.reportDataService.queryReport(preOrderTenantAppVO)));
    }

    @PostMapping(value={"/relate/code"})
    public StdData<?> searchOrder(@Validated @RequestBody PreOrderRelateCodeVO preOrderTenantAppVO) {
        return StdData.ok((Object)this.reportDataService.queryOrderCode(preOrderTenantAppVO));
    }

    @PostMapping(value={"/copy/sub"})
    public StdData<?> copySubTenantPreOrders(@RequestBody CopySubtenantPreOrderVO input) {
        this.preOrderService.copySubTenantPreOrders(input);
        return StdData.ok().build();
    }
}

