/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.api;

import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.omc.dao.ShoppingCartCrudService;
import com.digiwin.dap.middleware.omc.domain.ShoppingCartOrderDetailVO;
import com.digiwin.dap.middleware.omc.domain.ShoppingCartVO;
import com.digiwin.dap.middleware.omc.service.shoppingcart.ShoppingCartCheckService;
import com.digiwin.dap.middleware.omc.service.shoppingcart.ShoppingCartCountService;
import com.digiwin.dap.middleware.omc.service.shoppingcart.ShoppingCartOrderQueryService;
import com.digiwin.dap.middleware.omc.service.shoppingcart.ShoppingCartQueryService;
import com.digiwin.dap.middleware.omc.service.shoppingcart.ShoppingCartService;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/omc/v2/shoppingcart"})
public class ShoppingCartController {
    @Autowired
    private ShoppingCartService shoppingCartService;
    @Autowired
    private ShoppingCartCrudService shoppingCartCrudService;
    @Autowired
    private ShoppingCartCheckService shoppingCartCheckService;
    @Autowired
    private ShoppingCartCountService shoppingCartCountService;
    @Autowired
    private ShoppingCartQueryService shoppingCartQueryService;
    @Autowired
    private ShoppingCartOrderQueryService shoppingCartOrderQueryService;

    @PostMapping(value={""})
    public ResponseEntity<?> addShoppingTrolley(@RequestBody ShoppingCartVO shoppingCartVO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        shoppingCartVO.setUserSid(authoredUser.getSid());
        this.shoppingCartService.addShoppingCart(shoppingCartVO);
        return ResponseEntity.ok((Object)StdData.ok().build());
    }

    @GetMapping(value={"/count"})
    public ResponseEntity<?> getShoppingTrolleyCount(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        long userSid = authoredUser.getSid();
        int count = this.shoppingCartCountService.getShoppingCartCountByUserSid(userSid);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("count", count);
        return ResponseEntity.ok(map);
    }

    @GetMapping(value={""})
    public ResponseEntity<?> getShoppingTrolley(@RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        long userSid = authoredUser.getSid();
        List shoppingCarts = this.shoppingCartQueryService.getShoppingCarts(userSid);
        return ResponseEntity.ok((Object)shoppingCarts);
    }

    @DeleteMapping(value={"/{sid}"})
    public ResponseEntity<?> deleteShoppingTrolley(@PathVariable long sid) {
        this.shoppingCartCrudService.deleteById(sid);
        return ResponseEntity.ok((Object)StdData.ok().build());
    }

    @PostMapping(value={"/batch/remove"})
    public ResponseEntity<?> batchDeleteShoppingTrolley(@RequestBody List<Long> sids) {
        this.shoppingCartService.batchDeleteShoppingCart(sids);
        return ResponseEntity.ok((Object)StdData.ok().build());
    }

    @PostMapping(value={"/check"})
    public ResponseEntity<?> checkShoppingTrolley(@RequestBody ShoppingCartVO shoppingCartVO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        shoppingCartVO.setUserSid(authoredUser.getSid());
        boolean result = this.shoppingCartCheckService.checkShoppingCart(shoppingCartVO);
        return ResponseEntity.ok(Collections.singletonMap("exist", result));
    }

    @GetMapping(value={"/order/{cartCode}"})
    public ResponseEntity<?> getShoppingCart(@PathVariable String cartCode) {
        ShoppingCartOrderDetailVO shoppingCartOrderDetailVO = this.shoppingCartOrderQueryService.getShoppingCartOrderDetailVo(cartCode);
        return ResponseEntity.ok((Object)shoppingCartOrderDetailVO);
    }
}

