/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.api;

import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.omc.domain.remote.AuthorizationVO;
import com.digiwin.dap.middleware.omc.domain.request.CopyAppAuthVO;
import com.digiwin.dap.middleware.omc.domain.request.GoodsAuthDO;
import com.digiwin.dap.middleware.omc.domain.response.ResponseResult;
import com.digiwin.dap.middleware.omc.service.preorder.PreOrderAutoService;
import com.digiwin.dap.middleware.omc.support.remote.AuthService;
import com.digiwin.dap.middleware.omc.support.remote.CacService;
import com.digiwin.dap.middleware.omc.support.remote.GoodsService;
import com.digiwin.dap.middleware.omc.util.BatchCodeUtil;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/omc/v2/sys"})
public class SysAuthorizationController {
    private static final Logger logger = LoggerFactory.getLogger(SysAuthorizationController.class);
    @Autowired
    private CacService cacService;
    @Autowired
    private AuthService authService;
    @Autowired
    private PreOrderAutoService preOrderAutoService;
    @Autowired
    private GoodsService goodsService;

    @PostMapping(value={"/authorization"})
    public StdData<?> authorization(@RequestBody List<GoodsAuthDO> goodsAuthDOList) {
        logger.info("\u8c03\u7528\u3010\u5546\u54c1\u6388\u6743\u548c\u521d\u59cb\u5316\u3011\u63a5\u53e3\u7684\u5e94\u7528={}\uff0c\u79df\u6237={}\uff0c\u7528\u6237={}", new Object[]{UserUtils.getSysId(), UserUtils.getTenantId(), UserUtils.getUserId()});
        logger.info("0.API\u6ce8\u518c\u6388\u6743\u5f00\u59cb\uff0c\u6388\u6743\u4fe1\u606f:{}", (Object)JsonUtils.writeValue(goodsAuthDOList));
        ArrayList errorList = new ArrayList();
        String batchCode = BatchCodeUtil.generateBatchCode((String)BatchCodeUtil.API);
        goodsAuthDOList.forEach(goodsAuthDO -> {
            ResponseResult responseResult;
            goodsAuthDO.setBatchCode(batchCode);
            if (0 == goodsAuthDO.getAction()) {
                this.goodsService.checkAndCreateStrategy(goodsAuthDO.getStrategyCode(), goodsAuthDO.getStrategyDetail());
            }
            if (null == (responseResult = this.authService.authAndNoticeAndPlatform(goodsAuthDO)) || Boolean.FALSE.equals(responseResult.isSuccess())) {
                HashMap<String, String> errorInfo = new HashMap<String, String>();
                errorInfo.put(goodsAuthDO.getAppId(), responseResult.getMessage());
                errorList.add(errorInfo);
                logger.error("\u521d\u59cb\u5316\u6216\u6388\u6743\u5931\u8d25\uff0c{}", (Object)responseResult.getMessage());
                return;
            }
            if (1 != goodsAuthDO.getAction()) {
                this.preOrderAutoService.autoPreOrder(goodsAuthDO);
                this.preOrderAutoService.autoPreOrderAccessory(goodsAuthDO);
            }
            logger.info("1.\u96c6\u6210\u6ce8\u518c\u5e94\u7528{}\u6388\u6743\u7ed3\u675f", (Object)goodsAuthDO.getAppId());
        });
        if (errorList.isEmpty()) {
            return StdData.ok().build();
        }
        return StdData.of((int)500, (String)JsonUtils.writeValue(errorList));
    }

    @PostMapping(value={"/initialize"})
    public StdData<?> initialize(@RequestBody CopyAppAuthVO copyAppAuthVO) {
        logger.info("0.0.API\u521d\u59cb\u5316\u5f00\u59cb\uff0c\u521d\u59cb\u5316\u4fe1\u606f:{}", (Object)JsonUtils.writeValue((Object)copyAppAuthVO));
        ArrayList goodsAuthDOList = new ArrayList();
        if (1 == copyAppAuthVO.getType()) {
            copyAppAuthVO.getAuthorizations().forEach(a -> {
                GoodsAuthDO goodsAuthDO = new GoodsAuthDO(copyAppAuthVO);
                goodsAuthDO.setTenantSid(a.getTenantSid());
                goodsAuthDO.setTenantId(a.getTenantId());
                goodsAuthDO.setTenantName(a.getTenantName());
                goodsAuthDO.setAppId(a.getId());
                goodsAuthDO.setStrategyCode(a.getStrategyCode());
                goodsAuthDO.setEffectiveDateTime(null == a.getEffectiveTime() ? LocalDateTime.now() : a.getEffectiveTime());
                goodsAuthDO.setExpiredDateTime(a.getExpiredTime());
                goodsAuthDO.setUserNumber(String.valueOf(a.getTotalUsage()));
                goodsAuthDO.setAction(Integer.valueOf(2));
                goodsAuthDO.setValidateOldAuth(Boolean.valueOf(true));
                goodsAuthDO.setOldAuthInfo(a.getOldAuthInfo() == null ? null : new AuthorizationVO(a.getOldAuthInfo()));
                goodsAuthDOList.add(goodsAuthDO);
            });
        } else if (0 == copyAppAuthVO.getType()) {
            List tenantIds = copyAppAuthVO.getAuthorizations().stream().map(AuthorizationVO::getTenantId).collect(Collectors.toList());
            List cacAuths = this.cacService.queryAllAuthorization(tenantIds, copyAppAuthVO.getAppIds());
            if (!copyAppAuthVO.getAuthorizations().isEmpty()) {
                cacAuths.forEach(matchAuth -> {
                    GoodsAuthDO goodsAuthDO = new GoodsAuthDO(copyAppAuthVO);
                    goodsAuthDO.setAppId(matchAuth.getCode());
                    goodsAuthDO.setTenantId(matchAuth.getTenantId());
                    goodsAuthDO.setTenantName(matchAuth.getTenantName());
                    goodsAuthDO.setStrategyCode(matchAuth.getLastStrategyId());
                    goodsAuthDO.setEffectiveDateTime(matchAuth.getEffectiveTime());
                    goodsAuthDO.setExpiredDateTime(matchAuth.getExpiredTime());
                    goodsAuthDO.setUserNumber(String.valueOf(matchAuth.getTotalUsage()));
                    goodsAuthDO.setAction(Integer.valueOf(2));
                    goodsAuthDO.setValidateOldAuth(Boolean.valueOf(true));
                    AuthorizationVO authorizationVO = copyAppAuthVO.getAuthorizations().stream().filter(c -> c.getTenantId().equals(goodsAuthDO.getTenantId()) && c.getId().equals(goodsAuthDO.getAppId())).findFirst().orElse(null);
                    if (authorizationVO != null) {
                        goodsAuthDO.setTenantSid(authorizationVO.getTenantSid());
                        if (authorizationVO.getOldAuthInfo() != null) {
                            goodsAuthDO.setOldAuthInfo(new AuthorizationVO(authorizationVO.getOldAuthInfo()));
                        }
                    }
                    goodsAuthDOList.add(goodsAuthDO);
                });
            }
        }
        this.authorization(goodsAuthDOList);
        return StdData.ok().build();
    }
}

