/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.api.order;

import cn.hutool.core.util.ObjectUtil;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.omc.constant.I18nError;
import com.digiwin.dap.middleware.omc.constant.enums.order.OrderTypeEnum;
import com.digiwin.dap.middleware.omc.domain.request.OrderConditionVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderVO;
import com.digiwin.dap.middleware.omc.domain.response.OrderCountResult;
import com.digiwin.dap.middleware.omc.domain.response.OrderListResult;
import com.digiwin.dap.middleware.omc.domain.response.OrderResult;
import com.digiwin.dap.middleware.omc.mapper.OrderDetailMapper;
import com.digiwin.dap.middleware.omc.mapper.OrderMapper;
import com.digiwin.dap.middleware.omc.service.flow.OrderFlowContextHolder;
import com.digiwin.dap.middleware.omc.service.flow.OrderFlowService;
import com.digiwin.dap.middleware.omc.service.order.OrderQueryService;
import com.digiwin.dap.middleware.omc.service.order.OrderService;
import com.github.pagehelper.Page;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.util.ObjectUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Validated
public class BaseOrderController {
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private OrderService orderService;
    @Autowired
    private OrderQueryService orderQueryService;
    @Autowired
    private OrderDetailMapper orderDetailMapper;
    @Autowired
    private OrderFlowService orderFlowService;

    @PostMapping(value={"/api/sales/submitOrderToCloudGoods", "/api/omc/v2/orders"})
    public ResponseEntity<?> createOrder(@Valid @RequestBody OrderVO orderVO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        orderVO.setTenantSid(Long.valueOf(orderVO.getTenantSid() == null ? authoredUser.getTenantSid() : orderVO.getTenantSid().longValue()));
        orderVO.setUserSid(Long.valueOf(orderVO.getUserSid() == null ? authoredUser.getSid() : orderVO.getUserSid().longValue()));
        this.orderService.priceSecurityCheck4Normal(orderVO);
        if (orderVO.getBnpl() != null && ObjectUtil.equal((Object)OrderTypeEnum.APP_NEW.getValue(), (Object)orderVO.getOrderType()) && ObjectUtils.isEmpty((Object)orderVO.getCredentialFileId())) {
            throw new BusinessException((ErrorHandler)I18nError.OMC_ORDER_CREATE_BNPL_NULL);
        }
        this.orderFlowService.submitBaseOrder(orderVO);
        return ResponseEntity.ok((Object)OrderFlowContextHolder.getContext());
    }

    @PostMapping(value={"/api/omc/v2/orders/inner"})
    public ResponseEntity<?> createOrderInner(@Valid @RequestBody OrderVO orderVO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        orderVO.setTenantSid(Long.valueOf(orderVO.getTenantSid() == null ? authoredUser.getTenantSid() : orderVO.getTenantSid().longValue()));
        orderVO.setUserSid(Long.valueOf(orderVO.getUserSid() == null ? authoredUser.getSid() : orderVO.getUserSid().longValue()));
        String digiwinTenantId = "99990000";
        if (authoredUser == null || !digiwinTenantId.equals(authoredUser.getTenantId())) {
            throw new BusinessException((ErrorHandler)I18nError.ORDER_PRICE_SECURITY_CHECK_ERROR, "\u79df\u6237\u9650\u5236");
        }
        this.orderFlowService.submitBaseOrder(orderVO);
        return ResponseEntity.ok((Object)OrderFlowContextHolder.getContext());
    }

    @GetMapping(value={"/api/sales/orderByCode", "/api/omc/v2/orders/code"})
    public ResponseEntity<?> getOrderByOrderCode(@RequestParam(name="orderCode") String orderCode) {
        OrderVO order = this.orderQueryService.getOrderByOrderCode(orderCode);
        return ResponseEntity.ok((Object)new OrderResult("200", order));
    }

    @GetMapping(value={"/api/sales/ordersList", "/api/omc/v2/orders/tenant"})
    public ResponseEntity<?> getOrdersByTenantId(@RequestParam(value="userId") String tenantId, @RequestParam(value="include", defaultValue="0") Integer include, @RequestParam(name="params", required=false) String params, @NotNull @RequestParam(value="pageIndex") Integer pageNum, @NotNull @RequestParam(value="size") Integer pageSize, @RequestParam(name="orderBy", defaultValue="create_date desc") String orderBy) {
        OrderConditionVO orderCondition = OrderConditionVO.getSelf((String)params);
        orderCondition.setTenantIdEq(tenantId);
        orderCondition.setInclude(include);
        List orders = this.orderQueryService.getTenantOrders(orderCondition, pageNum.intValue(), pageSize.intValue(), orderBy);
        return ResponseEntity.ok((Object)(orders instanceof Page ? new OrderListResult("200", orders, ((Page)orders).getTotal()) : new OrderListResult("200", orders)));
    }

    @GetMapping(value={"/api/sales/ordersList/userId", "/api/omc/v2/orders/tenant/user"})
    public ResponseEntity<?> getOrdersByUserId(@RequestParam(value="include", defaultValue="0") Integer include, @RequestParam(name="params", required=false) String params, @NotNull @RequestParam(value="pageIndex") Integer pageNum, @NotNull @RequestParam(value="size") Integer pageSize, @RequestParam(name="orderBy", defaultValue="create_date desc") String orderBy, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        OrderConditionVO orderCondition = OrderConditionVO.getSelf((String)params);
        orderCondition.setTenantIdEq(authoredUser.getTenantId());
        orderCondition.setUserId(authoredUser.getUserId());
        orderCondition.setInclude(include);
        List orders = this.orderQueryService.getTenantOrders(orderCondition, pageNum.intValue(), pageSize.intValue(), orderBy);
        return ResponseEntity.ok((Object)(orders instanceof Page ? new OrderListResult("200", orders, ((Page)orders).getTotal()) : new OrderListResult("200", orders)));
    }

    @PostMapping(value={"/api/sales/orderCount/{tenantId:.+}/{strategySid}", "/api/omc/v2/orders/count/{tenantId:.+}/{strategySid}"})
    public ResponseEntity<?> getOrderGoodsCount(@PathVariable(name="tenantId") String tenantId, @PathVariable(name="strategySid") Long strategySid) {
        int quantity = this.orderMapper.findQuantityByTenantIdAndStrategySid(tenantId, strategySid.longValue());
        return ResponseEntity.ok((Object)new OrderCountResult(strategySid, Integer.valueOf(quantity)));
    }

    @GetMapping(value={"/api/omc/v2/orders/{orderSid}/promotion"})
    public StdData getPromotionMix(@PathVariable Long orderSid) {
        return StdData.ok((Object)this.orderDetailMapper.findOrderPromotionMix(orderSid.longValue()));
    }
}

