/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.api.order;

import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.omc.domain.CartOrderVO;
import com.digiwin.dap.middleware.omc.service.flow.OrderFlowContextHolder;
import com.digiwin.dap.middleware.omc.service.flow.OrderFlowService;
import com.digiwin.dap.middleware.omc.service.order.OrderQueryService;
import com.digiwin.dap.middleware.omc.service.order.OrderService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Validated
public class CartOrderController {
    @Autowired
    private OrderService orderService;
    @Autowired
    private OrderQueryService orderQueryService;
    @Autowired
    private OrderFlowService orderFlowService;

    @PostMapping(value={"/api/omc/v2/orders/cart"})
    public ResponseEntity<?> createOrder(@Validated @RequestBody CartOrderVO body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        this.orderService.priceSecurityCheck4Cart(body);
        this.orderFlowService.submitCartOrder(body);
        return ResponseEntity.ok((Object)OrderFlowContextHolder.getContext().getData());
    }

    @GetMapping(value={"/api/omc/v2/orders/cart/{payCode}/{shopping}"})
    public ResponseEntity<?> getCartOrder(@PathVariable String payCode, @PathVariable Boolean shopping) {
        String code = payCode.split("_")[0];
        if (shopping.booleanValue()) {
            return ResponseEntity.ok((Object)StdData.ok((Object)this.orderQueryService.getCartOrders(code, Boolean.TRUE.booleanValue())));
        }
        return ResponseEntity.ok((Object)StdData.ok((Object)this.orderQueryService.getOrderByOrderCode(code)));
    }
}

