/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.api.order;

import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.omc.domain.DealerOrderVO;
import com.digiwin.dap.middleware.omc.domain.ImportExcelResultVO;
import com.digiwin.dap.middleware.omc.mapper.GoodsMapper;
import com.digiwin.dap.middleware.omc.service.business.DevSysAuthorizationService;
import com.digiwin.dap.middleware.omc.service.dealer.DealerOrderAuthorService;
import com.digiwin.dap.middleware.omc.service.dealer.DealerOrderService;
import com.digiwin.dap.middleware.omc.service.order.OrderOtherService;
import com.digiwin.dap.middleware.omc.support.remote.IamService;
import com.digiwin.dap.middleware.util.UserUtils;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Validated
public class DealerOrderController {
    @Autowired
    private IamService iamService;
    @Autowired
    private GoodsMapper goodsMapper;
    @Autowired
    private OrderOtherService orderOtherService;
    @Autowired
    private DealerOrderService dealerOrderService;
    @Autowired
    private DealerOrderAuthorService dealerOrderAuthorService;
    @Autowired
    private DevSysAuthorizationService devSysAuthorizationService;

    @PostMapping(value={"/api/omc/v2/orders/dealer"})
    public ResponseEntity<?> createOrder(@Validated @RequestBody DealerOrderVO body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        if (body.getAuthCode().startsWith("dev-")) {
            Long preOrderSid = this.devSysAuthorizationService.createPreOrder(body.getAuthCode(), authoredUser);
            return ResponseEntity.ok((Object)StdData.ok((Object)preOrderSid));
        }
        StdData stdData = this.dealerOrderAuthorService.paramCheck(body);
        if (!stdData.getSuccess().booleanValue()) {
            return ResponseEntity.ok((Object)stdData);
        }
        List orderSids = this.dealerOrderService.createOrder(body);
        this.orderOtherService.afterOrderPaid(orderSids, UserUtils.getToken(), body);
        return ResponseEntity.ok((Object)StdData.ok((Object)orderSids));
    }

    @PostMapping(value={"/api/omc/v2/orders/dealer/{fileId}"})
    public StdData<?> createBatchOrders(@PathVariable(name="fileId") String fileId, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        ImportExcelResultVO importExcelResultVO = this.dealerOrderAuthorService.batchDealerAuthor(fileId);
        return StdData.ok((Object)importExcelResultVO);
    }
}

