/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.api.order;

import com.digiwin.dap.middleware.cache.RedisUtils;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.omc.constant.I18nError;
import com.digiwin.dap.middleware.omc.dao.OrderCrudService;
import com.digiwin.dap.middleware.omc.domain.request.OfflineVO;
import com.digiwin.dap.middleware.omc.domain.request.OrderVO;
import com.digiwin.dap.middleware.omc.entity.Order;
import com.digiwin.dap.middleware.omc.service.flow.OrderFlowContextHolder;
import com.digiwin.dap.middleware.omc.service.flow.OrderFlowService;
import com.digiwin.dap.middleware.omc.service.flow.OrderFlowVO;
import com.digiwin.dap.middleware.omc.service.order.OrderQueryService;
import com.digiwin.dap.middleware.omc.service.order.OrderService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Validated
public class OrderCheckController {
    private static final Logger logger = LoggerFactory.getLogger(OrderCheckController.class);
    @Autowired
    private OrderService orderService;
    @Autowired
    private OrderQueryService orderQueryService;
    @Autowired
    private OrderFlowService orderFlowService;
    @Autowired
    private OrderCrudService orderCrudService;

    @GetMapping(value={"/api/sales/checkOrderIsPayToCloudGoods", "/api/omc/v2/orders/check"})
    public ResponseEntity<?> checkOrder(@RequestParam(name="orderCode") String orderCode) {
        OrderVO orderVO = this.orderQueryService.getOrderByOrderCode(orderCode.split("_")[0]);
        if (0 == orderVO.getShopping()) {
            this.orderFlowService.checkBaseOrder(orderVO);
        } else if (1 == orderVO.getShopping()) {
            this.orderFlowService.checkCartOrder(orderVO.getSid().longValue(), orderVO.getCartCode());
            OrderFlowVO context = OrderFlowContextHolder.getContext();
            StdData data = (StdData)context.getData();
            context.setData((Object)(data.getSuccess() != false ? "True" : "False"));
            context.setErrMsg(data.getMessage());
        }
        return ResponseEntity.ok((Object)OrderFlowContextHolder.getContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(value={"/api/omc/v2/orders/check/{orderCode}/checkorderispaysucceed"})
    public ResponseEntity<?> checkOrder2(@PathVariable(name="orderCode") String orderCode) {
        boolean flag = false;
        try {
            boolean lock = RedisUtils.lock((String)orderCode, (String)String.valueOf(System.currentTimeMillis()));
            if (lock) {
                flag = this.orderService.checkOrderPaid(orderCode);
            }
        }
        catch (Exception e) {
            logger.error("\u8ba2\u5355\u652f\u4ed8\u6210\u529f\u68c0\u67e5\u5f02\u5e38", (Throwable)e);
        }
        finally {
            RedisUtils.unlock((String)orderCode);
        }
        return ResponseEntity.ok((Object)flag);
    }

    @PostMapping(value={"/api/omc/v2/orders/{orderSid}/offline"})
    public ResponseEntity<?> checkOfflineOrder(@PathVariable(name="orderSid") Long orderSid, @RequestBody(required=false) OfflineVO offlineVO) {
        OrderVO orderVO = this.orderQueryService.getOrderBySid(orderSid.longValue());
        if (0 == orderVO.getShopping()) {
            this.orderFlowService.checkOfflineBaseOrder(orderVO, offlineVO);
        } else if (1 == orderVO.getShopping()) {
            this.orderFlowService.checkOfflineCartOrder(orderVO.getSid().longValue(), orderVO.getCartCode(), offlineVO);
        }
        return ResponseEntity.ok((Object)OrderFlowContextHolder.getContext());
    }

    @PostMapping(value={"/api/omc/v2/orders/cart/check/{cartSid}"})
    public ResponseEntity<?> checkCartOrder(@PathVariable Long cartSid) {
        Order order = (Order)this.orderCrudService.findBySid(cartSid.longValue());
        if (null == order || order.getOrderStatus() == 1) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_10007, new Object[]{cartSid});
        }
        this.orderFlowService.checkCartOrder(order.getSid(), order.getCartCode());
        return ResponseEntity.ok((Object)OrderFlowContextHolder.getContext().getData());
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/api/omc/v2/orders/cart/{cartCode}/offline"})
    public ResponseEntity<?> checkOfflineCartOrder(@PathVariable(name="cartCode") String cartCode, @RequestBody(required=false) OfflineVO offlineVO) {
        Order order = this.orderCrudService.findByOutTradeNo(cartCode);
        if (null == order || order.getOrderStatus() == 1) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_10007, new Object[]{cartCode});
        }
        this.orderFlowService.checkOfflineCartOrder(order.getSid(), order.getCartCode(), offlineVO);
        return ResponseEntity.ok((Object)StdData.ok().build());
    }
}

