/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.api.order;

import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.omc.constant.I18nError;
import com.digiwin.dap.middleware.omc.constant.enums.order.PayTypeEnum;
import com.digiwin.dap.middleware.omc.domain.PackOrderVO;
import com.digiwin.dap.middleware.omc.domain.request.PackOrderCountRequest;
import com.digiwin.dap.middleware.omc.mapper.OrderMapper;
import com.digiwin.dap.middleware.omc.service.flow.OrderFlowContextHolder;
import com.digiwin.dap.middleware.omc.service.flow.OrderFlowService;
import com.digiwin.dap.middleware.omc.service.order.OrderService;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.util.ObjectUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Validated
public class PackOrderController {
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private OrderService orderService;
    @Autowired
    private OrderFlowService orderFlowService;

    @PostMapping(value={"/api/omc/v2/orders/pack"})
    public ResponseEntity<?> createOrder(@Validated @RequestBody PackOrderVO body, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        this.orderService.priceSecurityCheck4Pack(body);
        if (Objects.equals(PayTypeEnum.BNPL.getCode(), body.getPayType()) && ObjectUtils.isEmpty((Object)body.getCredentialFileId())) {
            throw new BusinessException((ErrorHandler)I18nError.OMC_ORDER_CREATE_BNPL_NULL);
        }
        this.orderFlowService.submitPackOrder(body);
        return ResponseEntity.ok((Object)OrderFlowContextHolder.getContext().getData());
    }

    @PostMapping(value={"/api/omc/v2/orders/pack/count"})
    public StdData<?> getPackOrderCount(@RequestBody PackOrderCountRequest req) {
        return StdData.ok((Object)this.orderMapper.findQuantityByTenantIdAndPackSid(req.getTenantId(), req.getPackSid()));
    }
}

