/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.constant.enums;

import java.util.Arrays;
import java.util.List;

public enum GoodsCategoryEnum {
    APP,
    SERVICE,
    COURSE,
    PACKAGE,
    PLATFORM,
    DEVICE,
    BUNDLE,
    API,
    RESOURCE,
    PACK;


    public static boolean needInit(String categoryId) {
        return APP.name().equalsIgnoreCase(categoryId) || PLATFORM.name().equalsIgnoreCase(categoryId);
    }

    public static boolean isApp(String categoryId) {
        return APP.name().equalsIgnoreCase(categoryId) || PLATFORM.name().equalsIgnoreCase(categoryId) || BUNDLE.name().equalsIgnoreCase(categoryId) || API.name().equalsIgnoreCase(categoryId) || RESOURCE.name().equalsIgnoreCase(categoryId);
    }

    public static boolean isAppCountOrNoControl(String categoryId, Integer paymentType) {
        return APP.name().equalsIgnoreCase(categoryId) && (Integer.valueOf(0).equals(paymentType) || Integer.valueOf(3).equals(paymentType));
    }

    public static List<String> mainStrategies() {
        return Arrays.asList(APP.name().toLowerCase(), PLATFORM.name().toLowerCase(), DEVICE.name().toLowerCase(), API.name().toLowerCase(), BUNDLE.name().toLowerCase(), PACK.name().toLowerCase(), RESOURCE.name().toLowerCase());
    }

    public static boolean isService(String categoryId) {
        return SERVICE.name().equalsIgnoreCase(categoryId);
    }

    public static boolean isDevice(String categoryId) {
        return DEVICE.name().equalsIgnoreCase(categoryId);
    }

    public static boolean includeInCalculationOfPackExpireTime(String categoryId) {
        return APP.name().equalsIgnoreCase(categoryId) || DEVICE.name().equalsIgnoreCase(categoryId);
    }
}

