/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.dao.impl;

import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.omc.dao.InvoiceCrudService;
import com.digiwin.dap.middleware.omc.domain.request.InvoiceVO;
import com.digiwin.dap.middleware.omc.entity.Invoice;
import com.digiwin.dap.middleware.omc.entity.Order;
import com.digiwin.dap.middleware.omc.mapper.InvoiceMapper;
import com.digiwin.dap.middleware.omc.repository.InvoiceRepository;
import com.digiwin.dap.middleware.omc.repository.OrderRepository;
import com.digiwin.dap.middleware.repository.BaseEntityRepository;
import com.digiwin.dap.middleware.service.impl.BaseEntityManagerService;
import com.digiwin.dap.middleware.util.EntityUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InvoiceCrudServiceImpl
extends BaseEntityManagerService<Invoice>
implements InvoiceCrudService {
    @Autowired
    private InvoiceRepository invoiceRepository;
    @Autowired
    private InvoiceMapper invoiceMapper;
    @Autowired
    private OrderRepository orderRepository;

    protected BaseEntityRepository getRepository() {
        return this.invoiceRepository;
    }

    public Invoice findByOrderSid(long orderSid) {
        List invoices = this.invoiceRepository.findByOrderSid(orderSid);
        Optional<Invoice> optional = invoices.stream().max(Comparator.comparingLong(BaseEntity::getSid));
        return optional.orElse(null);
    }

    public void saveShoppingInvoice(String cartCode, InvoiceVO invoiceVO) {
        this.invoiceMapper.deleteByCartCode(cartCode);
        ArrayList invoices = new ArrayList();
        List orders = this.orderRepository.findByCartCode(cartCode);
        orders.forEach(o -> {
            Invoice invoice = (Invoice)invoiceVO.doForward();
            invoice.setOrderSid(Long.valueOf(o.getSid()));
            invoice.setAmount(o.getPayPrice());
            invoice.setTax(o.getTaxPrice());
            EntityUtils.setCreateFields((BaseEntity)invoice);
            invoices.add(invoice);
        });
        this.saveAll(invoices);
    }

    public void saveOrderInvoice(InvoiceVO invoiceVO, Order order) {
        Invoice invoice = (Invoice)invoiceVO.doForward();
        Long invoiceSid = this.invoiceRepository.findSidByOrderSid(order.getSid());
        if (invoiceSid == null) {
            invoice.setOrderSid(Long.valueOf(order.getSid()));
            invoice.setAmount(order.getPayPrice());
            invoice.setTax(order.getTaxPrice());
            this.create((BaseEntity)invoice);
        } else {
            invoice.setSid(invoiceSid.longValue());
            invoice.setOrderSid(Long.valueOf(order.getSid()));
            this.update((BaseEntity)invoice);
        }
    }
}

