/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.dao.impl;

import com.digiwin.dap.middleware.omc.dao.OrderCrudService;
import com.digiwin.dap.middleware.omc.entity.Order;
import com.digiwin.dap.middleware.omc.mapper.CodeMapper;
import com.digiwin.dap.middleware.omc.repository.OrderRepository;
import com.digiwin.dap.middleware.omc.support.cache.RedisService;
import com.digiwin.dap.middleware.omc.util.CodeUtil;
import com.digiwin.dap.middleware.service.impl.BaseEntityManagerService;
import java.util.List;
import java.util.Locale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrderCrudServiceImpl
extends BaseEntityManagerService<Order>
implements OrderCrudService {
    @Autowired
    private CodeMapper codeMapper;
    @Autowired
    private RedisService redisService;
    @Autowired
    private OrderRepository orderRepository;

    protected OrderRepository getRepository() {
        return this.orderRepository;
    }

    public long getSidByOrderCode(String orderCode) {
        return this.getRepository().getSidByOrderCode(orderCode);
    }

    public Order findByOrderCode(String orderCode) {
        return this.getRepository().findByOrderCode(orderCode);
    }

    public void deleteByOrderCode(String orderCode) {
        this.getRepository().deleteByOrderCode(orderCode);
    }

    public boolean existsByOrderCode(String orderCode) {
        return this.getRepository().existsByOrderCode(orderCode);
    }

    public long getSidByOutTradeNo(String outTradeNo) {
        String code = outTradeNo.split("_")[0];
        if (outTradeNo.contains("CART")) {
            return this.getRepository().getCartSidByOrderCode(code);
        }
        return this.getRepository().getSidByOrderCode(code);
    }

    public Order findByOutTradeNo(String outTradeNo) {
        String code = outTradeNo.split("_")[0];
        if (outTradeNo.contains("CART") || outTradeNo.contains("MATC")) {
            return this.getRepository().findByCartCodeAndShopping(code, 1);
        }
        return this.getRepository().findByOrderCode(code);
    }

    public String generateOrderCode(String country) {
        if (Locale.TRADITIONAL_CHINESE.getCountry().equalsIgnoreCase(country)) {
            return this.generateCode("T");
        }
        return this.generateCode("C");
    }

    public String generateCartOrderCode(String country) {
        if (Locale.TRADITIONAL_CHINESE.getCountry().equalsIgnoreCase(country)) {
            return this.generateCartCode("CARTT");
        }
        return this.generateCartCode("CARTC");
    }

    public String generateDealOrderCode(String country) {
        if (Locale.TRADITIONAL_CHINESE.getCountry().equalsIgnoreCase(country)) {
            return this.generateCartCode("DEALT");
        }
        return this.generateCartCode("DEALC");
    }

    public String generatePackOrderCode(String country) {
        if (Locale.TRADITIONAL_CHINESE.getCountry().equalsIgnoreCase(country)) {
            return this.generateCartCode("MIXT");
        }
        return this.generateCartCode("MIXC");
    }

    public String generateOrderCode(String country, String AliCode, String AzureCode) {
        if (Locale.TRADITIONAL_CHINESE.getCountry().equalsIgnoreCase(country)) {
            return this.generateCartCode(AzureCode);
        }
        return this.generateCartCode(AliCode);
    }

    public String generateServiceOrderCode(String country) {
        if (Locale.TRADITIONAL_CHINESE.getCountry().equalsIgnoreCase(country)) {
            return this.generateCartCode("ISVT");
        }
        return this.generateCartCode("ISVC");
    }

    public String generateBnplOrderCode() {
        long maxOrderCode;
        String key = CodeUtil.bnplOrderCodePrefix((String)"BNPL");
        long sequence = this.redisService.increment(key, 1L);
        if (sequence == 1L && (maxOrderCode = this.codeMapper.findMaxBnplOrderCode(key)) >= sequence) {
            sequence = this.redisService.increment(key, maxOrderCode);
        }
        return key + String.format("%04d", sequence);
    }

    public List<Order> findBySids(List<Long> sids) {
        return this.orderRepository.findAllById(sids);
    }

    private String generateCode(String prefix) {
        long maxOrderCode;
        String key = CodeUtil.orderCodePrefix((String)prefix);
        long sequence = this.redisService.increment(key, 1L);
        if (sequence == 1L && (maxOrderCode = this.codeMapper.findMaxOrderCode(key)) >= sequence) {
            sequence = this.redisService.increment(key, maxOrderCode);
        }
        return key + String.format("%05d", sequence);
    }

    private String generateCartCode(String prefix) {
        String key = CodeUtil.cartCodePrefix((String)prefix);
        long sequence = this.redisService.incrementMonth(key, 1L);
        if (sequence == 1L) {
            long maxOrderCode = 0L;
            if (prefix.contains("CART")) {
                maxOrderCode = this.codeMapper.findMaxCartCode(key);
            } else if (prefix.contains("DEAL")) {
                maxOrderCode = this.codeMapper.findMaxOrderCode(key);
            } else if (prefix.contains("MIX")) {
                maxOrderCode = this.codeMapper.findMaxPackCode(key);
            } else if (prefix.contains("ISV")) {
                maxOrderCode = this.codeMapper.findMaxOrderCode(key);
            }
            if (maxOrderCode >= sequence) {
                sequence = this.redisService.incrementMonth(key, maxOrderCode);
            }
        }
        return key + String.format("%05d", sequence);
    }
}

