/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.domain;

import com.digiwin.dap.middleware.omc.constant.enums.TossStatusEnum;
import com.digiwin.dap.middleware.omc.domain.request.OrderVO;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.math.BigDecimal;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;

public class CartOrderVO {
    private Long cartSid;
    private String cartCode;
    @Valid
    @NotEmpty
    private List<OrderVO> orders;

    public Long getCartSid() {
        return this.cartSid;
    }

    public void setCartSid(Long cartSid) {
        this.cartSid = cartSid;
    }

    public String getCartCode() {
        return this.cartCode;
    }

    public void setCartCode(String cartCode) {
        this.cartCode = cartCode;
    }

    public List<OrderVO> getOrders() {
        return this.orders;
    }

    public void setOrders(List<OrderVO> orders) {
        this.orders = orders;
    }

    @JsonIgnore
    public OrderVO getCartOrder() {
        OrderVO cartOrder = new OrderVO();
        cartOrder.setShopping(Integer.valueOf(1));
        OrderVO temp = (OrderVO)this.orders.get(0);
        cartOrder.setOrderType(temp.getOrderType());
        cartOrder.setOrderSource(temp.getOrderSource());
        cartOrder.setTenantSid(temp.getTenantSid());
        cartOrder.setTenantId(temp.getTenantId());
        cartOrder.setTenantName(temp.getTenantName());
        cartOrder.setUserId(temp.getUserId());
        cartOrder.setUserName(temp.getUserName());
        cartOrder.setEmail(temp.getEmail());
        cartOrder.setTelephone(temp.getTelephone());
        cartOrder.setEnterprise(temp.getEnterprise());
        cartOrder.setComment(temp.getComment());
        cartOrder.setRemark(temp.getRemark());
        cartOrder.setTestTenant(temp.getTestTenant());
        cartOrder.setTossStatus(TossStatusEnum.Z.name());
        cartOrder.setNoTaxPrice(this.orders.stream().map(OrderVO::getNoTaxPrice).reduce(BigDecimal.ZERO, BigDecimal::add));
        cartOrder.setTaxPrice(this.orders.stream().map(OrderVO::getTaxPrice).reduce(BigDecimal.ZERO, BigDecimal::add));
        cartOrder.setContainTaxPrice(this.orders.stream().map(OrderVO::getContainTaxPrice).reduce(BigDecimal.ZERO, BigDecimal::add));
        cartOrder.setTotalPrice(this.orders.stream().map(OrderVO::getTotalPrice).reduce(BigDecimal.ZERO, BigDecimal::add));
        cartOrder.setPayPrice(this.orders.stream().map(OrderVO::getPayPrice).reduce(BigDecimal.ZERO, BigDecimal::add));
        cartOrder.setDiscountPrice(this.orders.stream().map(OrderVO::getDiscountPrice).reduce(BigDecimal.ZERO, BigDecimal::add));
        return cartOrder;
    }
}

