/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.domain;

import com.digiwin.dap.middleware.omc.domain.CustomAttributeVO;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DeviceAttributeVO {
    private String kind;
    private String area;
    private String core;
    private String memory;
    private String cloud;

    public static DeviceAttributeVO parseDeviceAttributes(String attributeStr) {
        DeviceAttributeVO result = new DeviceAttributeVO();
        try {
            PropertyDescriptor[] propertyDescriptors;
            List customAttributeVOS = (List)JsonUtils.createObjectMapper().readValue(attributeStr, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            Map<String, CustomAttributeVO> attributesMap = customAttributeVOS.stream().collect(Collectors.toMap(CustomAttributeVO::getId, a -> a, (k1, k2) -> k1));
            BeanInfo beanInfo = Introspector.getBeanInfo(DeviceAttributeVO.class);
            for (PropertyDescriptor propertyDescriptor : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                String name = propertyDescriptor.getName();
                CustomAttributeVO customAttributeVO = attributesMap.get(name);
                if (customAttributeVO == null) continue;
                propertyDescriptor.getWriteMethod().invoke((Object)result, customAttributeVO.getValue());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public String getArea() {
        return this.area;
    }

    public void setArea(String area) {
        this.area = area;
    }

    public String getCore() {
        return this.core;
    }

    public void setCore(String core) {
        this.core = core;
    }

    public String getMemory() {
        return this.memory;
    }

    public void setMemory(String memory) {
        this.memory = memory;
    }

    public String getCloud() {
        return this.cloud;
    }

    public void setCloud(String cloud) {
        this.cloud = cloud;
    }
}

