/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.domain.excel;

import com.alibaba.excel.annotation.ExcelProperty;
import com.digiwin.dap.middleware.omc.constant.enums.CloudDeviceStateEnum;
import com.digiwin.dap.middleware.omc.domain.request.OrderCloudDeviceVO;
import com.digiwin.dap.middleware.omc.util.DateUtil;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.BeanUtils;

public class CloudDeviceExcelVO2 {
    @ExcelProperty(value={"\u4e91"})
    private String cloud;
    @ExcelProperty(value={"\u4f7f\u7528\u73af\u5883"})
    private String area;
    @ExcelProperty(value={"\u7c7b\u522b"})
    private String kind;
    @ExcelProperty(value={"\u79df\u6237ID"})
    private String tenantId;
    @ExcelProperty(value={"\u79df\u6237\u540d\u79f0"})
    private String tenantName;
    @ExcelProperty(value={"\u578b\u6001\u7ec4ID"})
    private String typeGroupId;
    @ExcelProperty(value={"\u578b\u6001\u7ec4\u540d\u79f0"})
    private String typeGroupName;
    @ExcelProperty(value={"\u578b\u6001ID"})
    private String typeId;
    @ExcelProperty(value={"\u578b\u6001\u540d\u79f0"})
    private String typeName;
    @ExcelProperty(value={"\u6d4b\u8bd5\u79df\u6237"})
    private String testTenant;
    @ExcelProperty(value={"\u8d2d\u4e70\u65b9\u5f0f"})
    private String purchaseMethod;
    @ExcelProperty(value={"tag"})
    private String tag;
    @ExcelProperty(value={"\u6570\u636e\u5e93url"})
    private String dbUrl;
    @ExcelProperty(value={"\u5f00\u7acb\u72b6\u6001"})
    private String status;
    @ExcelProperty(value={"\u8d44\u6e90\u8d39\u7528\u5f52\u5c5e\u90e8\u95e8ID"})
    private String costDeptId;
    @ExcelProperty(value={"\u8d44\u6e90\u8d39\u7528\u5f52\u5c5e\u90e8\u95e8\u540d\u79f0"})
    private String costDeptName;
    @ExcelProperty(value={"\u8d44\u6e90\u8d39\u7528\u63a5\u53e3\u4ebaID"})
    private String costEmpId;
    @ExcelProperty(value={"\u8d44\u6e90\u8d39\u7528\u63a5\u53e3\u4eba\u540d\u79f0"})
    private String costEmpName;
    @ExcelProperty(value={"\u7533\u8bf7\u4eba"})
    private String applicantName;
    @ExcelProperty(value={"\u7533\u8bf7\u65e5\u671f"})
    private String applicantDate;
    @ExcelProperty(value={"\u4e91\u8d44\u6e90sid"})
    private String sid;
    @ExcelProperty(value={"\u8d44\u6e90\u7f16\u53f7"})
    private String code;
    @ExcelProperty(value={"\u8d44\u6e90\u5546\u54c1ID"})
    private String goodsCode;
    @ExcelProperty(value={"\u8d44\u6e90\u5546\u54c1\u540d\u79f0"})
    private String goodsName;
    @ExcelProperty(value={"\u6388\u6743\u8d77"})
    private String effectiveTime;
    @ExcelProperty(value={"\u6388\u6743\u8bab"})
    private String expiredTime;
    @ExcelProperty(value={"\u5b9e\u4f8b\u7f16\u53f7"})
    private String caseNumber;
    @ExcelProperty(value={"\u4e91\u8d44\u6e90\u89c4\u683c"})
    private String cloudResourceSpecification;
    @ExcelProperty(value={"\u4e91\u8d44\u6e90\u5b9e\u9645\u89c4\u683c"})
    private String actualSpec;
    @ExcelProperty(value={"\u6570\u636e\u5e93\u7ba1\u7406\u5458\u8d26\u53f7"})
    private String dbAdmin;
    @ExcelProperty(value={"db\u5ba1\u6838\u5e73\u53f0 url"})
    private String archeryUrl;
    @ExcelProperty(value={"db\u5ba1\u6838\u5e73\u53f0\u8d26\u53f7"})
    private String archeryId;
    @ExcelProperty(value={"\u7528\u6237\u9700\u77e5\u5907\u6ce8"})
    private String remark;
    @ExcelProperty(value={"\u5185\u90e8\u4f7f\u7528\u8bf4\u660e\u5907\u6ce8"})
    private String description;
    private static final Map<Integer, String> PURCHASE_METHOD_MAP;

    public static CloudDeviceExcelVO2 generate(OrderCloudDeviceVO vo) {
        CloudDeviceExcelVO2 excelVO = new CloudDeviceExcelVO2();
        BeanUtils.copyProperties((Object)vo, (Object)excelVO);
        excelVO.setSid(vo.getSid().toString());
        excelVO.setEffectiveTime(DateUtil.getDateStr((LocalDateTime)vo.getStartDate()));
        excelVO.setExpiredTime(DateUtil.getDateStr((LocalDateTime)vo.getExpireDate()));
        excelVO.setStatus(CloudDeviceStateEnum.getName((Integer)vo.getState()));
        excelVO.setApplicantDate(DateUtil.getDateStr((LocalDateTime)vo.getApplicantDate()));
        excelVO.setCloudResourceSpecification(Optional.ofNullable(vo.getCore()).map(core -> core + "C").orElse("") + Optional.ofNullable(vo.getMemory()).map(memory -> memory + "G").orElse(""));
        excelVO.setActualSpec(Optional.ofNullable(vo.getActualCore()).map(actualCore -> actualCore + "C").orElse("") + Optional.ofNullable(vo.getActualMemory()).map(actualMemory -> actualMemory + "G").orElse(""));
        excelVO.setPurchaseMethod(PURCHASE_METHOD_MAP.getOrDefault(vo.getResAcquireMode(), ""));
        excelVO.setTypeGroupId(vo.getGroupId());
        excelVO.setTypeGroupName(vo.getGroupName());
        excelVO.setTypeId(vo.getFormId());
        excelVO.setTypeName(vo.getFormName());
        excelVO.setTestTenant(Boolean.TRUE.equals(vo.getTestTenant()) ? "\u662f" : "\u5426");
        return excelVO;
    }

    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public String getTenantName() {
        return this.tenantName;
    }

    public void setTenantName(String tenantName) {
        this.tenantName = tenantName;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getSid() {
        return this.sid;
    }

    public void setSid(String sid) {
        this.sid = sid;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getGoodsName() {
        return this.goodsName;
    }

    public void setGoodsName(String goodsName) {
        this.goodsName = goodsName;
    }

    public String getGoodsCode() {
        return this.goodsCode;
    }

    public void setGoodsCode(String goodsCode) {
        this.goodsCode = goodsCode;
    }

    public String getCloud() {
        return this.cloud;
    }

    public void setCloud(String cloud) {
        this.cloud = cloud;
    }

    public String getArea() {
        return this.area;
    }

    public void setArea(String area) {
        this.area = area;
    }

    public String getEffectiveTime() {
        return this.effectiveTime;
    }

    public void setEffectiveTime(String effectiveTime) {
        this.effectiveTime = effectiveTime;
    }

    public String getExpiredTime() {
        return this.expiredTime;
    }

    public void setExpiredTime(String expiredTime) {
        this.expiredTime = expiredTime;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getCaseNumber() {
        return this.caseNumber;
    }

    public void setCaseNumber(String caseNumber) {
        this.caseNumber = caseNumber;
    }

    public String getCloudResourceSpecification() {
        return this.cloudResourceSpecification;
    }

    public void setCloudResourceSpecification(String cloudResourceSpecification) {
        this.cloudResourceSpecification = cloudResourceSpecification;
    }

    public String getActualSpec() {
        return this.actualSpec;
    }

    public void setActualSpec(String actualSpec) {
        this.actualSpec = actualSpec;
    }

    public String getDbAdmin() {
        return this.dbAdmin;
    }

    public void setDbAdmin(String dbAdmin) {
        this.dbAdmin = dbAdmin;
    }

    public String getDbUrl() {
        return this.dbUrl;
    }

    public void setDbUrl(String dbUrl) {
        this.dbUrl = dbUrl;
    }

    public String getArcheryUrl() {
        return this.archeryUrl;
    }

    public void setArcheryUrl(String archeryUrl) {
        this.archeryUrl = archeryUrl;
    }

    public String getArcheryId() {
        return this.archeryId;
    }

    public void setArcheryId(String archeryId) {
        this.archeryId = archeryId;
    }

    public String getCostDeptId() {
        return this.costDeptId;
    }

    public void setCostDeptId(String costDeptId) {
        this.costDeptId = costDeptId;
    }

    public String getCostDeptName() {
        return this.costDeptName;
    }

    public void setCostDeptName(String costDeptName) {
        this.costDeptName = costDeptName;
    }

    public String getCostEmpId() {
        return this.costEmpId;
    }

    public void setCostEmpId(String costEmpId) {
        this.costEmpId = costEmpId;
    }

    public String getCostEmpName() {
        return this.costEmpName;
    }

    public void setCostEmpName(String costEmpName) {
        this.costEmpName = costEmpName;
    }

    public String getApplicantName() {
        return this.applicantName;
    }

    public void setApplicantName(String applicantName) {
        this.applicantName = applicantName;
    }

    public String getApplicantDate() {
        return this.applicantDate;
    }

    public void setApplicantDate(String applicantDate) {
        this.applicantDate = applicantDate;
    }

    public String getTypeGroupId() {
        return this.typeGroupId;
    }

    public void setTypeGroupId(String typeGroupId) {
        this.typeGroupId = typeGroupId;
    }

    public String getTypeGroupName() {
        return this.typeGroupName;
    }

    public void setTypeGroupName(String typeGroupName) {
        this.typeGroupName = typeGroupName;
    }

    public String getTypeId() {
        return this.typeId;
    }

    public void setTypeId(String typeId) {
        this.typeId = typeId;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public String getTestTenant() {
        return this.testTenant;
    }

    public void setTestTenant(String testTenant) {
        this.testTenant = testTenant;
    }

    public String getPurchaseMethod() {
        return this.purchaseMethod;
    }

    public void setPurchaseMethod(String purchaseMethod) {
        this.purchaseMethod = purchaseMethod;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    static {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(1, "\u5f00\u53d1\u8ba2\u9605");
        map.put(2, "\u8fd0\u7ef4\u7533\u8bf7");
        PURCHASE_METHOD_MAP = Collections.unmodifiableMap(map);
    }
}

