/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.domain.excel;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.TemporalUtil;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.alibaba.excel.annotation.write.style.ContentStyle;
import com.digiwin.dap.middleware.omc.constant.enums.order.OrderStatusEnum;
import com.digiwin.dap.middleware.omc.domain.request.OrderVO;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.temporal.Temporal;
import java.util.Objects;
import java.util.Optional;

public class OMBillDetailExcelVO {
    @ColumnWidth(value=20)
    @ExcelProperty(value={"\u8ba2\u5355\u7f16\u53f7"}, index=0)
    private String orderCode;
    @ExcelProperty(value={"\u8d26\u671f"}, index=1)
    private String billingPeriod;
    @ColumnWidth(value=20)
    @ExcelProperty(value={"\u79df\u6237ID"}, index=2)
    private String tenantId;
    @ExcelProperty(value={"\u79df\u6237\u540d\u79f0"}, index=3)
    @ColumnWidth(value=20)
    private String tenantName;
    @ExcelProperty(value={"\u56e2\u961f\u7c7b\u578b"}, index=4)
    private String teamName;
    @ExcelProperty(value={"\u4ea7\u54c1\u7c7b\u578b"}, index=5)
    private String categoryName;
    @ColumnWidth(value=20)
    @ExcelProperty(value={"\u4ea7\u54c1ID"}, index=6)
    private String productId;
    @ColumnWidth(value=20)
    @ExcelProperty(value={"\u4ea7\u54c1\u540d\u79f0"}, index=7)
    private String productName;
    @ExcelProperty(value={"\u603b\u91d1\u989d"}, index=8)
    @ContentStyle(dataFormat=4)
    private BigDecimal totalPrice;
    @ExcelProperty(value={"\u5b9e\u9645\u652f\u4ed8\u91d1\u989d"}, index=9)
    @ContentStyle(dataFormat=4)
    private BigDecimal payPrice;
    @ExcelProperty(value={"\u8d85\u671f\u5929\u6570"}, index=10)
    private long overDueDays;
    @ExcelProperty(value={"\u652f\u4ed8\u65e5\u671f"}, index=11)
    private String payDate;
    @ExcelProperty(value={"\u8ba2\u5355\u8bf4\u660e"}, index=12)
    @ColumnWidth(value=20)
    private String remark;
    @ExcelProperty(value={"\u8ba2\u5355\u5907\u6ce8"}, index=13)
    @ColumnWidth(value=20)
    private String comment;

    public OMBillDetailExcelVO(OrderVO a) {
        this.orderCode = a.getOrderCode();
        this.billingPeriod = DateUtil.format((LocalDateTime)a.getCreateDate(), (String)"yyyy-MM");
        this.tenantId = a.getTenantId();
        this.tenantName = a.getTenantName();
        this.teamName = a.getTeamName();
        this.categoryName = a.getCategoryName();
        a.getOrderDetails().stream().findFirst().ifPresent(detail -> {
            this.productId = detail.getGoodsCode();
            this.productName = detail.getGoodsName();
        });
        this.totalPrice = a.getTotalPrice();
        this.payPrice = Objects.equals(a.getOrderStatus(), OrderStatusEnum.Unpaid.getValue()) || Objects.equals(a.getOrderStatus(), OrderStatusEnum.WaitPay.getValue()) ? BigDecimal.ZERO : a.getPayPrice();
        this.overDueDays = TemporalUtil.between((Temporal)a.getCreateDate(), (Temporal)LocalDateTime.now()).toDays();
        Optional.ofNullable(a.getPayment()).ifPresent(payment -> {
            this.payDate = DateUtil.format((LocalDateTime)payment.getPayDate(), (String)"yyyy-MM-dd HH:mm:ss");
        });
        this.remark = a.getRemark();
        this.comment = a.getComment();
    }

    public String getOrderCode() {
        return this.orderCode;
    }

    public void setOrderCode(String orderCode) {
        this.orderCode = orderCode;
    }

    public String getBillingPeriod() {
        return this.billingPeriod;
    }

    public void setBillingPeriod(String billingPeriod) {
        this.billingPeriod = billingPeriod;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getTeamName() {
        return this.teamName;
    }

    public void setTeamName(String teamName) {
        this.teamName = teamName;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public String getProductId() {
        return this.productId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public BigDecimal getTotalPrice() {
        return this.totalPrice;
    }

    public void setTotalPrice(BigDecimal totalPrice) {
        this.totalPrice = totalPrice;
    }

    public BigDecimal getPayPrice() {
        return this.payPrice;
    }

    public void setPayPrice(BigDecimal payPrice) {
        this.payPrice = payPrice;
    }

    public long getOverDueDays() {
        return this.overDueDays;
    }

    public void setOverDueDays(long overDueDays) {
        this.overDueDays = overDueDays;
    }

    public String getPayDate() {
        return this.payDate;
    }

    public void setPayDate(String payDate) {
        this.payDate = payDate;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getTenantName() {
        return this.tenantName;
    }

    public void setTenantName(String tenantName) {
        this.tenantName = tenantName;
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }
}

