/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.domain.excel;

import com.alibaba.excel.annotation.ExcelProperty;
import com.digiwin.dap.middleware.omc.domain.request.OrderVO;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

/*
 * Exception performing whole class analysis ignored.
 */
public class OrderAccountExcel {
    private static final DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    @ExcelProperty(value={"\u8ba2\u5355\u65e5\u671f"}, index=0)
    private String orderDate;
    @ExcelProperty(value={"\u652f\u4ed8\u65e5\u671f"}, index=1)
    private String payDate;
    @ExcelProperty(value={"\u8ba2\u5355\u7f16\u53f7"}, index=2)
    private String orderCode;
    @ExcelProperty(value={"\u5e94\u7528\u540d\u79f0(ID)"}, index=3)
    private String goodsContent;
    @ExcelProperty(value={"\u79df\u6237\u540d\u79f0(ID)"}, index=4)
    private String tenantContent;
    @ExcelProperty(value={"\u7528\u6237\u540d\u79f0(ID)"}, index=5)
    private String userContent;
    @ExcelProperty(value={"\u5e94\u4ed8\u91d1\u989d"}, index=6)
    private BigDecimal payPrice;
    @ExcelProperty(value={"\u5206\u6da6\u91d1\u989d"}, index=7)
    private BigDecimal profitShare;
    @ExcelProperty(value={"\u8d26\u52a1\u786e\u8ba4"}, index=8)
    private String accountConfirm;

    public OrderAccountExcel() {
    }

    public OrderAccountExcel(OrderVO o) {
        this.orderDate = OrderAccountExcel.getDateStr((LocalDateTime)o.getCreateDate());
        this.payDate = OrderAccountExcel.getDateStr(o.getPayment() == null ? null : o.getPayment().getPayDate());
        this.orderCode = o.getOrderCode();
        this.goodsContent = String.format("%s(%s)", o.getFirstOrderDetail().getGoodsName(), o.getFirstOrderDetail().getGoodsCode());
        this.tenantContent = String.format("%s(%s)", o.getTenantName(), o.getTenantId());
        this.userContent = String.format("%s(%s)", o.getUserName(), o.getUserId());
        this.payPrice = o.getPayPrice();
        this.profitShare = o.getProfitShare();
        this.accountConfirm = o.isAccountConfirm() ? "\u5df2\u786e\u8ba4" : "\u672a\u786e\u8ba4";
    }

    private static String getDateStr(LocalDateTime date) {
        try {
            return dtf.format(date);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getOrderDate() {
        return this.orderDate;
    }

    public void setOrderDate(String orderDate) {
        this.orderDate = orderDate;
    }

    public String getPayDate() {
        return this.payDate;
    }

    public void setPayDate(String payDate) {
        this.payDate = payDate;
    }

    public String getOrderCode() {
        return this.orderCode;
    }

    public void setOrderCode(String orderCode) {
        this.orderCode = orderCode;
    }

    public String getGoodsContent() {
        return this.goodsContent;
    }

    public void setGoodsContent(String goodsContent) {
        this.goodsContent = goodsContent;
    }

    public String getTenantContent() {
        return this.tenantContent;
    }

    public void setTenantContent(String tenantContent) {
        this.tenantContent = tenantContent;
    }

    public String getUserContent() {
        return this.userContent;
    }

    public void setUserContent(String userContent) {
        this.userContent = userContent;
    }

    public BigDecimal getPayPrice() {
        return this.payPrice;
    }

    public void setPayPrice(BigDecimal payPrice) {
        this.payPrice = payPrice;
    }

    public BigDecimal getProfitShare() {
        return this.profitShare;
    }

    public void setProfitShare(BigDecimal profitShare) {
        this.profitShare = profitShare;
    }

    public String getAccountConfirm() {
        return this.accountConfirm;
    }

    public void setAccountConfirm(String accountConfirm) {
        this.accountConfirm = accountConfirm;
    }
}

