/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.omc.domain.excel;

import com.alibaba.excel.annotation.ExcelProperty;
import com.digiwin.dap.middleware.commons.util.StrUtils;
import com.digiwin.dap.middleware.omc.constant.enums.preorder.PreOrderStateExcelEnum;
import com.digiwin.dap.middleware.omc.constant.enums.preorder.PreOrderTypeExcelEnum;
import com.digiwin.dap.middleware.omc.constant.enums.preorder.ShipmentScenarioEnum;
import com.digiwin.dap.middleware.omc.domain.response.PreOrderDetailVO;
import com.digiwin.dap.middleware.omc.domain.response.PreOrderVO;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.StringJoiner;
import java.util.stream.Collectors;

/*
 * Exception performing whole class analysis ignored.
 */
public class PreOrderExcel {
    @ExcelProperty(value={"\u79df\u6237\u540d\u79f0(ID)"}, index=0)
    private String tenantContent;
    @ExcelProperty(value={"\u4ea7\u54c1\u540d\u79f0(ID)"}, index=1)
    private String goodsContent;
    @ExcelProperty(value={"\u9500\u552e\u65b9\u6848"}, index=2)
    private String strategyName;
    @ExcelProperty(value={"\u6765\u6e90\u7c7b\u578b"}, index=3)
    private String orderType;
    @ExcelProperty(value={"\u5f00\u901a\u5355\u53f7"}, index=4)
    private String orderCode;
    @ExcelProperty(value={"\u72b6\u6001"}, index=5)
    private String authorization;
    @ExcelProperty(value={"\u6765\u6e90\u5355\u53f7"}, index=6)
    private String sourceBillCode;
    @ExcelProperty(value={"\u6388\u6743\u5f00\u59cb\u65e5\u671f"}, index=7)
    private String effectiveDateTime;
    @ExcelProperty(value={"\u6388\u6743\u7ed3\u675f\u65e5\u671f"}, index=8)
    private String expiredDateTime;
    @ExcelProperty(value={"\u521b\u5efa\u65e5\u671f"}, index=9)
    private String createDate;
    @ExcelProperty(value={"\u521b\u5efa\u4eba"}, index=10)
    private String createById;
    @ExcelProperty(value={"\u51fa\u8d27\u573a\u666f"}, index=11)
    private String shipmentScenario;
    @ExcelProperty(value={"\u79df\u6237sid"}, index=12)
    private String tenantSid;
    @ExcelProperty(value={"\u6f5c\u5ba2\u4ee3\u53f7"}, index=13)
    private String potentialCustomerId;
    @ExcelProperty(value={"\u4e1a\u52a1mail"}, index=14)
    private String operatorMail;
    @ExcelProperty(value={"\u5907\u6ce8"}, index=15)
    private String remark;

    public String getShipmentScenario() {
        return this.shipmentScenario;
    }

    public void setShipmentScenario(String shipmentScenario) {
        this.shipmentScenario = this.convertToName(shipmentScenario);
    }

    private String convertToName(String shipmentScenario) {
        if (StrUtils.isEmpty((String)shipmentScenario)) {
            return shipmentScenario;
        }
        StringJoiner joiner = new StringJoiner(",");
        for (String code : shipmentScenario.split(",")) {
            joiner.add(ShipmentScenarioEnum.getName((String)code));
        }
        return joiner.toString();
    }

    public String getTenantSid() {
        return this.tenantSid;
    }

    public void setTenantSid(String tenantSid) {
        this.tenantSid = tenantSid;
    }

    public String getTenantContent() {
        return this.tenantContent;
    }

    public void setTenantContent(String tenantContent) {
        this.tenantContent = tenantContent;
    }

    public String getGoodsContent() {
        return this.goodsContent;
    }

    public void setGoodsContent(String goodsContent) {
        this.goodsContent = goodsContent;
    }

    public String getStrategyName() {
        return this.strategyName;
    }

    public void setStrategyName(String strategyName) {
        this.strategyName = strategyName;
    }

    public String getOrderType() {
        return this.orderType;
    }

    public void setOrderType(String orderType) {
        this.orderType = orderType;
    }

    public String getOrderCode() {
        return this.orderCode;
    }

    public void setOrderCode(String orderCode) {
        this.orderCode = orderCode;
    }

    public String getAuthorization() {
        return this.authorization;
    }

    public void setAuthorization(String authorization) {
        this.authorization = authorization;
    }

    public String getSourceBillCode() {
        return this.sourceBillCode;
    }

    public void setSourceBillCode(String sourceBillCode) {
        this.sourceBillCode = sourceBillCode;
    }

    public String getEffectiveDateTime() {
        return this.effectiveDateTime;
    }

    public void setEffectiveDateTime(String effectiveDateTime) {
        this.effectiveDateTime = effectiveDateTime;
    }

    public String getExpiredDateTime() {
        return this.expiredDateTime;
    }

    public void setExpiredDateTime(String expiredDateTime) {
        this.expiredDateTime = expiredDateTime;
    }

    public String getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(String createDate) {
        this.createDate = createDate;
    }

    public String getCreateById() {
        return this.createById;
    }

    public void setCreateById(String createById) {
        this.createById = createById;
    }

    public String getRemark() {
        return this.remark;
    }

    public String getPotentialCustomerId() {
        return this.potentialCustomerId;
    }

    public void setPotentialCustomerId(String potentialCustomerId) {
        this.potentialCustomerId = potentialCustomerId;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getOperatorMail() {
        return this.operatorMail;
    }

    public void setOperatorMail(String operatorMail) {
        this.operatorMail = operatorMail;
    }

    public static PreOrderExcel generate(PreOrderVO preOrderVO) {
        PreOrderExcel preOrderExcel = new PreOrderExcel();
        preOrderExcel.setTenantContent(String.format("%s(%s)", preOrderVO.getTenantName(), preOrderVO.getTenantId()));
        preOrderExcel.setGoodsContent(String.format("%s(%s)", preOrderVO.getFirstOrderDetail().getGoodsName(), preOrderVO.getFirstOrderDetail().getGoodsCode()));
        preOrderExcel.setOrderCode(preOrderVO.getOrderCode());
        preOrderExcel.setSourceBillCode(preOrderVO.getSourceBillCode());
        preOrderExcel.setOrderType(preOrderVO.getOrderType() == 0 ? PreOrderTypeExcelEnum.STATE_0.getMessage() : PreOrderTypeExcelEnum.STATE_1.getMessage());
        preOrderExcel.setAuthorization(PreOrderStateExcelEnum.getMultiLanguageName((Integer)preOrderVO.getFirstOrderDetail().getAuthorization()));
        String strategyName = preOrderVO.getDetails().stream().map(PreOrderDetailVO::getStrategyName).filter(x -> x != null).collect(Collectors.joining(";"));
        preOrderExcel.setStrategyName(strategyName);
        preOrderExcel.setEffectiveDateTime(PreOrderExcel.getDateStr((LocalDateTime)preOrderVO.getFirstOrderDetail().getEffectiveDateTime()));
        preOrderExcel.setExpiredDateTime(PreOrderExcel.getDateStr((LocalDateTime)preOrderVO.getFirstOrderDetail().getExpiredDateTime()));
        preOrderExcel.setCreateById(preOrderVO.getCreateById());
        preOrderExcel.setCreateDate(PreOrderExcel.getDateStr((LocalDateTime)preOrderVO.getCreateDate()));
        preOrderExcel.setTenantSid(String.valueOf(preOrderVO.getTenantSid()));
        preOrderExcel.setShipmentScenario(preOrderVO.getShipmentScenario());
        preOrderExcel.setRemark(preOrderVO.getRemark());
        preOrderExcel.setPotentialCustomerId(preOrderVO.getPotentialCustomerId());
        preOrderExcel.setOperatorMail(preOrderVO.getOperatorMail());
        return preOrderExcel;
    }

    private static String getDateStr(LocalDateTime date) {
        try {
            DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            return dtf.format(date);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

